/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.SubItem;
import com.archimed.tool.StringTool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class ExtendedNegotiationSubItem
extends SubItem {
    private int itemtype = 86;
    private UIDEntry uidentry;
    private byte[] applicationinfo = new byte[0];

    public ExtendedNegotiationSubItem() {
    }

    public ExtendedNegotiationSubItem(UIDEntry uidentry, byte[] applicationinfo) {
        if (applicationinfo == null) {
            throw new NullPointerException();
        }
        this.uidentry = uidentry;
        this.applicationinfo = applicationinfo;
    }

    public byte[] getApplicationInfo() {
        return this.applicationinfo;
    }

    public UIDEntry getUIDEntry() {
        return this.uidentry;
    }

    public int getLength() {
        return 6 + this.uidentry.getValue().length() + this.applicationinfo.length;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(2 + this.uidentry.getValue().length() + this.applicationinfo.length);
        out.writeChar(this.uidentry.getValue().length());
        out.write(this.uidentry.getValue().getBytes());
        out.write(this.applicationinfo);
    }

    public int read(DataInputStream in) throws IOException, IllegalValueException, UnknownUIDException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("itemtype field of received Implementation Version Name Item  not " + this.itemtype);
        }
        in.read();
        char length = in.readChar();
        char soplength = in.readChar();
        byte[] buffer = new byte[soplength];
        in.read(buffer);
        buffer = StringTool.trimZeros(buffer);
        String sopvalue = new String(buffer);
        try {
            this.uidentry = UID.getUIDEntry(sopvalue);
        }
        catch (UnknownUIDException e) {
            this.uidentry = new UIDEntry(0, sopvalue, "unknown uid", "??", 1);
        }
        this.applicationinfo = new byte[length - soplength - 2];
        in.read(this.applicationinfo);
        return 4 + length;
    }
}

