/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.network.Command;
import com.archimed.dicom.network.ULServiceMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Dimse
implements ULServiceMessage {
    private int presentationContextId;
    private Command command;
    private DicomObject dataset;
    private InputStream in;
    private OutputStream out;
    private int ts;
    private boolean deferredWriting = false;

    Dimse(int pcId, Command command2, InputStream in) {
        this.presentationContextId = pcId;
        this.command = command2;
        this.in = in;
        this.ts = this.ts;
    }

    public Dimse(int pcId, Command command2, DicomObject dataset) {
        this.presentationContextId = pcId;
        this.command = command2;
        this.dataset = dataset;
    }

    public int getMessageType() {
        return 1004;
    }

    public int getPresentationContextId() {
        return this.presentationContextId;
    }

    public Command getCommand() {
        return this.command;
    }

    public DicomObject getDataSet() throws IOException, DicomException {
        if (this.dataset != null) {
            return this.dataset;
        }
        if (this.in == null) {
            return null;
        }
        this.dataset = new DicomObject();
        this.dataset.read(this.in, this.ts, true);
        this.in.close();
        this.in = null;
        return this.dataset;
    }

    boolean hasDataSet() {
        return this.dataset != null || this.in != null;
    }

    public InputStream getDataSetInputStream() {
        return this.in;
    }

    void setDatasetTransferSyntax(int ts) {
        this.ts = ts;
    }

    public OutputStream getDataSetOutputStream() {
        return this.out;
    }

    void setDataSetOutputStream(OutputStream out) {
        this.out = out;
    }

    public boolean isDeferredWriting() {
        return this.deferredWriting;
    }

    public void setDeferredWriting(boolean deferredWriting) {
        this.deferredWriting = deferredWriting;
    }
}

