/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.SOPClass;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;

public class Command
extends DicomObject {
    public static final int N_EVENT_REPORT_REQUEST = 256;
    public static final int N_EVENT_REPORT_RESPONSE = 33024;
    public static final int N_GET_REQUEST = 272;
    public static final int N_GET_RESPONSE = 33040;
    public static final int N_SET_REQUEST = 288;
    public static final int N_SET_RESPONSE = 33056;
    public static final int N_ACTION_REQUEST = 304;
    public static final int N_ACTION_RESPONSE = 33072;
    public static final int N_CREATE_REQUEST = 320;
    public static final int N_CREATE_RESPONSE = 33088;
    public static final int N_DELETE_REQUEST = 336;
    public static final int N_DELETE_RESPONSE = 33104;
    public static final int C_STORE_REQUEST = 1;
    public static final int C_STORE_RESPONSE = 32769;
    public static final int C_GET_REQUEST = 16;
    public static final int C_GET_RESPONSE = 32784;
    public static final int C_FIND_REQUEST = 32;
    public static final int C_FIND_RESPONSE = 32800;
    public static final int C_MOVE_REQUEST = 33;
    public static final int C_MOVE_RESPONSE = 32801;
    public static final int C_ECHO_REQUEST = 48;
    public static final int C_ECHO_RESPONSE = 32816;
    public static final int C_CANCEL_REQUEST = 4095;
    public static final int MEDIUM_PRIORITY = 0;
    public static final int HIGH_PRIORITY = 1;
    public static final int LOW_PRIORITY = 2;

    Command() {
    }

    public int getCommandType() throws DicomException {
        return this.parseAsInt(3);
    }

    public void setCommandType(int commandType) throws DicomException {
        this.set(3, new Integer(commandType));
    }

    public int getMessageID() throws DicomException {
        return this.parseAsInt(4);
    }

    public void setMessageID(int messageID) throws DicomException {
        this.set(4, new Integer(messageID));
    }

    public int getResponseMessageID() throws DicomException {
        return this.parseAsInt(5);
    }

    public void setResponseMessageID(int messageID) throws DicomException {
        this.set(5, new Integer(messageID));
    }

    public int getStatus() throws DicomException {
        return this.parseAsInt(9);
    }

    public void setStatus(int status) throws DicomException {
        this.set(9, new Integer(status));
    }

    public int getAffectedSOPClass() throws DicomException {
        return this.parseAsSOPClass(1);
    }

    public void setAffectedSOPClass(int affectedSOPClassUID) throws DicomException {
        try {
            this.set(1, UID.getUIDEntry(affectedSOPClassUID).getValue());
        }
        catch (IllegalValueException ex) {
            DicomException dcmex = new DicomException(ex + "");
            dcmex.initCause(ex);
            throw dcmex;
        }
    }

    public int getRequestedSOPClass() throws DicomException {
        return this.parseAsSOPClass(2);
    }

    public void setRequestedSOPClass(int requestedSOPClassUID) throws DicomException {
        try {
            this.set(2, UID.getUIDEntry(requestedSOPClassUID).getValue());
        }
        catch (IllegalValueException ex) {
            DicomException dcmex = new DicomException(ex + "");
            dcmex.initCause(ex);
            throw dcmex;
        }
    }

    public String getAffectedSOPInstance() throws DicomException {
        return this.parseAsString(13);
    }

    public void setRequestedSOPInstance(String sopInstanceUID) throws DicomException {
        this.set(14, sopInstanceUID);
    }

    public String getRequestedSOPInstance() throws DicomException {
        return this.parseAsString(14);
    }

    public void setAffectedSOPInstance(String sopInstanceUID) throws DicomException {
        this.set(13, sopInstanceUID);
    }

    public void hasData(boolean b) throws DicomException {
        if (!b) {
            this.set(8, new Integer(257));
        } else {
            this.set(8, new Integer(0));
        }
    }

    public boolean hasData() throws DicomException {
        Object o = this.get(8);
        if (o == null) {
            throw new DicomException(this.errorString(8, "tag value missing"));
        }
        return (Integer)o != 257;
    }

    public int getPriority() throws DicomException {
        return this.parseAsInt(7);
    }

    public void setPriority(int priority) throws DicomException {
        this.set(7, new Integer(priority));
    }

    public String getMoveOriginatorAE() throws DicomException {
        return this.parseAsString(23);
    }

    public void setMoveOriginatorAE(String moveAE) throws DicomException {
        this.set(23, moveAE);
    }

    public int getRemainingSuboperations() throws DicomException {
        return this.parseAsInt(19, false);
    }

    public void setRemainingSuboperations(int remainingSubops) throws DicomException {
        this.set(19, new Integer(remainingSubops));
    }

    public int getCompletedSuboperations() throws DicomException {
        return this.parseAsInt(20, false);
    }

    public void setCompletedSuboperations(int completedSubops) throws DicomException {
        this.set(20, new Integer(completedSubops));
    }

    public int getFailedSuboperations() throws DicomException {
        return this.parseAsInt(21, false);
    }

    public void setFailedSuboperations(int failedSubops) throws DicomException {
        this.set(21, new Integer(failedSubops));
    }

    public int getWarningSuboperations() throws DicomException {
        return this.parseAsInt(22, false);
    }

    public void setWarningSuboperations(int warningSubops) throws DicomException {
        this.set(22, new Integer(warningSubops));
    }

    public int getMoveOriginatorID() throws DicomException {
        return this.parseAsInt(24);
    }

    public void setMoveOriginatorMessageID(int moveOriginatorMessageID) throws DicomException {
        this.set(24, new Integer(moveOriginatorMessageID));
    }

    public void setMoveDestination(String moveDestinationAE) throws DicomException {
        this.set(6, moveDestinationAE);
    }

    public int getEventTypeID() throws DicomException {
        return this.parseAsInt(15, false);
    }

    public void setEventTypeID(int eventTypeID) throws DicomException {
        this.set(15, new Integer(eventTypeID));
    }

    public int getActionTypeID() throws DicomException {
        return this.parseAsInt(18, false);
    }

    public void setActionTypeID(int actionTypeID) throws DicomException {
        this.set(18, new Integer(actionTypeID));
    }

    public String getCommandName() throws DicomException {
        int commandType = this.getCommandType();
        switch (commandType) {
            case 256: {
                return "N-EVENT-REPORT-REQUEST";
            }
            case 33024: {
                return "N-EVENT-REPORT-RESPONSE";
            }
            case 272: {
                return "N-GET-REQUEST";
            }
            case 33040: {
                return "N-GET-RESPONSE";
            }
            case 288: {
                return "N-SET-REQUEST";
            }
            case 33056: {
                return "N-SET-RESPONSE";
            }
            case 304: {
                return "N-ACTION-REQUEST";
            }
            case 33072: {
                return "N-ACTION-RESPONSE";
            }
            case 320: {
                return "N-CREATE-REQUEST";
            }
            case 33088: {
                return "N-CREATE-RESPONSE";
            }
            case 336: {
                return "N-DELETE-REQUEST";
            }
            case 33104: {
                return "N-DELETE-RESPONSE";
            }
            case 1: {
                return "C-STORE-REQUEST";
            }
            case 32769: {
                return "C-STORE-RESPONSE";
            }
            case 16: {
                return "C-GET-REQUEST";
            }
            case 32784: {
                return "C-GET-RESPONSE";
            }
            case 32: {
                return "C-FIND-REQUEST";
            }
            case 32800: {
                return "C-FIND-RESPONSE";
            }
            case 33: {
                return "C-MOVE-REQUEST";
            }
            case 32801: {
                return "C-MOVE-RESPONSE";
            }
            case 48: {
                return "C-ECHO-REQUEST";
            }
            case 32816: {
                return "C-ECHO-RESPONSE";
            }
            case 4095: {
                return "C-CANCEL-REQUEST";
            }
        }
        throw new DicomException("Unknown command field: " + commandType);
    }

    private static Command newReqCommand(int commandType, int messageID, boolean hasData, int sopClassUID) throws DicomException {
        Command cmd = new Command();
        cmd.setCommandType(commandType);
        cmd.hasData(hasData);
        cmd.setMessageID(messageID);
        switch (commandType) {
            case 272: 
            case 288: 
            case 304: 
            case 336: {
                cmd.setRequestedSOPClass(sopClassUID);
                break;
            }
            default: {
                cmd.setAffectedSOPClass(sopClassUID);
            }
        }
        return cmd;
    }

    private static Command newResCommand(int commandType, int messageID, boolean hasData, int affectedSOPClassUID) throws DicomException {
        Command cmd = new Command();
        cmd.setCommandType(commandType);
        cmd.hasData(hasData);
        cmd.setResponseMessageID(messageID);
        cmd.setAffectedSOPClass(affectedSOPClassUID);
        return cmd;
    }

    public static Command createCEchoReq(int messageID, int affectedSOPClassUID) throws DicomException {
        Command cmd = Command.newReqCommand(48, messageID, false, affectedSOPClassUID);
        return cmd;
    }

    public static Command createCEchoRes(Command cechoreqcmd, int status) throws DicomException {
        Command cmd = Command.newResCommand(32816, cechoreqcmd.getMessageID(), false, cechoreqcmd.getAffectedSOPClass());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createCStoreReq(int messageID, int affectedSOPClassUID, int priority, String affectedSOPInstanceUID) throws DicomException {
        Command cmd = Command.newReqCommand(1, messageID, true, affectedSOPClassUID);
        cmd.setAffectedSOPInstance(affectedSOPInstanceUID);
        cmd.setPriority(priority);
        return cmd;
    }

    public static Command createCStoreRes(Command cStoreReq, int status) throws DicomException {
        Command cmd = Command.newResCommand(32769, cStoreReq.getMessageID(), false, cStoreReq.getAffectedSOPClass());
        cmd.setAffectedSOPInstance(cStoreReq.getAffectedSOPInstance());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createCFindReq(int messageID, int affectedSOPClassUID, int priority) throws DicomException {
        Command cmd = Command.newReqCommand(32, messageID, true, affectedSOPClassUID);
        cmd.setPriority(priority);
        return cmd;
    }

    public static Command createCFindRes(Command cFindReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(32800, cFindReq.getMessageID(), identifier, cFindReq.getAffectedSOPClass());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createCCancel(Command cReq) throws DicomException {
        Command cmd = new Command();
        cmd.setCommandType(4095);
        cmd.hasData(false);
        cmd.setResponseMessageID(cReq.getMessageID());
        return cmd;
    }

    public static Command createCGetReq(int messageID, int affectedSOPClassUID, int priority) throws DicomException {
        Command cmd = Command.newReqCommand(16, messageID, true, affectedSOPClassUID);
        cmd.setPriority(priority);
        return cmd;
    }

    public static Command createCGetRes(Command cGetReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(32784, cGetReq.getMessageID(), identifier, cGetReq.getAffectedSOPClass());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createCMoveReq(int messageID, int affectedSOPClassUID, int priority, String moveDestinationAE) throws DicomException {
        Command cmd = Command.newReqCommand(33, messageID, true, affectedSOPClassUID);
        cmd.setPriority(priority);
        cmd.setMoveDestination(moveDestinationAE);
        return cmd;
    }

    public static Command createCMoveRes(Command cMoveReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(32801, cMoveReq.getMessageID(), identifier, cMoveReq.getAffectedSOPClass());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createNEventReportReq(int messageID, int affectedSOPClassUID, String affectedSOPInstanceUID, int eventTypeID, boolean identifier) throws DicomException {
        Command cmd = Command.newReqCommand(256, messageID, identifier, affectedSOPClassUID);
        cmd.setAffectedSOPInstance(affectedSOPInstanceUID);
        cmd.setEventTypeID(eventTypeID);
        return cmd;
    }

    public static Command createNEventReportRes(Command nEventReportReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(33024, nEventReportReq.getMessageID(), identifier, nEventReportReq.getAffectedSOPClass());
        cmd.setStatus(status);
        cmd.hasData(identifier);
        return cmd;
    }

    public static Command createNGetReq(int messageID, int requestedSOPClassUID, String requestedSOPInstanceUID) throws DicomException {
        Command cmd = Command.newReqCommand(272, messageID, false, requestedSOPClassUID);
        cmd.setRequestedSOPInstance(requestedSOPInstanceUID);
        return cmd;
    }

    public static Command createNGetRes(Command nGetReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(33040, nGetReq.getMessageID(), identifier, nGetReq.getRequestedSOPClass());
        cmd.setRequestedSOPInstance(nGetReq.getRequestedSOPInstance());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createNSetReq(int messageID, int requestedSOPClassUID, String requestedSOPInstanceUID) throws DicomException {
        Command cmd = Command.newReqCommand(288, messageID, true, requestedSOPClassUID);
        cmd.setRequestedSOPInstance(requestedSOPInstanceUID);
        return cmd;
    }

    public static Command createNSetRes(Command nSetReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(33056, nSetReq.getMessageID(), identifier, nSetReq.getRequestedSOPClass());
        cmd.setAffectedSOPInstance(nSetReq.getRequestedSOPInstance());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createNActionReq(int messageID, int requestedSOPClassUID, String requestedSOPInstanceUID, int actionTypeID, boolean identifier) throws DicomException {
        Command cmd = Command.newReqCommand(304, messageID, identifier, requestedSOPClassUID);
        cmd.setRequestedSOPInstance(requestedSOPInstanceUID);
        cmd.setActionTypeID(actionTypeID);
        return cmd;
    }

    public static Command createNActionRes(Command nActionReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(33072, nActionReq.getMessageID(), identifier, nActionReq.getRequestedSOPClass());
        cmd.setAffectedSOPInstance(nActionReq.getRequestedSOPInstance());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createNCreateReq(int messageID, int affectedSOPClassUID, String affectedSOPInstanceUID, boolean identifier) throws DicomException {
        Command cmd = Command.newReqCommand(320, messageID, identifier, affectedSOPClassUID);
        cmd.setAffectedSOPInstance(affectedSOPInstanceUID);
        return cmd;
    }

    public static Command createNCreateRes(Command nCreateReq, int status, boolean identifier) throws DicomException {
        Command cmd = Command.newResCommand(33088, nCreateReq.getMessageID(), identifier, nCreateReq.getAffectedSOPClass());
        cmd.setAffectedSOPInstance(nCreateReq.getAffectedSOPInstance());
        cmd.setStatus(status);
        return cmd;
    }

    public static Command createNDeleteReq(int messageID, int requestedSOPClassUID, String requestedSOPInstanceUID) throws DicomException {
        Command cmd = Command.newReqCommand(336, messageID, false, requestedSOPClassUID);
        cmd.setRequestedSOPInstance(requestedSOPInstanceUID);
        return cmd;
    }

    public static Command createNDeleteRes(Command nDeleteReq, int status) throws DicomException {
        Command cmd = Command.newResCommand(33104, nDeleteReq.getMessageID(), false, nDeleteReq.getRequestedSOPClass());
        cmd.setAffectedSOPInstance(nDeleteReq.getRequestedSOPInstance());
        cmd.setStatus(status);
        return cmd;
    }

    private int parseAsInt(int tag2) throws DicomException {
        return this.parseAsInt(tag2, true);
    }

    private int parseAsInt(int tag2, boolean mandatory) throws DicomException {
        Object o = this.get(tag2);
        if (o == null) {
            if (mandatory) {
                throw new DicomException(this.errorString(tag2, "tag value missing"));
            }
            return -1;
        }
        return (Integer)o;
    }

    private String parseAsString(int tag2) throws DicomException {
        Object o = this.get(tag2);
        if (o == null) {
            throw new DicomException(this.errorString(tag2, "tag value missing"));
        }
        return (String)o;
    }

    private int parseAsSOPClass(int tag2) throws DicomException {
        Object o = this.get(tag2);
        if (o == null) {
            throw new DicomException(this.errorString(tag2, "tag value missing"));
        }
        try {
            return SOPClass.getUIDEntry((String)o).getConstant();
        }
        catch (UnknownUIDException ex) {
            throw new DicomException("SOP Class/Meta SOP Class '" + o + "' not found in dictionary");
        }
    }

    private String errorString(int tag2, String error) {
        StringBuffer sb = new StringBuffer();
        sb.append("unable to extract ");
        sb.append(DDict.getDescription(tag2));
        sb.append(" tag value from command");
        if (error != null) {
            sb.append(": ");
            sb.append(error);
        }
        return sb.toString();
    }
}

