/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.SubItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class AsynchronousOperationsWindowSubItem
extends SubItem {
    private int itemtype = 83;
    private int maxnumberopsinvoked;
    private int maxnumberopsperformed;

    public AsynchronousOperationsWindowSubItem() {
    }

    public AsynchronousOperationsWindowSubItem(int invoked, int performed) {
        this.maxnumberopsinvoked = invoked;
        this.maxnumberopsperformed = performed;
    }

    int getMaxNumberInvoked() {
        return this.maxnumberopsinvoked;
    }

    int getMaxNumberPerformed() {
        return this.maxnumberopsperformed;
    }

    void setMaxNumberInvoked(int n) {
        this.maxnumberopsinvoked = n;
    }

    void setMaxNumberPerformed(int n) {
        this.maxnumberopsperformed = n;
    }

    public int getLength() {
        return 8;
    }

    public int read(DataInputStream in) throws IOException, IllegalValueException {
        int b = in.read();
        if (b != this.itemtype) {
            throw new IllegalValueException("wrong itemtype of abstract syntax");
        }
        in.read();
        char length = in.readChar();
        if (length != '\u0004') {
            throw new IllegalValueException("length of AsynchronousOperationsWindowSubItem should be 4");
        }
        this.maxnumberopsinvoked = in.readChar();
        this.maxnumberopsperformed = in.readChar();
        return 8;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.itemtype);
        out.write(0);
        out.writeChar(4);
        out.writeChar(this.maxnumberopsinvoked);
        out.writeChar(this.maxnumberopsperformed);
    }
}

