/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.network.AbortException;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociationIOProgressListener;
import com.archimed.dicom.network.Dimse;
import com.archimed.dicom.network.DimseReader;
import com.archimed.dicom.network.DimseWriter;
import com.archimed.dicom.network.PDataTF;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduReader;
import com.archimed.dicom.network.PduWriter;
import com.archimed.dicom.network.PresentationContext;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ULServiceMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AssociationIO {
    private InputStream in;
    private PduReader pduReader;
    private DimseReader dimseReader;
    private OutputStream out;
    private PduWriter pduWriter;
    private DimseWriter dimseWriter;
    private int maxpdusize = -1;
    private int maxpdusize_received = -1;
    private boolean sequndeflen = true;
    private boolean groupLengths = true;
    private boolean separateDataPDU = true;
    private Acknowledge acknowledge;

    public AssociationIO(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.pduReader = new PduReader(in);
        this.dimseReader = new DimseReader(this.pduReader);
        this.pduWriter = new PduWriter(out);
        this.dimseWriter = new DimseWriter(out);
    }

    public ULServiceMessage read() throws IOException, PduException, AbortException, DicomException {
        Pdu pdu = this.pduReader.read();
        if (pdu.getType() == 1) {
            this.maxpdusize_received = ((Request)pdu).getMaxPduSize();
        } else if (pdu.getType() == 2) {
            this.maxpdusize_received = ((Acknowledge)pdu).getMaxPduSize();
            this.acknowledge = (Acknowledge)pdu;
        }
        if (pdu.getType() != 4) {
            return (ULServiceMessage)((Object)pdu);
        }
        ULServiceMessage ulServiceMessage = this.dimseReader.read((PDataTF)pdu);
        if (ulServiceMessage.getMessageType() != 1004) {
            throw new PduException("unexpected pdu received: " + ulServiceMessage);
        }
        Dimse dimse = (Dimse)ulServiceMessage;
        PresentationContext pc = this.acknowledge.findPresentationContext(dimse.getPresentationContextId());
        if (pc == null) {
            throw new PduException("received Dimse refers to unknown presentation context ID: " + dimse.getPresentationContextId());
        }
        if (pc.getResult() != 0) {
            throw new PduException("received Dimse refers to presentation context ID with different status than ACCEPTED");
        }
        dimse.setDatasetTransferSyntax(pc.getAcceptedTS().getConstant());
        return dimse;
    }

    public void write(ULServiceMessage ulServiceMessage) throws IOException, PduException, DicomException {
        if (ulServiceMessage.getMessageType() == 1002) {
            this.acknowledge = (Acknowledge)ulServiceMessage;
        }
        if (ulServiceMessage.getMessageType() != 1004) {
            this.pduWriter.write((Pdu)((Object)ulServiceMessage));
            return;
        }
        Dimse dimse = (Dimse)ulServiceMessage;
        PresentationContext pc = this.acknowledge.findPresentationContext(dimse.getPresentationContextId());
        if (pc == null) {
            throw new PduException("no presentation context found in Acknowledge with pc id: " + dimse.getPresentationContextId());
        }
        if (pc.getResult() != 0) {
            throw new PduException("presentation context specified in Dimse does not have status ACCEPTED");
        }
        int mp = this.maxpdusize == -1 ? this.maxpdusize_received : this.maxpdusize;
        if (mp == 0) {
            mp = 16384;
        }
        this.dimseWriter.write((Dimse)ulServiceMessage, mp, this.sequndeflen, this.separateDataPDU, pc.getAcceptedTS().getConstant(), this.groupLengths);
    }

    public boolean isSeparateDataPDU() {
        return this.separateDataPDU;
    }

    public void setSeparateDataPDU(boolean separateDataPDU) {
        this.separateDataPDU = separateDataPDU;
    }

    public boolean isWriteSeqUndefLength() {
        return this.sequndeflen;
    }

    public void setWriteSeqUndefLength(boolean sequndeflen) {
        this.sequndeflen = sequndeflen;
    }

    public int getMaxPduLength() {
        return this.maxpdusize;
    }

    public void setMaxPduLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be > 0");
        }
        this.maxpdusize = length;
    }

    public void addProgressListener(AssociationIOProgressListener progressListener) {
        this.dimseWriter.addProgressListener(progressListener);
    }

    public void removeProgressListener(AssociationIOProgressListener progressListener) {
        this.dimseWriter.removeProgressListener(progressListener);
    }

    public boolean isWriteGroupLengths() {
        return this.groupLengths;
    }

    public void setWriteGroupLengths(boolean groupLengths) {
        this.groupLengths = groupLengths;
    }
}

