/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.AbortPdu;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.AssociateAcknowledgePdu;
import com.archimed.dicom.network.AssociateRejectPdu;
import com.archimed.dicom.network.AssociateRequestPdu;
import com.archimed.dicom.network.PduOutputStream;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.log.JdtLogger;
import com.archimed.tool.RByteArrayOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

public class Association {
    private static final int COMMANDSET_RECEIVED = 8;
    private static final int DATASET_RECEIVED = 9;
    public static final int PDATA_PDU = 10;
    public static final int RELEASE_REQUEST = 11;
    public static final int ABORT = 12;
    public static final int RELEASE_RESPONSE = 13;
    public static final int ASSOCIATE_REQUEST = 14;
    public static final int ASSOCIATE_ACKNOWLEDGE = 15;
    public static final int ASSOCIATE_REJECT = 16;
    static String implclassuid = "1.2.826.0.1.3680043.2.60.0.1";
    static String implversionname = Jdt.DEFAULT_IMPLEMENTATION_VERSION_NAME;
    private String calledtitle;
    private String callingtitle;
    private int maxpdusizepeer;
    private InputStream in;
    private OutputStream out;
    private PushbackInputStream pbin;
    private Request request;
    private Acknowledge acknowledge;
    private ByteArrayOutputStream commandout;
    private ByteArrayOutputStream dataout;
    private AssociateRequestPdu arqpdu;
    private AssociateAcknowledgePdu ackpdu;
    private Vector pcritems;
    private boolean LAST_COMMAND = false;
    private boolean LAST_DATA = false;
    private int pcnumber;
    private boolean sequenceUndefLen = true;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Association.class);

    public Association(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.pbin = new PushbackInputStream(in);
        this.commandout = new ByteArrayOutputStream();
        this.dataout = new ByteArrayOutputStream();
    }

    public void setImplementationVersionName(String s) {
        implversionname = s;
    }

    public String getImplementationVersionName() {
        return implversionname;
    }

    public void setImplementationClassUID(String s) {
        implclassuid = s;
    }

    public String getImplementationClassUID() {
        return implclassuid;
    }

    public void setSequenceUndefLen(boolean sequenceUndefLen) {
        this.sequenceUndefLen = sequenceUndefLen;
    }

    public boolean isSequenceUndefLen() {
        return this.sequenceUndefLen;
    }

    public DicomObject receiveCommand() throws IOException, IllegalValueException, DicomException, UnknownUIDException {
        byte[] buf = this.receiveCommandAsByteArray();
        if (buf != null) {
            DicomObject commandset = new DicomObject();
            commandset.read(new ByteArrayInputStream(buf), 8193, true);
            buf = null;
            return commandset;
        }
        return null;
    }

    public byte[] receiveCommandAsByteArray() throws IOException, IllegalValueException {
        if (this.LAST_COMMAND) {
            byte[] buf = this.commandout.toByteArray();
            this.commandout.reset();
            this.LAST_COMMAND = false;
            return buf;
        }
        if (this.receive() == 8) {
            byte[] buf = this.commandout.toByteArray();
            this.commandout.reset();
            this.LAST_COMMAND = false;
            return buf;
        }
        return null;
    }

    public DicomObject receiveData() throws IOException, IllegalValueException, DicomException, UnknownUIDException {
        byte[] buf = this.receiveDataAsByteArray();
        int ts = 8193;
        int currentpc = this.getCurrentPresentationContext();
        this.log.debug("current presentation context: " + currentpc);
        try {
            if (this.acknowledge != null) {
                for (int i = 0; i < this.acknowledge.getPresentationContexts(); ++i) {
                    if (currentpc != this.acknowledge.getID(i)) continue;
                    ts = this.acknowledge.getTransferSyntax(i).getConstant();
                }
            }
            this.log.debug("current transfer syntax: " + TransferSyntax.getUIDEntry(ts).getName());
        }
        catch (Throwable e) {
            this.log.warn("could not derive transfer syntax from current pc " + currentpc + ", trying with ImplicitLittleEndian");
            this.log.error("", e);
        }
        if (buf != null) {
            DicomObject dataset = new DicomObject();
            dataset.read(new ByteArrayInputStream(buf), ts, true);
            buf = null;
            return dataset;
        }
        return null;
    }

    public byte[] receiveDataAsByteArray() throws IOException, IllegalValueException {
        if (this.LAST_DATA) {
            byte[] buf = this.dataout.toByteArray();
            this.dataout.reset();
            this.LAST_DATA = false;
            return buf;
        }
        if (this.receive() == 9) {
            byte[] buf = this.dataout.toByteArray();
            this.dataout.reset();
            this.LAST_DATA = false;
            return buf;
        }
        return null;
    }

    public void sendAssociateResponse(Response response) throws IOException, IllegalValueException {
        if (response instanceof Abort) {
            Abort abort = (Abort)response;
            AbortPdu abortpdu = new AbortPdu(abort.getSource(), abort.getReason());
            abortpdu.write(this.out);
        } else if (response instanceof Reject) {
            Reject reject = (Reject)response;
            AssociateRejectPdu arjpdu = new AssociateRejectPdu(reject.getResult(), reject.getSource(), reject.getReason());
            arjpdu.write(this.out);
        } else if (response instanceof Acknowledge) {
            this.acknowledge = (Acknowledge)response;
            this.ackpdu = new AssociateAcknowledgePdu(this.acknowledge);
            this.ackpdu.write(this.out);
            this.pcritems = this.ackpdu.getPresentationContextResponseItems();
        }
    }

    public void sendReleaseResponse() throws IOException, IllegalValueException {
        DataOutputStream dout = new DataOutputStream(this.out);
        this.out.write(6);
        this.out.write(0);
        dout.writeInt(4);
        dout.writeInt(0);
    }

    public void send(int abstractsyntaxuid, DicomObject commandset, DicomObject dataset) throws IOException, IllegalValueException, DicomException {
        int pcnumber = -1;
        UIDEntry absentry = UID.getUIDEntry(abstractsyntaxuid);
        if (absentry.getType() != 4 && absentry.getType() != 1) {
            throw new IllegalValueException("first argument should be Meta SOP Class or SOP Class");
        }
        block0: for (int i = 0; i < this.request.getPresentationContexts(); ++i) {
            absentry = this.request.getAbstractSyntax(i);
            if (absentry.getConstant() != abstractsyntaxuid) continue;
            pcnumber = this.request.getID(i);
            for (int j = 0; j < this.acknowledge.getPresentationContexts(); ++j) {
                int pcid = this.acknowledge.getID(j);
                if (pcid == pcnumber && this.acknowledge.getResult(j) == 0) break block0;
            }
        }
        if (pcnumber == -1) {
            throw new IllegalValueException("no accepted presentation context with specified abstract syntax");
        }
        this.sendInPresentationContext(pcnumber, commandset, dataset);
    }

    public void send(byte pcid, DicomObject commandset, DicomObject dataset) throws IOException, IllegalValueException, DicomException {
        this.sendInPresentationContext((int)pcid, commandset, dataset);
    }

    public void sendInPresentationContext(byte pcid, DicomObject commandset, DicomObject dataset) throws IOException, IllegalValueException, DicomException {
        this.sendInPresentationContext((int)pcid, commandset, dataset);
    }

    public void sendInPresentationContext(int pcid, DicomObject commandset, DicomObject dataset) throws IOException, IllegalValueException, DicomException {
        int index = -1;
        for (int i = 0; i < this.acknowledge.getPresentationContexts(); ++i) {
            if (pcid != this.acknowledge.getID(i)) continue;
            index = i;
        }
        if (index == -1) {
            throw new IllegalValueException("presentation context with specified id not present in Acknowledge");
        }
        if (this.acknowledge.getResult(index) != 0) {
            throw new IllegalValueException("not an accepted presentation context");
        }
        UIDEntry transfersyntax = this.acknowledge.getTransferSyntax(index);
        if (transfersyntax == null) {
            this.log.debug("transfer syntax null");
        }
        ByteArrayOutputStream commandout = new ByteArrayOutputStream();
        RByteArrayOutputStream dataout = new RByteArrayOutputStream();
        PduOutputStream pduout = new PduOutputStream(this.out, this.maxpdusizepeer, pcid, 1);
        commandset.write(pduout, false, 8193, this.sequenceUndefLen);
        pduout.close();
        if (dataset != null) {
            pduout = new PduOutputStream(this.out, this.maxpdusizepeer, pcid, 0);
            dataset.write(pduout, false, transfersyntax.getConstant(), true);
            pduout.close();
        }
    }

    private void send(byte[] buffer, int offset, int length, byte pcnumber, byte type) throws IOException {
        int remain;
        int pointer = offset;
        BufferedOutputStream bufout = new BufferedOutputStream(this.out, 8192);
        DataOutputStream d = new DataOutputStream(bufout);
        int increase = this.maxpdusizepeer != 0 ? this.maxpdusizepeer - 6 : remain;
        for (remain = length; remain > increase; remain -= increase) {
            d.writeByte(4);
            d.writeByte(0);
            d.writeInt(this.maxpdusizepeer);
            d.writeInt(this.maxpdusizepeer - 4);
            d.writeByte(pcnumber);
            d.writeByte(type);
            d.write(buffer, pointer, increase);
            pointer += increase;
        }
        d.writeByte(4);
        d.writeByte(0);
        d.writeInt(remain + 6);
        d.writeInt(remain + 2);
        d.writeByte(pcnumber);
        d.writeByte(type + 2);
        d.write(buffer, pointer, remain);
        bufout.flush();
    }

    public int peek() throws IOException, IllegalValueException {
        int b = this.pbin.read();
        if (b == -1) {
            throw new IOException("end of stream reached");
        }
        this.pbin.unread(b);
        if (b == 1) {
            return 14;
        }
        if (b == 2) {
            return 15;
        }
        if (b == 3) {
            return 16;
        }
        if (b == 4) {
            return 10;
        }
        if (b == 5) {
            return 11;
        }
        if (b == 6) {
            return 13;
        }
        if (b == 7) {
            return 12;
        }
        throw new IllegalValueException("Unexpected byte read: " + b);
    }

    private int receive() throws IOException, IllegalValueException {
        DataInputStream d = new DataInputStream(this.pbin);
        DataOutputStream dout = new DataOutputStream(this.out);
        int pdutype = 4;
        do {
            int b = this.pbin.read();
            this.log.debug("incoming PDU");
            this.log.debug("PDU type: " + b);
            if (b != pdutype) {
                throw new IllegalValueException("first byte of PDATA-PDU not 0x04 but '" + b + "'");
            }
            d.read();
            int remain = d.readInt();
            this.log.debug("PDU length: " + remain);
            while (remain > 0) {
                int itemlength = d.readInt();
                this.log.debug("item length: " + itemlength);
                byte[] buffer = new byte[itemlength - 2];
                remain = remain - itemlength - 4;
                this.pcnumber = d.readUnsignedByte();
                this.log.debug("presentation context id: " + this.pcnumber);
                byte header = d.readByte();
                this.log.debug("header value: " + header);
                d.readFully(buffer);
                if (header == 0) {
                    this.dataout.write(buffer, 0, buffer.length);
                    continue;
                }
                if (header == 1) {
                    this.commandout.write(buffer, 0, buffer.length);
                    continue;
                }
                if (header == 2) {
                    this.dataout.write(buffer, 0, buffer.length);
                    this.LAST_DATA = true;
                    continue;
                }
                if (header == 3) {
                    this.commandout.write(buffer, 0, buffer.length);
                    this.LAST_COMMAND = true;
                    continue;
                }
                throw new IllegalValueException("illegal value for header of PDV item");
            }
            if (!this.LAST_COMMAND) continue;
            return 8;
        } while (!this.LAST_DATA);
        return 9;
    }

    public int getCurrentPresentationContext() {
        return this.pcnumber;
    }

    public UIDEntry getCurrentAbstractSyntax() throws IllegalValueException {
        for (int i = 0; i < this.request.getPresentationContexts(); ++i) {
            if (this.pcnumber != this.request.getID(i)) continue;
            return this.request.getAbstractSyntax(i);
        }
        throw new IllegalValueException("no abstract syntax in request found for received presentation context id: " + this.pcnumber);
    }

    public Request receiveAssociateRequest() throws IOException, UnknownUIDException, IllegalValueException {
        this.arqpdu = new AssociateRequestPdu();
        this.arqpdu.read(this.pbin);
        this.maxpdusizepeer = this.arqpdu.getRequest().getMaxPduSize();
        this.request = this.arqpdu.getRequest();
        return this.request;
    }

    public Response receiveAssociateResponse() throws IOException, UnknownUIDException, IllegalValueException {
        int b = this.pbin.read();
        this.pbin.unread(b);
        if (b == 2) {
            this.ackpdu = new AssociateAcknowledgePdu();
            this.ackpdu.read(this.pbin);
            this.maxpdusizepeer = this.ackpdu.getAcknowledge().getMaxPduSize();
            this.pcritems = this.ackpdu.getPresentationContextResponseItems();
            this.acknowledge = this.ackpdu.getAcknowledge();
            return this.ackpdu.getAcknowledge();
        }
        if (b == 3) {
            AssociateRejectPdu rejpdu = new AssociateRejectPdu();
            rejpdu.read(this.pbin);
            return rejpdu.getReject();
        }
        if (b == 7) {
            AbortPdu abortpdu = new AbortPdu();
            abortpdu.read(this.pbin);
            return abortpdu.getAbort();
        }
        throw new IllegalValueException("first byte of PDATA-PDU not 0x04 but '" + b + "'");
    }

    public void sendAssociateRequest(Request req) throws IOException, IllegalValueException {
        this.request = req;
        this.request.setImplementationClassUID(implclassuid);
        this.request.setImplementationVersionName(implversionname);
        this.arqpdu = new AssociateRequestPdu(this.request);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        this.arqpdu.write(dout);
        this.out.write(bout.toByteArray());
    }

    public void sendReleaseRequest() throws IOException, IllegalValueException {
        DataOutputStream dout = new DataOutputStream(this.out);
        this.out.write(5);
        this.out.write(0);
        dout.writeInt(4);
        dout.writeInt(0);
    }

    public void receiveReleaseRequest() throws IOException, IllegalValueException {
        DataInputStream din = new DataInputStream(this.pbin);
        int b = this.pbin.read();
        if (b != 5) {
            throw new IllegalValueException("wrong first byte for expected Release Request: " + b);
        }
        this.pbin.read();
        din.readInt();
        din.readInt();
    }

    public void receiveReleaseResponse() throws IOException, IllegalValueException {
        DataInputStream din = new DataInputStream(this.pbin);
        int b = this.pbin.read();
        if (b != 6) {
            throw new IllegalValueException("wrong first byte for expected Release Response: " + b);
        }
        this.pbin.read();
        din.readInt();
        din.readInt();
    }

    public void sendAbort(int source, int reason) throws IOException {
        AbortPdu abortpdu = new AbortPdu(source, reason);
        abortpdu.write(this.out);
    }

    public Abort receiveAbort() throws IllegalValueException, IOException {
        AbortPdu abortpdu = new AbortPdu();
        abortpdu.read(this.pbin);
        return abortpdu.getAbort();
    }
}

