/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.AbstractSyntaxItem;
import com.archimed.dicom.network.ApplicationContextItem;
import com.archimed.dicom.network.AsynchronousOperationsWindowSubItem;
import com.archimed.dicom.network.ExtendedNegotiation;
import com.archimed.dicom.network.ExtendedNegotiationSubItem;
import com.archimed.dicom.network.ImplementationClassUIDSubItem;
import com.archimed.dicom.network.ImplementationVersionNameSubItem;
import com.archimed.dicom.network.MaximumLengthSubItem;
import com.archimed.dicom.network.PresentationContextItem;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.ScuScpRoleSubItem;
import com.archimed.dicom.network.SubItem;
import com.archimed.dicom.network.TransferSyntaxItem;
import com.archimed.dicom.network.UserIdentityNegotiationRequestSubItem;
import com.archimed.dicom.network.UserInfoItem;
import com.archimed.log.JdtLogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

class AssociateRequestPdu {
    private int pdutype = 1;
    private char protocolversion = '\u0001';
    String calledtitle;
    String callingtitle;
    ApplicationContextItem acitem;
    Vector pcitems;
    UserInfoItem uiitem;
    Request request;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(AssociateRequestPdu.class);

    public AssociateRequestPdu() {
        this.pcitems = new Vector();
    }

    public AssociateRequestPdu(Request request) throws IllegalValueException {
        UIDEntry asentry;
        this.request = request;
        this.calledtitle = request.getCalledTitle();
        this.callingtitle = request.getCallingTitle();
        this.pcitems = new Vector();
        this.acitem = new ApplicationContextItem();
        for (int i = 0; i < request.getPresentationContexts(); ++i) {
            asentry = request.getAbstractSyntax(i);
            AbstractSyntaxItem absitem = new AbstractSyntaxItem(asentry);
            Vector<TransferSyntaxItem> traitems = new Vector<TransferSyntaxItem>();
            for (int j = 0; j < request.getTransferSyntaxes(i); ++j) {
                traitems.addElement(new TransferSyntaxItem(request.getTransferSyntax(i, j)));
            }
            PresentationContextItem pcitem = new PresentationContextItem(request.getID(i), absitem, traitems);
            this.pcitems.addElement(pcitem);
        }
        this.uiitem = new UserInfoItem(true);
        MaximumLengthSubItem mlitem = new MaximumLengthSubItem(request.getMaxPduSize());
        ImplementationClassUIDSubItem icitem = new ImplementationClassUIDSubItem(request.getImplementationClassUID());
        ImplementationVersionNameSubItem ivitem = new ImplementationVersionNameSubItem(request.getImplementationVersionName());
        this.uiitem.addSubItem(mlitem);
        this.uiitem.addSubItem(icitem);
        this.uiitem.addSubItem(ivitem);
        for (int i = 0; i < request.getRoles(); ++i) {
            asentry = request.getAbstractSyntaxForRole(i);
            int scurole = request.getScuRole(asentry.getConstant());
            int scprole = request.getScpRole(asentry.getConstant());
            if (scurole == -1 || scprole == -1) continue;
            ScuScpRoleSubItem roleitem = new ScuScpRoleSubItem(asentry, scurole, scprole);
            this.uiitem.addSubItem(roleitem);
        }
        for (int i = 0; i < request.getPresentationContexts(); ++i) {
            byte[] data = request.getExtendedNegotiationData(i);
            if (data == null) continue;
            UIDEntry entry = request.getAbstractSyntax(i);
            ExtendedNegotiationSubItem extnegitem = new ExtendedNegotiationSubItem(entry, data);
            this.uiitem.addSubItem(extnegitem);
        }
        ExtendedNegotiation[] extendedNegotiations = request.getExtendedNegotiations();
        if (extendedNegotiations != null) {
            for (int i = 0; i < extendedNegotiations.length; ++i) {
                ExtendedNegotiationSubItem extnegitem = new ExtendedNegotiationSubItem(extendedNegotiations[i].getAbstractSyntax(), extendedNegotiations[i].getData());
                this.uiitem.addSubItem(extnegitem);
            }
        }
        if (request.getMaxOperationsInvoked() != 1 || request.getMaxOperationsPerformed() != 1) {
            AsynchronousOperationsWindowSubItem asyncitem = new AsynchronousOperationsWindowSubItem();
            asyncitem.setMaxNumberInvoked(request.getMaxOperationsInvoked());
            asyncitem.setMaxNumberPerformed(request.getMaxOperationsPerformed());
            this.uiitem.addSubItem(asyncitem);
        }
        if (request.getUserIdentityNegotiationRequest() != null) {
            this.uiitem.addSubItem(new UserIdentityNegotiationRequestSubItem(request.getUserIdentityNegotiationRequest()));
        }
    }

    public Request getRequest() throws IllegalValueException {
        return this.request;
    }

    private void fillRequest() {
        this.request = new Request();
        this.request.setCalledTitle(this.calledtitle);
        this.request.setCallingTitle(this.callingtitle);
        Vector subitems = this.uiitem.getSubItems();
        for (int i = 0; i < this.pcitems.size(); ++i) {
            PresentationContextItem pcitem = (PresentationContextItem)this.pcitems.elementAt(i);
            Vector transfersyntaxes = pcitem.getTransferSyntaxes();
            UIDEntry absentry = pcitem.getAbstractSyntaxItem().getAbstractSyntax();
            UIDEntry[] traentries = new UIDEntry[transfersyntaxes.size()];
            for (int j = 0; j < transfersyntaxes.size(); ++j) {
                traentries[j] = ((TransferSyntaxItem)transfersyntaxes.elementAt(j)).getTransferSyntax();
            }
            this.request.addPresentationContext(pcitem.getID(), absentry, traentries);
        }
        Vector<ExtendedNegotiation> exnegs = new Vector<ExtendedNegotiation>();
        for (int i = 0; i < subitems.size(); ++i) {
            SubItem subitem = (SubItem)subitems.elementAt(i);
            if (subitem instanceof ImplementationClassUIDSubItem) {
                this.request.setImplementationClassUID(((ImplementationClassUIDSubItem)subitem).getImplementationClassUID());
                continue;
            }
            if (subitem instanceof ImplementationVersionNameSubItem) {
                this.request.setImplementationVersionName(((ImplementationVersionNameSubItem)subitem).getImplementationVersionName());
                continue;
            }
            if (subitem instanceof MaximumLengthSubItem) {
                this.request.setMaxPduSize(((MaximumLengthSubItem)subitem).getMaxPduSize());
                continue;
            }
            if (subitem instanceof ScuScpRoleSubItem) {
                ScuScpRoleSubItem roleitem = (ScuScpRoleSubItem)subitem;
                try {
                    this.request.setScuScpRoleSelection(roleitem.getAbstractSyntax().getConstant(), roleitem.getScuRole(), roleitem.getScpRole());
                }
                catch (IllegalValueException ex) {
                    this.log.error("", ex);
                }
                continue;
            }
            if (subitem instanceof AsynchronousOperationsWindowSubItem) {
                AsynchronousOperationsWindowSubItem asyncitem = (AsynchronousOperationsWindowSubItem)subitem;
                this.request.setMaxOperationsInvoked(asyncitem.getMaxNumberInvoked());
                this.request.setMaxOperationsPerformed(asyncitem.getMaxNumberPerformed());
                continue;
            }
            if (subitem instanceof UserIdentityNegotiationRequestSubItem) {
                UserIdentityNegotiationRequestSubItem uidentity = (UserIdentityNegotiationRequestSubItem)subitem;
                this.request.setUserIdentityNegotiationRequest(uidentity.getUserIdentityNegotiationRequest());
                continue;
            }
            if (!(subitem instanceof ExtendedNegotiationSubItem)) continue;
            ExtendedNegotiationSubItem enitem = (ExtendedNegotiationSubItem)subitem;
            UIDEntry uidentry = enitem.getUIDEntry();
            for (int j = 0; j < this.request.getPresentationContexts(); ++j) {
                if (!this.request.getAbstractSyntax(j).getValue().equals(uidentry.getValue())) continue;
                this.request.setExtendedNegotiationData(j, enitem.getApplicationInfo());
            }
            ExtendedNegotiation en = new ExtendedNegotiation();
            en.setAbstractSyntax(enitem.getUIDEntry());
            en.setData(enitem.getApplicationInfo());
            exnegs.add(en);
        }
        ExtendedNegotiation[] extendedNegotiations = new ExtendedNegotiation[exnegs.size()];
        for (int i = 0; i < exnegs.size(); ++i) {
            extendedNegotiations[i] = (ExtendedNegotiation)exnegs.elementAt(i);
        }
        this.request.setExtendedNegotiations(extendedNegotiations);
    }

    public String getCalledTitle() {
        return this.calledtitle;
    }

    public String getCallingTitle() {
        return this.callingtitle;
    }

    public ApplicationContextItem getApplicationContextItem() {
        return this.acitem;
    }

    public Vector getPresentationContextItems() {
        return this.pcitems;
    }

    public UserInfoItem getUserInfoItem() {
        return this.uiitem;
    }

    public void setApplicationContextItem(ApplicationContextItem acitem) {
        this.acitem = acitem;
    }

    public void setUserInfoItem(UserInfoItem uiitem) {
        this.uiitem = uiitem;
    }

    public void addPresentationContextItem(PresentationContextItem pcitem) {
        this.pcitems.addElement(pcitem);
    }

    public int getLength() {
        int length = 0;
        length += 74;
        length += this.acitem.getLength();
        for (int i = 0; i < this.pcitems.size(); ++i) {
            length += ((PresentationContextItem)this.pcitems.elementAt(i)).getLength();
        }
        return length += this.uiitem.getLength();
    }

    public void write(OutputStream out) throws IOException {
        int i;
        DataOutputStream dout = new DataOutputStream(out);
        out.write(this.pdutype);
        out.write(0);
        dout.writeInt(this.getLength() - 6);
        dout.writeChar(1);
        dout.writeChar(0);
        out.write(this.calledtitle.getBytes());
        for (i = 0; i < 16 - this.calledtitle.length(); ++i) {
            out.write(32);
        }
        out.write(this.callingtitle.getBytes());
        for (i = 0; i < 16 - this.callingtitle.length(); ++i) {
            out.write(32);
        }
        out.write(new byte[32]);
        this.acitem.write(dout);
        for (i = 0; i < this.pcitems.size(); ++i) {
            ((PresentationContextItem)this.pcitems.elementAt(i)).write(dout);
        }
        this.uiitem.write(dout);
    }

    public void read(InputStream in) throws IOException, IllegalValueException, UnknownUIDException {
        PushbackInputStream pbin = new PushbackInputStream(in);
        DataInputStream din = new DataInputStream(pbin);
        int b = din.read();
        if (b != this.pdutype) {
            throw new IllegalValueException("PDU-type field of Associate Request PDU not " + this.pdutype);
        }
        din.read();
        int length = din.readInt();
        this.protocolversion = din.readChar();
        length -= 2;
        din.readChar();
        byte[] buf = new byte[16];
        din.readFully(buf);
        this.calledtitle = new String(buf);
        this.calledtitle = this.calledtitle.trim();
        din.readFully(buf);
        this.callingtitle = new String(buf);
        this.callingtitle = this.callingtitle.trim();
        din.readFully(new byte[32]);
        length -= 66;
        ApplicationContextItem acitem = new ApplicationContextItem();
        int r = acitem.read(din);
        length -= r;
        while (length > 0) {
            b = din.read();
            if (b == 32) {
                pbin.unread(32);
                PresentationContextItem pcitem = new PresentationContextItem();
                r = pcitem.read(din);
                this.pcitems.addElement(pcitem);
                length -= r;
                continue;
            }
            if (b != 80) continue;
            pbin.unread(80);
            this.uiitem = new UserInfoItem(true);
            r = this.uiitem.read(pbin);
            length -= r;
        }
        this.fillRequest();
    }
}

