/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.AssociateRejectPdu;
import com.archimed.dicom.network.Pdu;
import com.archimed.dicom.network.PduBuffer;
import com.archimed.dicom.network.PduException;
import com.archimed.dicom.network.PduParser;
import com.archimed.dicom.network.Reject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class AssociateRejectParser
implements PduParser {
    protected AssociateRejectParser() {
    }

    public void format(Pdu pdu, PduBuffer pduBuffer) throws PduException {
        if (pdu.getType() != 3 || !(pdu instanceof Reject)) {
            throw new PduException("class " + this.getClass().getName() + " can only format Associate Reject PDU");
        }
        try {
            Reject rej = (Reject)pdu;
            AssociateRejectPdu rejPdu = new AssociateRejectPdu(rej.getResult(), rej.getSource(), rej.getReason());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            rejPdu.write(bout);
            pduBuffer.setBytes(bout.toByteArray());
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }

    public Pdu parse(PduBuffer pduBuffer) throws PduException {
        AssociateRejectPdu rejPdu = new AssociateRejectPdu();
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(pduBuffer.getBytes(), 0, pduBuffer.getLength());
            rejPdu.read(bin);
            bin.close();
            return rejPdu.getReject();
        }
        catch (IllegalValueException ex) {
            throw new PduException(ex);
        }
        catch (IOException ex) {
            throw new PduException(ex);
        }
    }
}

