/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.network.ExtendedNegotiation;
import com.archimed.dicom.network.PresentationContext;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ULServiceMessage;
import com.archimed.dicom.network.UserIdentityNegotiationResponse;
import com.archimed.log.JdtLogger;
import com.archimed.tool.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class Acknowledge
extends Response
implements ULServiceMessage {
    public static final int NO_SUPPORT_SCU_ROLE = 0;
    public static final int SUPPORT_SCU_ROLE = 1;
    public static final int NO_SUPPORT_SCP_ROLE = 0;
    public static final int SUPPORT_SCP_ROLE = 1;
    public static final int DEFAULT = -1;
    public static final int ACCEPTANCE = 0;
    public static final int USER_REJECTION = 1;
    public static final int NO_REASON = 2;
    public static final int ABSTRACT_SYNTAX_NOT_SUPPORTED = 3;
    public static final int TRANSFER_SYNTAXES_NOT_SUPPORTED = 4;
    private String calledtitle;
    private String callingtitle;
    private ArrayList pcContexts;
    private HashMap pcContextsMap;
    private String implclassuid;
    private String implversionname;
    private ExtendedNegotiation[] extendedNegotiations;
    private int maxpdusize;
    private int maxopinvoked = 1;
    private int maxopperformed = 1;
    private Vector asroles;
    private Vector scuroles;
    private Vector scproles;
    private UserIdentityNegotiationResponse userIdentityNegotiationResponse;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Acknowledge.class);

    public Acknowledge() {
        this.pcContexts = new ArrayList();
        this.pcContextsMap = new HashMap();
        this.asroles = new Vector();
        this.scuroles = new Vector();
        this.scproles = new Vector();
        this.setImplementationClassUID(Jdt.getImplementationClassUID());
        this.setImplementationVersionName(Jdt.getImplementationVersionName());
    }

    public int getType() {
        return 2;
    }

    public int getMessageType() {
        return 1002;
    }

    public String getCallingTitle() {
        return this.callingtitle;
    }

    public String getCalledTitle() {
        return this.calledtitle;
    }

    public void setCalledTitle(String calledtitle) {
        this.calledtitle = calledtitle;
    }

    public void setCallingTitle(String callingtitle) {
        this.callingtitle = callingtitle;
    }

    public String getImplementationClassUID() {
        return this.implclassuid;
    }

    public String getImplementationVersionName() {
        return this.implversionname;
    }

    public void setImplementationClassUID(String s) {
        this.implclassuid = s;
    }

    public void setImplementationVersionName(String s) {
        this.implversionname = s;
    }

    public int getMaxPduSize() {
        return this.maxpdusize;
    }

    public void setMaxPduSize(int maxpdusize) {
        this.maxpdusize = maxpdusize;
    }

    public void setMaxOperationsInvoked(int n) {
        this.maxopinvoked = n;
    }

    public int getMaxOperationsInvoked() {
        return this.maxopinvoked;
    }

    public void setMaxOperationsPerformed(int n) {
        this.maxopperformed = n;
    }

    public int getMaxOperationsPerformed() {
        return this.maxopperformed;
    }

    public void setScuScpRoleSelection(int asid, int scurole, int scprole) throws IllegalValueException {
        UIDEntry asentry = UID.getUIDEntry(asid);
        int index = this.asroles.indexOf(asentry);
        if (index != -1) {
            this.scuroles.setElementAt(new Integer(scurole), index);
            this.scproles.setElementAt(new Integer(scprole), index);
        } else {
            this.asroles.addElement(asentry);
            this.scuroles.addElement(new Integer(scurole));
            this.scproles.addElement(new Integer(scprole));
        }
    }

    public int getScuRole(int asid) throws IllegalValueException {
        int index = this.asroles.indexOf(UID.getUIDEntry(asid));
        if (index == -1) {
            return -1;
        }
        return (Integer)this.scuroles.elementAt(index);
    }

    public int getScpRole(int asid) throws IllegalValueException {
        int index = this.asroles.indexOf(UID.getUIDEntry(asid));
        if (index == -1) {
            return -1;
        }
        return (Integer)this.scproles.elementAt(index);
    }

    UIDEntry getAbstractSyntaxForRole(int index) {
        return (UIDEntry)this.asroles.elementAt(index);
    }

    int getRoles() {
        return this.asroles.size();
    }

    public ExtendedNegotiation[] getExtendedNegotiations() {
        return this.extendedNegotiations;
    }

    public void setExtendedNegotiations(ExtendedNegotiation[] extendedNegotiations) {
        if (extendedNegotiations != null) {
            this.extendedNegotiations = extendedNegotiations;
        }
    }

    public PresentationContext getPresentationContext(int index) {
        return (PresentationContext)this.pcContexts.get(index);
    }

    public PresentationContext findPresentationContext(int pcid) {
        return (PresentationContext)this.pcContextsMap.get(new Integer(pcid));
    }

    public byte getPresentationContextID(int index) {
        return (byte)this.getPresentationContext(index).getID();
    }

    public int getID(int index) {
        return this.getPresentationContext(index).getID();
    }

    public int getResult(int index) {
        return this.getPresentationContext(index).getResult();
    }

    public int getPresentationContexts() {
        return this.pcContexts.size();
    }

    public UIDEntry getTransferSyntax(int index) {
        return this.getPresentationContext(index).getAcceptedTS();
    }

    public void addPresentationContext(byte id, int result, int tsid) throws IllegalValueException {
        this.addPresentationContext((int)id, result, tsid);
    }

    public void addPresentationContext(int id, int result, int tsid) throws IllegalValueException {
        UIDEntry tsentry = UID.getUIDEntry(tsid);
        PresentationContext pc = new PresentationContext(id, result, tsentry);
        this.pcContexts.add(pc);
        this.pcContextsMap.put(new Integer(pc.getID()), pc);
    }

    public UserIdentityNegotiationResponse getUserIdentityNegotiationResponse() {
        return this.userIdentityNegotiationResponse;
    }

    public void setUserIdentityNegotiationResponse(UserIdentityNegotiationResponse userIdentityNegotiationResponse) {
        this.userIdentityNegotiationResponse = userIdentityNegotiationResponse;
    }

    public String toString() {
        int w = 30;
        String s = "**************** ASSOCIATE ACKNOWLEDGE *****************\n";
        s = s + StringTool.fstr("implementation class UID:", w) + this.implclassuid + "\n";
        s = s + StringTool.fstr("implementation version name:", w) + this.implversionname + "\n";
        if (this.userIdentityNegotiationResponse != null) {
            s = s + "User Identity Negotiation\n";
            s = s + StringTool.fstr("  server reponse length:", w) + this.userIdentityNegotiationResponse.getServerResponse().length + "\n";
        }
        s = s + StringTool.fstr("max PDU size:", w) + this.maxpdusize + "\n";
        s = s + StringTool.fstr("max operations invoked:", w) + this.maxopinvoked + "\n";
        s = s + StringTool.fstr("max operations performed:", w) + this.maxopperformed + "\n";
        s = s + StringTool.fstr("# presentation contexts:", w) + this.pcContexts.size() + "\n";
        s = s + StringTool.fstr("nr", 5) + StringTool.fstr("pcid", 6) + StringTool.fstr("result", 32) + StringTool.fstr("transfer syntax", 20) + "\n";
        for (int i = 0; i < this.getPresentationContexts(); ++i) {
            if (this.getResult(i) == 0) {
                s = s + StringTool.fstr(i + "", 5) + StringTool.fstr("" + this.getID(i), 6) + StringTool.fstr("accepted", 32) + StringTool.fstr("" + this.getTransferSyntax(i).getShortName() + "(" + this.getTransferSyntax(i) + ")", 30) + "\n";
                continue;
            }
            if (this.getResult(i) == 3) {
                s = s + StringTool.fstr(i + "", 5) + StringTool.fstr("" + this.getID(i), 6) + StringTool.fstr("unsupported abstract syntax", 32) + "\n";
                continue;
            }
            if (this.getResult(i) == 4) {
                s = s + StringTool.fstr(i + "", 5) + StringTool.fstr("" + this.getID(i), 6) + StringTool.fstr("unsupported transfer syntaxes", 32) + "\n";
                continue;
            }
            if (this.getResult(i) == 1) {
                s = s + StringTool.fstr(i + "", 5) + StringTool.fstr("" + this.getID(i), 6) + StringTool.fstr("user rejection", 32) + "\n";
                continue;
            }
            if (this.getResult(i) != 2) continue;
            s = s + StringTool.fstr(i + "", 5) + StringTool.fstr("" + this.getID(i), 6) + StringTool.fstr("no reason", 32) + "\n";
        }
        s = s + "non-default roles set:\n";
        boolean b = false;
        try {
            for (int i = 0; i < this.getRoles(); ++i) {
                UIDEntry as = this.getAbstractSyntaxForRole(i);
                if (this.getScpRole(as.getConstant()) == -1 && this.getScuRole(as.getConstant()) == -1) continue;
                b = true;
                s = s + StringTool.fstr(as.getName() + "", 55);
                String t = "";
                if (this.getScuRole(as.getConstant()) == 1) {
                    t = "SCU";
                } else if (this.getScuRole(as.getConstant()) == 0) {
                    t = "NO-SCU";
                } else if (this.getScuRole(as.getConstant()) == -1) {
                    t = "DEFAULT";
                }
                t = t + "/";
                if (this.getScpRole(as.getConstant()) == 1) {
                    t = t + "SCP";
                } else if (this.getScpRole(as.getConstant()) == 0) {
                    t = t + "NO-SCP";
                } else if (this.getScpRole(as.getConstant()) == -1) {
                    t = t + "DEFAULT";
                }
                s = s + StringTool.fstr(t, 30) + "\n";
            }
            if (!b) {
                s = s + "none\n";
            }
        }
        catch (IllegalValueException ex) {
            this.log.error("", ex);
        }
        s = s + "********************************************************";
        return s;
    }
}

