/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.codec.Compression;
import com.archimed.dicom.image.DICOMImageConsumer;
import com.archimed.dicom.image.DicomImage;
import com.archimed.dicom.image.GrayColorModel;
import com.archimed.dicom.image.ImageUtils;
import com.archimed.log.JdtLogger;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.Vector;

public class ImageIO {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(ImageIO.class);
    DicomImage dcm;
    int w;
    int h;
    int ba;
    int bs;
    int f;
    int max;
    int pc;
    int mask;
    int pr;
    String pi;
    boolean decode = false;
    int encoding;

    void setEncoding(int ts) {
        switch (ts) {
            case 8193: 
            case 8194: 
            case 8195: {
                this.encoding = 0;
                break;
            }
            default: {
                this.encoding = ts;
            }
        }
    }

    Object getPixels(int j) {
        byte[] b_pix;
        if (this.encoding != 0) {
            try {
                return Compression.decompressFrame(this.encoding, (byte[])this.dcm.get(1184, j + 1), this.w, this.h);
            }
            catch (DicomException e) {
                this.log.error("", e);
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (this.f == 1) {
            b_pix = (byte[])this.dcm.get(1184);
        } else if (this.ba > 8) {
            b_pix = new byte[this.w * this.h * this.ba / 8];
            System.arraycopy(this.dcm.get(1184), this.w * this.h * j * this.ba / 8, b_pix, 0, this.w * this.h * this.ba / 8);
        } else if (this.pi.equals("RGB")) {
            b_pix = new byte[this.w * this.h * 3];
            System.arraycopy(this.dcm.get(1184), this.w * this.h * j * 3, b_pix, 0, this.w * this.h * 3);
        } else {
            b_pix = new byte[this.w * this.h];
            System.arraycopy(this.dcm.get(1184), this.w * this.h * j, b_pix, 0, this.w * this.h);
        }
        if (this.pi.equals("PALETTE COLOR")) {
            return b_pix;
        }
        if (this.pi.startsWith("MONOCHROME")) {
            if (this.ba == 8) {
                return b_pix;
            }
            if (this.ba == 16) {
                int[] i_pix = new int[this.w * this.h];
                if (this.pr == 1) {
                    int i = 0;
                    while (i < this.w * this.h) {
                        i_pix[i] = ImageUtils.unsign(b_pix[2 * i]);
                        int n = i;
                        i_pix[n] = i_pix[n] + ((b_pix[2 * i + 1] << 8) + 32768);
                        int n2 = i++;
                        i_pix[n2] = i_pix[n2] & this.mask;
                    }
                } else {
                    int i = 0;
                    while (i < this.w * this.h) {
                        i_pix[i] = ImageUtils.unsign(b_pix[2 * i]);
                        int n = i;
                        i_pix[n] = i_pix[n] + (ImageUtils.unsign(b_pix[2 * i + 1]) << 8);
                        int n3 = i++;
                        i_pix[n3] = i_pix[n3] & this.mask;
                    }
                }
                return i_pix;
            }
            if (this.ba == 24) {
                int[] i_pix = new int[this.w * this.h];
                int i = 0;
                while (i < this.w * this.h) {
                    i_pix[i] = ImageUtils.unsign(b_pix[3 * i]);
                    int n = i;
                    i_pix[n] = i_pix[n] + (ImageUtils.unsign(b_pix[3 * i + 1]) << 8);
                    int n4 = i;
                    i_pix[n4] = i_pix[n4] + (ImageUtils.unsign(b_pix[3 * i + 2]) << 16);
                    int n5 = i++;
                    i_pix[n5] = i_pix[n5] & this.mask;
                }
                return i_pix;
            }
            if (this.ba == 32) {
                int[] i_pix = new int[this.w * this.h];
                int i = 0;
                while (i < this.w * this.h) {
                    i_pix[i] = ImageUtils.unsign(b_pix[4 * i]);
                    int n = i;
                    i_pix[n] = i_pix[n] + (ImageUtils.unsign(b_pix[4 * i + 1]) << 8);
                    int n6 = i;
                    i_pix[n6] = i_pix[n6] + (ImageUtils.unsign(b_pix[4 * i + 2]) << 16);
                    int n7 = i;
                    i_pix[n7] = i_pix[n7] + (ImageUtils.unsign(b_pix[4 * i + 3]) << 24);
                    int n8 = i++;
                    i_pix[n8] = i_pix[n8] & this.mask;
                }
                return i_pix;
            }
            this.log.error("unhandled bits allocated: " + this.ba);
        }
        if (this.pi.equals("RGB")) {
            int[] i_pix = new int[this.w * this.h];
            if (this.pc == 0) {
                for (int i = 0; i < this.w * this.h; ++i) {
                    i_pix[i] = ImageUtils.unsign(b_pix[3 * i]) << 16;
                    int n = i;
                    i_pix[n] = i_pix[n] + (ImageUtils.unsign(b_pix[3 * i + 1]) << 8);
                    int n9 = i;
                    i_pix[n9] = i_pix[n9] + ImageUtils.unsign(b_pix[3 * i + 2]);
                }
            } else {
                for (int i = 0; i < this.w * this.h; ++i) {
                    i_pix[i] = ImageUtils.unsign(b_pix[i]) << 16;
                    int n = i;
                    i_pix[n] = i_pix[n] + (ImageUtils.unsign(b_pix[this.w * this.h + i]) << 8);
                    int n10 = i;
                    i_pix[n10] = i_pix[n10] + ImageUtils.unsign(b_pix[2 * this.w * this.h + i]);
                }
            }
            return i_pix;
        }
        return null;
    }

    byte[] getPalette(int paldata, int paldesc) throws DicomException {
        int nentries = this.dcm.getI(paldesc, 0);
        int firstpixel = this.dcm.getI(paldesc, 1);
        byte[] pal = new byte[256];
        int i = this.dcm.getSize(paldata);
        if (i == 1) {
            byte[] dicompal = (byte[])this.dcm.get(paldata);
            int palentry = ImageUtils.unsign(dicompal[0]);
            palentry += ImageUtils.unsign(dicompal[1]) << 8;
            for (i = 0; i < firstpixel; ++i) {
                pal[i] = (byte)(palentry >> 8);
            }
            for (int j = 0; j < nentries; ++j) {
                palentry = ImageUtils.unsign(dicompal[2 * j]);
                pal[j + firstpixel] = (byte)((palentry += ImageUtils.unsign(dicompal[2 * j + 1]) << 8) >> 8);
            }
        } else {
            int palentry = this.dcm.getI(paldata, 0);
            for (i = 0; i < firstpixel; ++i) {
                pal[i] = (byte)(palentry >> 8);
            }
            for (int j = 0; j < i; ++j) {
                palentry = this.dcm.getI(paldata, j);
                pal[j + firstpixel] = (byte)(palentry >> 8);
            }
        }
        return pal;
    }

    int calcMax(int[] pix) {
        int m = 0;
        for (int i = 0; i < pix.length; ++i) {
            if ((pix[i] & this.mask) <= m) continue;
            m = pix[i] & this.mask;
        }
        return m;
    }

    int calcMax(byte[] pix) {
        int m;
        block3: {
            block4: {
                block2: {
                    m = 0;
                    if (this.ba != 8) break block2;
                    m = 255;
                    break block3;
                }
                if (this.ba != 16) break block4;
                int pixel = 0;
                for (int i = 0; i < pix.length / 2; ++i) {
                    pixel = ImageUtils.unsign(pix[2 * i]) + (ImageUtils.unsign(pix[2 * i + 1]) << 8);
                    if ((pixel & this.mask) <= m) continue;
                    m = pixel & this.mask;
                }
                break block3;
            }
            if (this.ba != 32) break block3;
            int pixel = 0;
            for (int i = 0; i < pix.length / 4; ++i) {
                pixel = ImageUtils.unsign(pix[2 * i]) + (ImageUtils.unsign(pix[2 * i + 1]) << 8) + (ImageUtils.unsign(pix[2 * i + 2]) << 16) + (ImageUtils.unsign(pix[2 * i + 3]) << 24);
                if ((pixel & this.mask) <= m) continue;
                m = pixel & this.mask;
            }
        }
        return m;
    }

    public ImageIO(DicomImage d) throws DicomException {
        this.dcm = d;
        this.w = this.dcm.getI(467);
        this.h = this.dcm.getI(466);
        this.ba = this.dcm.getI(475);
        this.bs = this.dcm.getI(476);
        this.pr = this.dcm.getI(478);
        this.mask = (1 << this.bs) - 1;
        this.pc = this.dcm.getI(463);
        this.pi = this.dcm.getS(462);
        if (this.pi != null) {
            this.pi = this.pi.trim();
        }
        if ((this.f = this.dcm.getI(464)) == Integer.MAX_VALUE) {
            this.f = 1;
        }
        if ((this.max = this.dcm.getI(480)) == Integer.MAX_VALUE) {
            this.max = 0;
        }
        try {
            int ts = 0;
            String transyn = null;
            try {
                transyn = this.dcm.getFileMetaInformation().getS(31);
            }
            catch (Exception e) {
                transyn = null;
            }
            if (transyn != null) {
                ts = UID.getUIDEntry(transyn).getConstant();
            }
            this.setEncoding(ts);
        }
        catch (UnknownUIDException e) {
            throw new DicomException("ImageIO not possible: " + e.getMessage());
        }
    }

    public ImageProducer getImageProducer() throws DicomException {
        return this.getImageProducer(0);
    }

    public ImageProducer getImageProducer(int i) throws DicomException {
        if (i >= this.f) {
            throw new DicomException("Index exceeds number of frames");
        }
        if (this.encoding == 8196) {
            return Toolkit.getDefaultToolkit().createImage((byte[])this.dcm.get(1184, i + 1)).getSource();
        }
        Object pixels = this.getPixels(i);
        if (pixels == null) {
            throw new DicomException("Error ocurred building ImageProducer " + i);
        }
        if (this.pi.trim().equals("MONOCHROME1")) {
            if (this.ba == 8) {
                GrayColorModel cm = new GrayColorModel(8);
                return new MemoryImageSource(this.w, this.h, (ColorModel)cm, (byte[])pixels, 0, this.w);
            }
            if (this.max == 0) {
                this.max = this.calcMax((byte[])this.dcm.get(1184));
            }
            GrayColorModel cm = new GrayColorModel(this.ba, this.max);
            return new MemoryImageSource(this.w, this.h, (ColorModel)cm, (int[])pixels, 0, this.w);
        }
        if (this.pi.trim().equals("MONOCHROME2")) {
            if (this.ba == 8) {
                byte[] r = new byte[256];
                byte[] g = new byte[256];
                byte[] b = new byte[256];
                for (int j = 0; j < 256; ++j) {
                    g[j] = b[j] = (byte)j;
                    r[j] = b[j];
                }
                IndexColorModel icm = new IndexColorModel(8, 256, r, g, b, -1);
                return new MemoryImageSource(this.w, this.h, (ColorModel)icm, (byte[])pixels, 0, this.w);
            }
            if (this.max == 0) {
                this.max = this.calcMax((byte[])this.dcm.get(1184));
            }
            GrayColorModel cm = new GrayColorModel(this.ba, this.max);
            return new MemoryImageSource(this.w, this.h, (ColorModel)cm, (int[])pixels, 0, this.w);
        }
        if (this.pi.trim().equals("PALETTE COLOR")) {
            byte[] red = this.getPalette(498, 494);
            byte[] green = this.getPalette(499, 495);
            byte[] blue = this.getPalette(500, 496);
            IndexColorModel cm = new IndexColorModel(8, 256, red, green, blue);
            return new MemoryImageSource(this.w, this.h, (ColorModel)cm, (byte[])pixels, 0, this.w);
        }
        if (this.pi.equals("RGB")) {
            DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
            return new MemoryImageSource(this.w, this.h, (ColorModel)cm, (int[])pixels, 0, this.w);
        }
        return null;
    }

    public Vector getImageProducers() throws DicomException {
        Vector<ImageProducer> ips = new Vector<ImageProducer>(this.f);
        for (int i = 0; i < this.f; ++i) {
            ips.addElement(this.getImageProducer(i));
        }
        return ips;
    }

    public synchronized void setImageProducer(ImageProducer ip) {
        DICOMImageConsumer dic = new DICOMImageConsumer(this);
        ip.startProduction(dic);
        if (!dic.ready) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.log.error("", e);
            }
        }
        ip.removeConsumer(dic);
    }

    public int size() {
        return this.f;
    }

    public DicomImage getSource() {
        return this.dcm;
    }

    boolean isDecoded() {
        return this.decode;
    }
}

