/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.image.WL;
import java.awt.image.ColorModel;

public class GrayColorModel
extends ColorModel {
    private int max = 0;
    private int min = 0;
    private int[] grays;

    private void constructTable() {
        this.grays = new int[this.max + 1 - this.min];
        if (this.max + 1 == 256) {
            for (int i = 0; i < 256; ++i) {
                this.grays[i] = 0xFF000000 | (i & 0xFF) << 16 | (i & 0xFF) << 8 | i & 0xFF;
            }
        } else {
            int g = 0;
            for (int i = this.min; i < this.max + 1; ++i) {
                g = (i - this.min) * 255 / (this.max - this.min);
                this.grays[i - this.min] = 0xFF000000 | (g & 0xFF) << 16 | (g & 0xFF) << 8 | g & 0xFF;
            }
        }
    }

    private void adjustTable(int win, int lev) {
        for (int i = 0; i < this.grays.length; ++i) {
            if (i < lev - this.min) {
                this.grays[i] = -16777216;
                continue;
            }
            if (i > lev - this.min + win) {
                this.grays[i] = -1;
                continue;
            }
            int g = (i - (lev - this.min)) * 255 / win;
            this.grays[i] = 0xFF000000 | (g & 0xFF) << 16 | (g & 0xFF) << 8 | g & 0xFF;
        }
    }

    public GrayColorModel(int bits) {
        this(bits, (1 << bits) - 1);
    }

    public GrayColorModel(int bits, int max) {
        super(bits);
        this.pixel_bits = bits;
        this.max = max;
        this.constructTable();
    }

    public GrayColorModel(int bits, int min, int max) {
        super(bits);
        this.pixel_bits = bits;
        this.min = min;
        this.max = max;
        this.constructTable();
    }

    public void setWindowLevel(WL wl) {
        this.adjustTable(wl.window, wl.level);
    }

    public int getAlpha(int pixel) {
        return 255;
    }

    public int getRed(int pixel) {
        return this.grays[pixel - this.min] & 0xFF;
    }

    public int getGreen(int pixel) {
        return this.grays[pixel - this.min] & 0xFF;
    }

    public int getBlue(int pixel) {
        return this.grays[pixel - this.min] & 0xFF;
    }

    public int getRGB(int pixel) {
        return this.grays[pixel - this.min];
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }
}

