/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.log.JdtLogger;

public class DicomImageInfo {
    public static final int MONOCHROME1 = 0;
    public static final int MONOCHROME2 = 1;
    public static final int PALETTE_COLOR = 2;
    public static final int RGB = 3;
    public static final int HSV = 4;
    public static final int ARGB = 5;
    public static final int CMYK = 6;
    public static final int YBR_FULL = 7;
    public static final int YBR_FULL_422 = 8;
    public static final int YBR_PARTIAL_422 = 9;
    public static final int YBR_PARTIAL_420 = 10;
    public static final int YBR_ICT = 11;
    public static final int COLOR_BY_PIXEL = 0;
    public static final int COLOR_BY_PLANE = 1;
    public static final int PR_UNSIGNEDINT = 0;
    public static final int PR_TWOSCOMPLEMENT = 1;
    protected int photometricInterpretation;
    protected int bitsStored;
    protected int bitsAllocated;
    protected int highBit;
    protected int samplesPerPixel;
    protected int planarConfiguration;
    protected int pixelRepresentation;
    protected byte[] palette_red;
    protected byte[] palette_green;
    protected byte[] palette_blue;
    protected float[] windowWidths;
    protected float[] windowCenters;
    protected float rescaleSlope;
    protected float rescaleIntercept;
    protected int width;
    protected int height;
    protected int frames;
    protected boolean hasRescale = false;
    protected int ts;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomImageInfo.class);

    public DicomImageInfo(DicomObject dcm) throws IllegalValueException {
        DicomObject fmi = dcm.getFileMetaInformation();
        if (fmi != null && fmi.getSize(31) == 1) {
            try {
                this.ts = UID.getUIDEntry((String)fmi.get(31)).getConstant();
            }
            catch (UnknownUIDException ex) {
                IllegalValueException ivex = new IllegalValueException(ex + "");
                ivex.initCause(ex);
                throw ivex;
            }
        } else {
            this.ts = 8193;
        }
        String pi = (String)this.checkNull(dcm, 462);
        this.initPhotometricIntepretation(pi);
        this.samplesPerPixel = (Integer)this.checkNull(dcm, 461);
        this.bitsAllocated = (Integer)this.checkNull(dcm, 475);
        this.bitsStored = (Integer)this.checkNull(dcm, 476);
        this.highBit = (Integer)this.checkNull(dcm, 477);
        this.width = (Integer)this.checkNull(dcm, 467);
        this.height = (Integer)this.checkNull(dcm, 466);
        this.frames = dcm.getSize(464) < 1 ? 1 : (Integer)dcm.get(464);
        this.pixelRepresentation = (Integer)this.checkNull(dcm, 478);
        if (this.samplesPerPixel > 1) {
            this.planarConfiguration = (Integer)this.checkNull(dcm, 463);
            if (this.planarConfiguration != 0 && this.planarConfiguration != 1) {
                throw new IllegalValueException("Illegal Value for Planar Configuration: " + this.planarConfiguration);
            }
        }
        if (this.photometricInterpretation == 2) {
            this.palette_red = this.initPalette(dcm, 498, 494);
            this.palette_green = this.initPalette(dcm, 499, 495);
            this.palette_blue = this.initPalette(dcm, 500, 496);
        } else if (this.photometricInterpretation == 0 || this.photometricInterpretation == 1) {
            if (dcm.getSize(490) > 0 && dcm.getSize(489) > 0) {
                try {
                    this.rescaleSlope = Float.parseFloat(dcm.getS(490));
                    this.rescaleIntercept = Float.parseFloat(dcm.getS(489));
                }
                catch (DicomException ex) {
                    this.log.warn("DicomException while obtaining rescaleSlope and rescaleIntercept from DicomObject", ex);
                }
                if (this.rescaleSlope == 0.0f) {
                    this.rescaleSlope = 1.0f;
                }
                this.hasRescale = true;
            } else {
                this.rescaleSlope = 1.0f;
                this.rescaleIntercept = 0.0f;
                this.hasRescale = false;
            }
            int size_wc = dcm.getSize(487);
            int size_ww = dcm.getSize(488);
            if (size_wc > 0 && size_ww > 0) {
                int i;
                this.windowWidths = new float[Math.max(size_wc, size_ww)];
                this.windowCenters = new float[Math.max(size_wc, size_ww)];
                for (i = 0; i < size_wc; ++i) {
                    try {
                        this.windowCenters[i] = Float.parseFloat(dcm.getS(487, i));
                        continue;
                    }
                    catch (DicomException ex) {
                        this.log.error("", ex);
                    }
                }
                for (i = 0; i < size_ww; ++i) {
                    try {
                        this.windowWidths[i] = Float.parseFloat(dcm.getS(488, i));
                        continue;
                    }
                    catch (DicomException ex) {
                        this.log.error("", ex);
                    }
                }
            } else {
                this.windowWidths = new float[0];
                this.windowCenters = new float[0];
            }
        }
    }

    public int getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public int getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getBitsAllocated() {
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        return this.bitsStored;
    }

    public int getHighBit() {
        return this.highBit;
    }

    public int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public byte[] getPaletteRed() {
        return this.palette_red;
    }

    public byte[] getPaletteGreen() {
        return this.palette_green;
    }

    public byte[] getPaletteBlue() {
        return this.palette_blue;
    }

    public float[] getWindowCenters() {
        return this.windowCenters;
    }

    public float[] getWindowWidths() {
        return this.windowWidths;
    }

    public float getRescaleSlope() {
        return this.rescaleSlope;
    }

    public float getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    public boolean hasRescale() {
        return this.hasRescale;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrames() {
        return this.frames;
    }

    public int getTransferSyntax() {
        return this.ts;
    }

    private Object checkNull(DicomObject dcm, int tag2) throws IllegalValueException {
        return this.checkNull(dcm, tag2, 0);
    }

    private Object checkNull(DicomObject dcm, int tag2, int idx) throws IllegalValueException {
        if (dcm.getSize(tag2) <= idx) {
            throw new IllegalValueException("value for " + DDict.getDescription(tag2) + "missing");
        }
        Object obj = dcm.get(tag2, idx);
        if (obj == null) {
            throw new IllegalValueException("value for " + DDict.getDescription(tag2) + "missing");
        }
        return obj;
    }

    private void initPhotometricIntepretation(String s) throws IllegalValueException {
        if (s.equals("MONOCHROME1")) {
            this.photometricInterpretation = 0;
        } else if (s.equals("MONOCHROME2")) {
            this.photometricInterpretation = 1;
        } else if (s.equals("PALETTE COLOR")) {
            this.photometricInterpretation = 2;
        } else if (s.equals("RGB")) {
            this.photometricInterpretation = 3;
        } else if (s.equals("HSV")) {
            this.photometricInterpretation = 4;
        } else if (s.equals("ARGB")) {
            this.photometricInterpretation = 5;
        } else if (s.equals("CMYK")) {
            this.photometricInterpretation = 6;
        } else if (s.equals("YBR_FULL")) {
            this.photometricInterpretation = 7;
        } else if (s.equals("YBR_FULL_422")) {
            this.photometricInterpretation = 8;
        } else if (s.equals("YBR_PARTIAL_422")) {
            this.photometricInterpretation = 9;
        } else if (s.equals("YBR_PARTIAL_420")) {
            this.photometricInterpretation = 10;
        } else if (s.equals("YBR_ICT")) {
            this.photometricInterpretation = 11;
        } else {
            throw new IllegalValueException("Unknown photometric intepretation value: " + s);
        }
    }

    private byte[] initPalette(DicomObject dcm, int paldata, int paldesc) throws IllegalValueException {
        int entries = (Integer)this.checkNull(dcm, paldesc, 0);
        int firstpixel = (Integer)this.checkNull(dcm, paldesc, 1);
        int bits = (Integer)this.checkNull(dcm, paldesc, 2);
        byte[] dicompal = (byte[])this.checkNull(dcm, paldata);
        int firstvalue = (dicompal[0] & 0xFF) + ((dicompal[1] & 0xFF) << 8);
        int lastvalue = (dicompal[dicompal.length - 2] & 0xFF) + ((dicompal[dicompal.length - 1] & 0xFF) << 8);
        if (this.bitsAllocated == 8) {
            int j;
            byte[] pal = new byte[256];
            for (j = 0; j < firstpixel; ++j) {
                pal[j] = (byte)(firstvalue >> 8);
            }
            for (j = 0; j < entries; ++j) {
                int palentry = (dicompal[2 * j] & 0xFF) + ((dicompal[2 * j + 1] & 0xFF) << 8);
                pal[firstpixel + j] = (byte)(palentry >> 8);
            }
            for (j = firstpixel + entries; j < pal.length; ++j) {
                pal[j] = (byte)(lastvalue >> 8);
            }
            return pal;
        }
        throw new IllegalValueException("Unsupported Bits Allocated value for palette color image: " + this.bitsAllocated);
    }
}

