/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.log.JdtLogger;

public class DicomImage
extends DicomObject {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomImage.class);

    public void patientData(String patientName, String patientID, String birthDate, String sex) throws DicomException {
        try {
            this.set(147, patientName);
            this.set(148, patientID);
            this.set(152, sex);
        }
        catch (DicomException e) {
            this.log.error("", e);
        }
        try {
            this.set(150, birthDate);
        }
        catch (DicomException e) {
            throw new DicomException("Invalid Date format");
        }
    }

    public void generalStudyData(String instanceUID, String date, String time, String physName, String studyID, String orderNumber) throws DicomException {
        this.set(425, instanceUID);
        this.set(64, date);
        this.set(70, time);
        this.set(88, physName);
        this.set(427, studyID);
        this.set(77, orderNumber);
    }

    public void generalSeriesData(String modality, String instanceUID, String seriesNumber) throws DicomException {
        this.set(81, modality);
        this.set(426, instanceUID);
        this.set(428, seriesNumber);
    }

    public void generalEquipmentData(String manufacturer) {
        try {
            this.set(84, manufacturer);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    public void generalImageData(String imageNumber) throws DicomException {
        try {
            this.set(430, imageNumber);
        }
        catch (DicomException e) {
            throw new DicomException("Invalid Integer format");
        }
    }

    public void imagePixelData(int rows, int cols, int bitsAlloc, int bitsStored, int highBit, byte[] pixelData) throws DicomException {
        this.set(461, new Integer(1));
        this.set(462, "MONOCHROME2");
        this.set(466, new Integer(rows));
        this.set(467, new Integer(cols));
        if (bitsAlloc != 8 && bitsAlloc != 16 && bitsAlloc != 32) {
            throw new DicomException("BitsAllocated " + bitsAlloc + ": other than 8, 16 or 32");
        }
        if (bitsStored > bitsAlloc) {
            throw new DicomException("BitsStored > BitsAllocated");
        }
        if (highBit >= bitsStored) {
            throw new DicomException("HighBit >= BitsStored");
        }
        if (pixelData == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(475, new Integer(bitsAlloc));
        this.set(476, new Integer(bitsStored));
        this.set(477, new Integer(highBit));
        this.set(478, new Integer(0));
        this.set(1184, pixelData);
    }

    public void imagePixelData(int rows, int cols, int bitsAlloc, int bitsStored, int highBit, int[] pixelData) throws DicomException {
        this.set(461, new Integer(1));
        this.set(462, "MONOCHROME2");
        this.set(466, new Integer(rows));
        this.set(467, new Integer(cols));
        if (bitsAlloc != 8 && bitsAlloc != 16 && bitsAlloc != 24 && bitsAlloc != 32) {
            throw new DicomException("BitsAllocated " + bitsAlloc + ": other than 8, 16 or 32");
        }
        if (bitsStored > bitsAlloc) {
            throw new DicomException("BitsStored > BitsAllocated");
        }
        if (highBit >= bitsStored) {
            throw new DicomException("HighBit >= BitsStored");
        }
        if (pixelData == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(475, new Integer(bitsAlloc));
        this.set(476, new Integer(bitsStored));
        this.set(477, new Integer(highBit));
        this.set(478, new Integer(0));
        int bytes = bitsAlloc / 8;
        byte[] temp = new byte[pixelData.length * bytes];
        for (int i = 0; i < pixelData.length; ++i) {
            for (int j = 0; j < bytes; ++j) {
                temp[bytes * i + j] = (byte)((pixelData[i] & 255 << 8 * j) >> 8 * j);
            }
        }
        this.set(1184, temp);
    }

    public void imagePixelData(int rows, int cols, int planarConf, byte[] pixelData) throws DicomException {
        if (planarConf != 0 && planarConf != 1) {
            throw new DicomException("Planar Configuration has to be 0 or 1");
        }
        if (pixelData == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(461, new Integer(3));
        this.set(462, "RGB");
        this.set(466, new Integer(rows));
        this.set(467, new Integer(cols));
        this.set(475, new Integer(8));
        this.set(476, new Integer(8));
        this.set(477, new Integer(7));
        this.set(478, new Integer(0));
        this.set(463, new Integer(planarConf));
        this.set(1184, pixelData);
    }

    public void imagePixelData(int rows, int cols, int planarConf, int[] pixelData) throws DicomException {
        if (planarConf != 0 && planarConf != 1) {
            throw new DicomException("Planar Configuration has to be 0 or 1");
        }
        if (pixelData == null) {
            throw new DicomException("PixelData empty");
        }
        this.set(461, new Integer(3));
        this.set(462, "RGB");
        this.set(466, new Integer(rows));
        this.set(467, new Integer(cols));
        this.set(475, new Integer(8));
        this.set(476, new Integer(8));
        this.set(477, new Integer(7));
        this.set(478, new Integer(0));
        this.set(463, new Integer(planarConf));
        byte[] temp = new byte[pixelData.length * 3];
        if (planarConf == 0) {
            for (int i = 0; i < pixelData.length; ++i) {
                temp[3 * i] = (byte)((pixelData[i] & 0xFF0000) >> 16);
                temp[3 * i + 1] = (byte)((pixelData[i] & 0xFF00) >> 8);
                temp[3 * i + 2] = (byte)(pixelData[i] & 0xFF);
            }
        } else {
            for (int i = 0; i < pixelData.length; ++i) {
                temp[i] = (byte)((pixelData[i] & 0xFF0000) >> 16);
                temp[pixelData.length + i] = (byte)((pixelData[i] & 0xFF00) >> 8);
                temp[2 * pixelData.length + i] = (byte)(pixelData[i] & 0xFF);
            }
        }
        this.set(1184, temp);
    }

    public void imagePixelData(int rows, int cols, byte[] pixelData, byte[] red, byte[] green, byte[] blue) throws DicomException {
        int i;
        if (pixelData == null) {
            throw new DicomException("PixelData empty");
        }
        if (red == null) {
            throw new DicomException("Red Palette empty");
        }
        if (green == null) {
            throw new DicomException("Green Palette empty");
        }
        if (blue == null) {
            throw new DicomException("Blue Palette empty");
        }
        this.set(466, new Integer(rows));
        this.set(467, new Integer(cols));
        this.set(475, new Integer(8));
        this.set(476, new Integer(8));
        this.set(477, new Integer(7));
        this.set(494, new Integer(256), 0);
        this.set(494, new Integer(0), 1);
        this.set(494, new Integer(16), 2);
        this.set(495, new Integer(256), 0);
        this.set(495, new Integer(0), 1);
        this.set(495, new Integer(16), 2);
        this.set(496, new Integer(256), 0);
        this.set(496, new Integer(0), 1);
        this.set(496, new Integer(16), 2);
        this.set(461, new Integer(1));
        this.set(462, "PALETTE COLOR");
        this.set(478, new Integer(0));
        byte[] dicomred = new byte[512];
        byte[] dicomgreen = new byte[512];
        byte[] dicomblue = new byte[512];
        for (i = 0; i < red.length; ++i) {
            dicomred[2 * i + 1] = red[i];
        }
        for (i = 0; i < green.length; ++i) {
            dicomgreen[2 * i + 1] = green[i];
        }
        for (i = 0; i < blue.length; ++i) {
            dicomblue[2 * i + 1] = blue[i];
        }
        this.set(498, dicomred);
        this.set(499, dicomgreen);
        this.set(500, dicomblue);
        this.set(1184, pixelData);
    }

    public void sopCommonData(String sopClassUID, String sopInstanceUID) {
        try {
            if (sopClassUID == null) {
                this.set(62, "1.2.840.10008.5.1.4.1.1.7");
            } else {
                this.set(62, sopClassUID);
            }
            this.set(63, sopInstanceUID);
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }
}

