/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.image.DicomImage;
import com.archimed.dicom.image.GrayColorModel;
import com.archimed.dicom.image.ImageIO;
import com.archimed.log.JdtLogger;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import java.util.Vector;

class DICOMImageConsumer
implements ImageConsumer {
    DicomImage dcm;
    ImageIO im;
    byte[] b_pix;
    int[] i_pix;
    int w;
    int h;
    ColorModel cm;
    boolean bytes;
    public boolean ready;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DICOMImageConsumer.class);

    public DICOMImageConsumer(ImageIO di) {
        this.im = di;
        this.dcm = di.dcm;
        this.ready = false;
    }

    boolean testMonochrome() {
        if (this.bytes) {
            if (this.cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)this.cm;
                for (int i = 0; i < icm.getMapSize(); ++i) {
                    int r = icm.getRed(i);
                    int g = icm.getGreen(i);
                    int b = icm.getBlue(i);
                    if (r == g && g == b) continue;
                    return false;
                }
                return true;
            }
            this.log.error("testMonochrome: ??? bytes + not indexcolor");
            return false;
        }
        if (this.cm instanceof GrayColorModel) {
            return true;
        }
        if (this.cm instanceof DirectColorModel) {
            for (int i = 0; i < this.w * this.h; ++i) {
                if (this.cm.getRed(this.i_pix[i]) == this.cm.getGreen(this.i_pix[i]) && this.cm.getGreen(this.i_pix[i]) == this.cm.getBlue(this.i_pix[i])) continue;
                return false;
            }
            return true;
        }
        System.out.println("??? ints + not directcolor");
        return false;
    }

    Vector testPaletteColor() {
        Vector<Integer> vec = new Vector<Integer>(256);
        if (this.bytes) {
            IndexColorModel icm = (IndexColorModel)this.cm;
            for (int i = 0; i < icm.getMapSize(); ++i) {
                int pixel = (icm.getRed(i) << 16) + (icm.getGreen(i) << 8) + icm.getBlue(i);
                vec.addElement(new Integer(pixel));
            }
            return vec;
        }
        for (int i = 0; i < this.w * this.h; ++i) {
            int pixel = this.i_pix[i];
            if (vec.contains(new Integer(pixel))) continue;
            vec.addElement(new Integer(pixel));
            if (vec.size() <= 256) continue;
            return null;
        }
        return vec;
    }

    boolean monoPaletteOK() {
        IndexColorModel icm = (IndexColorModel)this.cm;
        for (int i = 0; i < icm.getMapSize(); ++i) {
            if (icm.getRed(i) == i) continue;
            return false;
        }
        return true;
    }

    void saveMonochrome() {
        if (this.cm instanceof IndexColorModel) {
            if (this.monoPaletteOK()) {
                try {
                    this.dcm.imagePixelData(this.h, this.w, 8, 8, 7, this.b_pix);
                }
                catch (DicomException e) {
                    this.log.error("", e);
                }
            } else {
                byte[] temp = new byte[this.w * this.h];
                for (int i = 0; i < this.w * this.h; ++i) {
                    temp[i] = (byte)this.cm.getRed(this.b_pix[i]);
                }
                try {
                    this.dcm.imagePixelData(this.h, this.w, 8, 8, 7, temp);
                }
                catch (DicomException e) {
                    this.log.error("", e);
                }
            }
        } else if (this.cm instanceof GrayColorModel) {
            int ba = this.cm.getPixelSize();
            int bytes = ba / 8;
            byte[] temp = new byte[this.w * this.h * bytes];
            for (int i = 0; i < this.w * this.h; ++i) {
                for (int j = 0; j < bytes; ++j) {
                    temp[bytes * i + j] = (byte)((this.i_pix[i] & 255 << j * 8) >> j * 8);
                }
            }
            try {
                this.dcm.imagePixelData(this.h, this.w, ba, ba, ba - 1, temp);
            }
            catch (DicomException e) {
                this.log.error("", e);
            }
        } else if (this.cm instanceof DirectColorModel) {
            byte[] temp = new byte[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                temp[i] = (byte)(this.i_pix[i] & 0xFF);
            }
            try {
                this.dcm.imagePixelData(this.h, this.w, 8, 8, 7, temp);
            }
            catch (DicomException e) {
                this.log.error("", e);
            }
        } else {
            System.out.println("cm: " + this.cm);
        }
    }

    void savePaletteColor(Vector v) {
        int pallen = v.size();
        byte[] red = new byte[256];
        byte[] blue = new byte[256];
        byte[] green = new byte[256];
        for (int i = 0; i < pallen; ++i) {
            red[i] = (byte)(((Integer)v.elementAt(i) & 0xFF0000) >> 16);
            green[i] = (byte)(((Integer)v.elementAt(i) & 0xFF00) >> 8);
            blue[i] = (byte)((Integer)v.elementAt(i) & 0xFF);
        }
        if (this.cm instanceof IndexColorModel) {
            try {
                this.dcm.imagePixelData(this.h, this.w, this.b_pix, red, green, blue);
            }
            catch (DicomException e) {
                this.log.error("", e);
            }
        } else if (this.cm instanceof DirectColorModel) {
            int i;
            Hashtable ht = new Hashtable(pallen);
            for (i = 0; i < pallen; ++i) {
                ht.put(v.elementAt(i), new Integer(i));
            }
            this.b_pix = new byte[this.w * this.h];
            for (i = 0; i < this.w * this.h; ++i) {
                this.b_pix[i] = (byte)((Integer)ht.get(new Integer(this.i_pix[i]))).intValue();
            }
            try {
                this.dcm.imagePixelData(this.h, this.w, this.b_pix, red, green, blue);
            }
            catch (DicomException e) {
                this.log.error("", e);
            }
        }
    }

    void saveRGB() {
        try {
            this.dcm.imagePixelData(this.h, this.w, 0, this.i_pix);
        }
        catch (DicomException e) {
            this.log.error("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageComplete(int status) {
        if (status == 3) {
            boolean mono = this.testMonochrome();
            if (mono) {
                this.saveMonochrome();
                this.ready = true;
                ImageIO imageIO = this.im;
                synchronized (imageIO) {
                    this.im.notify();
                }
                return;
            }
            Vector v = this.testPaletteColor();
            if (v != null) {
                this.savePaletteColor(v);
                this.ready = true;
                ImageIO imageIO = this.im;
                synchronized (imageIO) {
                    this.im.notify();
                }
                return;
            }
            this.saveRGB();
            this.ready = true;
            ImageIO imageIO = this.im;
            synchronized (imageIO) {
                this.im.notify();
            }
            return;
        }
    }

    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    public void setDimensions(int width, int height) {
        this.w = width;
        this.h = height;
    }

    public void setHints(int hintflags) {
    }

    public void setPixels(int x, int y, int wi, int hi, ColorModel model, byte[] pixels, int off, int scansize) {
        if (x != 0 || y != 0 || wi != this.w || hi != this.h) {
            if (this.b_pix == null) {
                this.b_pix = new byte[this.w * this.h];
            }
            for (int i = y; i < y + hi; ++i) {
                System.arraycopy(pixels, 0, this.b_pix, x + i * this.w, x + wi);
            }
        } else {
            this.b_pix = pixels;
        }
        this.bytes = true;
    }

    public void setPixels(int x, int y, int wi, int hi, ColorModel model, int[] pixels, int off, int scansize) {
        if (x != 0 || y != 0 || wi != this.w || hi != this.h) {
            if (this.i_pix == null) {
                this.i_pix = new int[this.w * this.h];
            }
            for (int i = y; i < y + hi; ++i) {
                System.arraycopy(pixels, 0, this.i_pix, x + i * this.w, x + wi);
            }
        } else {
            this.i_pix = pixels;
        }
        this.bytes = false;
    }

    public void setProperties(Hashtable props) {
    }
}

