/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.iioplugin;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.data.BitTools;
import com.archimed.dicom.iioplugin.DicomImageReader;
import com.archimed.log.JdtLogger;
import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class DicomImageReaderSpi
extends ImageReaderSpi {
    private static final String VENDOR = "Softlink";
    private static final String VERSION = Jdt.MAJOR_VERSION + "." + Jdt.MINOR_VERSION;
    private static final String[] NAMES = new String[]{"DICOM"};
    private static final String[] SUFFIXES = new String[]{"dcm", "dic", "dicom", "dicm"};
    private static final String[] MIMETypes = new String[]{"application/dicom"};
    private static final String readerClassName = "com.archimed.dicom.iioplugin.DicomImageReader";
    private static final Class[] types = new Class[]{ImageInputStream.class, DicomObject.class, DicomObject[].class};
    private JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(this.getClass());

    public DicomImageReaderSpi() {
        super(VENDOR, VERSION, NAMES, SUFFIXES, MIMETypes, readerClassName, types, null, false, null, null, null, null, false, null, null, null, null);
    }

    public String getDescription(Locale locale) {
        return "Softlink Dicom ImageIO Plugin";
    }

    public boolean canDecodeInput(Object input) throws IOException {
        if (input == null) {
            return false;
        }
        if (input instanceof DicomObject) {
            return true;
        }
        if (input instanceof DicomObject[] && ((DicomObject[])input).length == 2) {
            return true;
        }
        if (input instanceof ImageInputStream) {
            return this.testDicomContents((ImageInputStream)input);
        }
        return false;
    }

    private boolean testDicomContents(ImageInputStream imageInputStream) {
        try {
            int e;
            byte[] b = new byte[132];
            imageInputStream.mark();
            imageInputStream.readFully(b);
            imageInputStream.reset();
            if (b[128] == 68 && b[129] == 73 && b[130] == 67 && b[131] == 77) {
                return true;
            }
            int g = BitTools.toInt((byte)b[1], (byte)b[0]);
            if (DDict.lookupDDict(g, e = BitTools.toInt((byte)b[3], (byte)b[2])) != Integer.MAX_VALUE) {
                return true;
            }
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            this.log.debug("error detecting dicom contents", e);
        }
        return false;
    }

    public ImageReader createReaderInstance(Object extension) {
        return new DicomImageReader(this);
    }
}

