/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.iioplugin;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.iioplugin.DicomBufferedImage;
import com.archimed.dicom.iioplugin.DicomBufferedImageFactory;
import com.archimed.dicom.iioplugin.DicomImageReadParam;
import com.archimed.dicom.iioplugin.image.DicomImageObject;
import com.archimed.dicom.iioplugin.image.DicomImageObjectBuilder;
import com.archimed.dicom.iioplugin.image.RenderableImage;
import com.archimed.dicom.iioplugin.input.ImageInputStreamWrapper;
import com.archimed.dicom.iioplugin.pixel.PixelReader;
import com.archimed.dicom.iioplugin.pixel.PixelReaderFactory;
import com.archimed.dicom.iioplugin.transform.GrayscaleTransformationFactory;
import com.archimed.log.JdtLogger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class DicomImageReader
extends ImageReader {
    private boolean disposed;
    private static DicomImageReadParam DEFAULT_PARAM = new DicomImageReadParam();
    private JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(this.getClass());
    private PixelReaderFactory pixelReaderFactory;
    private GrayscaleTransformationFactory transformationFactory;
    private DicomImageObject dicomImageObject;
    private PixelReader pixelReader;

    public DicomImageReader(ImageReaderSpi originatingProvider) {
        this(originatingProvider, new PixelReaderFactory(), new GrayscaleTransformationFactory());
    }

    protected DicomImageReader(ImageReaderSpi originatingProvider, PixelReaderFactory pixelReaderFactory, GrayscaleTransformationFactory transformationFactory) {
        super(originatingProvider);
        this.pixelReaderFactory = pixelReaderFactory;
        this.transformationFactory = transformationFactory;
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        if (this.dicomImageObject == null) {
            if (this.disposed) {
                throw new IllegalStateException("already disposed");
            }
            throw new IllegalStateException("no input source set or input can't be decoded");
        }
        try {
            return this.dicomImageObject.getNumberOfFrames();
        }
        catch (DicomException e) {
            throw new IOException("unable to read 'NumberOfFrames' from dicom image");
        }
    }

    public int getWidth(int imageIndex) throws IOException {
        if (this.dicomImageObject == null) {
            if (this.disposed) {
                throw new IllegalStateException("already disposed");
            }
            throw new IllegalStateException("no input source set or input can't be decoded");
        }
        try {
            return this.dicomImageObject.getColumns();
        }
        catch (DicomException e) {
            throw new IOException("unable to read 'Columns' from dicom image");
        }
    }

    public int getHeight(int imageIndex) throws IOException {
        if (this.dicomImageObject == null) {
            if (this.disposed) {
                throw new IllegalStateException("already disposed");
            }
            throw new IllegalStateException("no input source set or input can't be decoded");
        }
        try {
            return this.dicomImageObject.getRows();
        }
        catch (DicomException e) {
            throw new IOException("unable to read 'Rows' from dicom image");
        }
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        if (this.pixelReader == null) {
            if (this.disposed) {
                throw new IllegalStateException("already disposed");
            }
            throw new IllegalStateException("no input source set or input can't be decoded");
        }
        return Arrays.asList(this.pixelReader.getSupportedImageTypes()).iterator();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (this.pixelReader == null) {
            if (this.disposed) {
                throw new IllegalStateException("already disposed");
            }
            throw new IllegalStateException("no input source set or input can't be decoded");
        }
        if (imageIndex > this.getNumImages(false)) {
            throw new ArrayIndexOutOfBoundsException(imageIndex);
        }
        DicomImageReadParam imageReadParam = DEFAULT_PARAM;
        if (param != null && param instanceof DicomImageReadParam) {
            imageReadParam = (DicomImageReadParam)param;
        }
        try {
            RenderableImage image = this.pixelReader.readPixels(this.dicomImageObject.getPixels(imageReadParam.isCopyPixelData(), imageIndex), this.dicomImageObject.getColumns(), this.dicomImageObject.getRows());
            image.setImageReadParam(imageReadParam);
            GrayscaleTransformationFactory.addTransformations((RenderableImage)image, (DicomImageObject)this.dicomImageObject);
            DicomBufferedImage dicomBufferedImage = DicomBufferedImageFactory.createDicomBufferedImage(image);
            if (imageReadParam.isCreateDicomBufferedImage()) {
                return dicomBufferedImage;
            }
            return dicomBufferedImage.createDefaultImage(imageReadParam.isAutoWindowLevel());
        }
        catch (Exception e) {
            this.log.warn("error reading dicom image", e);
            throw new IOException("unable to read pixels: " + e.getMessage());
        }
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        if (this.disposed) {
            throw new IllegalStateException("already disposed");
        }
        this.input = input;
        if (input != null) {
            this.seekForwardOnly = seekForwardOnly;
            this.ignoreMetadata = ignoreMetadata;
            this.minIndex = 0;
            DicomImageObjectBuilder dicomImageObjectBuilder = new DicomImageObjectBuilder();
            if (input instanceof DicomObject) {
                this.log.debug("input: using a single DicomObject");
                this.dicomImageObject = dicomImageObjectBuilder.buildDicomImageObject((DicomObject)input);
            } else if (input instanceof DicomObject[]) {
                DicomObject[] dicomObjects = (DicomObject[])input;
                if (dicomObjects.length == 2) {
                    this.log.debug("input: using a two DicomObjects");
                    this.dicomImageObject = dicomImageObjectBuilder.buildDicomImageObject(dicomObjects[0], dicomObjects[1]);
                } else {
                    this.log.error("input: only DicomObject-arrays of dimension 2 are supported");
                }
            } else if (input instanceof ImageInputStream) {
                try {
                    this.dicomImageObject = dicomImageObjectBuilder.buildDicomImageObject((InputStream)new ImageInputStreamWrapper((ImageInputStream)input));
                }
                catch (Exception e) {
                    this.log.warn("error parsing provided ImageInputStream", e);
                    throw new IllegalArgumentException("unable to use provided ImageInputStream: " + e.getMessage());
                }
            }
            if (this.dicomImageObject == null) {
                throw new IllegalArgumentException("unsupported input type: " + input.getClass().getName());
            }
            try {
                this.pixelReader = this.pixelReaderFactory.createPixelReader(this.dicomImageObject);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("unable to create an appropriate PixelReader: " + e.getMessage());
            }
        }
        this.dicomImageObject = null;
        this.pixelReader = null;
    }

    public void dispose() {
        if (this.pixelReader != null) {
            this.pixelReader.dispose();
        }
        this.input = null;
        this.dicomImageObject = null;
        this.pixelReader = null;
        this.disposed = true;
    }

    public ImageReadParam getDefaultReadParam() {
        return DEFAULT_PARAM;
    }

    public static DicomImageReadParam getDefaultDicomImageReadParam() {
        return DEFAULT_PARAM;
    }
}

