/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.iioplugin;

import com.archimed.dicom.iioplugin.DicomBufferedImage;
import com.archimed.dicom.iioplugin.image.GrayscaleIndex;
import com.archimed.dicom.iioplugin.image.RenderableImage;
import com.archimed.dicom.iioplugin.transform.impl.AutoWindowTransformation;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;

public class DicomBufferedImageFactory {
    public static DicomBufferedImage createDicomBufferedImage(RenderableImage renderableImage) {
        ColorModel usedColorModel;
        RenderableImage image = renderableImage;
        if (image.getGrayscaleIndex() != null) {
            int bitsStored = image.getGrayscaleIndex().getPixelDepth();
            int bitsAllocated = image.getGrayscaleIndex().getBits();
            int dataBufferType = bitsAllocated > 8 ? 1 : 0;
            usedColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{bitsStored}, false, false, 1, dataBufferType);
        } else {
            usedColorModel = image.getColorModel();
        }
        DicomBufferedImage dicomBufferedImage = new DicomBufferedImage(image, usedColorModel, Raster.createWritableRaster(image.getSampleModel(), image.getDataBuffer(), new Point(0, 0)));
        if (renderableImage.getGrayscaleIndex() != null) {
            GrayscaleIndex gi = renderableImage.getGrayscaleIndex();
            if (renderableImage.getModalityLutTransformation() != null) {
                gi = gi.copy();
                gi = renderableImage.getModalityLutTransformation().transform(gi);
            }
            GrayscaleIndex.PixelRange realRange = AutoWindowTransformation.getRealPixelRange((DataBuffer)image.getDataBuffer(), (GrayscaleIndex)gi);
            dicomBufferedImage.setMaximumPixelValue(realRange.getMaximum());
            dicomBufferedImage.setMinimumPixelValue(realRange.getMinimum());
        }
        return dicomBufferedImage;
    }
}

