/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.iioplugin;

import com.archimed.dicom.iioplugin.image.GrayscaleIndex;
import com.archimed.dicom.iioplugin.image.RenderableImage;
import com.archimed.dicom.iioplugin.transform.GrayscaleTransformation;
import com.archimed.dicom.iioplugin.transform.GrayscaleTransformationFactory;
import com.archimed.dicom.iioplugin.transform.impl.VoiLutWindowTransformation;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RenderedOp;

public class DicomBufferedImage
extends BufferedImage {
    private RenderableImage renderableImage;
    private int minimumPixelValue;
    private int maximumPixelValue;

    DicomBufferedImage(RenderableImage renderableImage, ColorModel cm, WritableRaster raster) {
        super(cm, raster, true, null);
        this.renderableImage = renderableImage;
    }

    DicomBufferedImage(RenderableImage renderableImage, int width, int height, int type) {
        super(width, height, type);
        this.renderableImage = renderableImage;
    }

    public BufferedImage createDefaultImage(boolean autoWindowLevel) {
        if (this.renderableImage.getGrayscaleIndex() == null) {
            return this;
        }
        GrayscaleIndex copyGrayscaleIndex = this.renderableImage.getGrayscaleIndex() == null ? null : this.renderableImage.getGrayscaleIndex().copy();
        GrayscaleTransformationFactory.applyTransformations((RenderableImage)this.renderableImage, (boolean)autoWindowLevel);
        BufferedImage bit8BufferedImage = this.renderTo8bitLut();
        this.renderableImage.setGrayscaleIndex(copyGrayscaleIndex);
        return bit8BufferedImage;
    }

    public BufferedImage createImage(double windowCenter, double windowWidth) throws UnsupportedOperationException {
        if (this.renderableImage.getGrayscaleIndex() == null) {
            throw new UnsupportedOperationException("This method is only supported for grayscale images.");
        }
        GrayscaleIndex copyGrayscaleIndex = this.renderableImage.getGrayscaleIndex() == null ? null : this.renderableImage.getGrayscaleIndex().copy();
        GrayscaleTransformation originalTransformation = this.renderableImage.getVoiLutTransformation();
        VoiLutWindowTransformation transformation = new VoiLutWindowTransformation(windowCenter, windowWidth);
        this.renderableImage.setVoiLutTransformation((GrayscaleTransformation)transformation);
        GrayscaleTransformationFactory.applyTransformations((RenderableImage)this.renderableImage, (boolean)false);
        BufferedImage bit8BufferedImage = this.renderTo8bitLut();
        this.renderableImage.setGrayscaleIndex(copyGrayscaleIndex);
        this.renderableImage.setVoiLutTransformation(originalTransformation);
        return bit8BufferedImage;
    }

    private BufferedImage renderTo8bitLut() {
        int[] grayscaleValues = this.renderableImage.getGrayscaleIndex().getGrayscaleValues();
        int size = grayscaleValues.length;
        GrayscaleIndex.PixelRange pixelRange = this.renderableImage.getGrayscaleIndex().getPixelRange();
        byte[] lut = new byte[size];
        for (int i = 0; i < size; ++i) {
            lut[i] = (byte)((grayscaleValues[i] - pixelRange.getMinimum()) * 256 / pixelRange.getLength());
        }
        LookupTableJAI lookup = new LookupTableJAI(lut, 0);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(this);
        pb.add(lookup);
        RenderedOp renderedOp = JAI.create((String)"lookup", (ParameterBlock)pb, null);
        BufferedImage destImage = renderedOp.getAsBufferedImage();
        return destImage;
    }

    public int getMaximumPixelValue() {
        return this.maximumPixelValue;
    }

    public void setMaximumPixelValue(int maximumPixelValue) {
        this.maximumPixelValue = maximumPixelValue;
    }

    public int getMinimumPixelValue() {
        return this.minimumPixelValue;
    }

    public void setMinimumPixelValue(int minimumPixelValue) {
        this.minimumPixelValue = minimumPixelValue;
    }
}

