/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.dir;

import java.util.regex.Pattern;

public interface QueryMode {
    public static final QueryMode CASE_SENSITIVE_SUBSTRING = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            if (input == null ^ searchPattern == null) {
                return false;
            }
            if (input == null) {
                input = "";
            }
            if (searchPattern == null) {
                searchPattern = "";
            }
            return input.indexOf(searchPattern) >= 0;
        }
    };
    public static final QueryMode CASE_INSENSITIVE_SUBSTRING = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            if (input == null ^ searchPattern == null) {
                return false;
            }
            if (input == null) {
                input = "";
            }
            if (searchPattern == null) {
                searchPattern = "";
            }
            return input.toLowerCase().indexOf(searchPattern.toLowerCase()) >= 0;
        }
    };
    public static final QueryMode EXACT = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            if (input == null ^ searchPattern == null) {
                return false;
            }
            if (input == null && searchPattern == null) {
                return true;
            }
            return input.equals(searchPattern);
        }
    };
    public static final QueryMode CASE_INSENSITIVE = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            if (input == null ^ searchPattern == null) {
                return false;
            }
            if (input == null && searchPattern == null) {
                return true;
            }
            return input.equalsIgnoreCase(searchPattern);
        }
    };
    public static final QueryMode REGEX_FULL = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            if (input == null ^ searchPattern == null) {
                return false;
            }
            if (input == null && searchPattern == null) {
                return true;
            }
            return input.matches(searchPattern);
        }
    };
    public static final QueryMode REGEX_SUBSTRING = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            if (input == null ^ searchPattern == null) {
                return false;
            }
            if (input == null && searchPattern == null) {
                return true;
            }
            return Pattern.compile(searchPattern).matcher(input).find();
        }
    };
    public static final QueryMode EMPTY = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            return input == null || input.length() == 0;
        }
    };
    public static final QueryMode NOT_EMPTY = new QueryMode(){

        public boolean match(String input, String searchPattern) {
            return input != null && input.length() > 0;
        }
    };

    public boolean match(String var1, String var2);
}

