/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.charset;

import com.archimed.dicom.Jdt;
import com.archimed.dicom.charset.DicomCharset;
import com.archimed.dicom.charset.DicomCharsetException;
import com.archimed.log.JdtLogger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;

public class DicomCharsetCoder {
    public static final byte ESC = 27;
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char FF = '\f';
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomCharsetCoder.class);

    public byte[] encode(String str) throws DicomCharsetException {
        return this.encode(str, DicomCharset.DEFAULT);
    }

    public byte[] encode(String str, DicomCharset dicomCharset) {
        return this.encode(str, new DicomCharset[]{dicomCharset}, false);
    }

    public byte[] encode(String str, DicomCharset[] dicomCharsets) {
        return this.encode(str, dicomCharsets, false);
    }

    public byte[] encode(String str, DicomCharset dicomCharset, boolean escapeSequence) {
        return this.encode(str, new DicomCharset[]{dicomCharset}, escapeSequence);
    }

    private byte[] createArrayFromBuffer(ByteBuffer bb) {
        byte[] buffer = new byte[bb.position()];
        bb.rewind();
        bb.get(buffer);
        return buffer;
    }

    public byte[] encode(String str, DicomCharset[] dicomCharsets, boolean startWithEscape) {
        CharsetEncoder[] encoders = new CharsetEncoder[dicomCharsets.length];
        for (int i = 0; i < dicomCharsets.length; ++i) {
            encoders[i] = dicomCharsets[i].getJavaCharset().newEncoder();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(str.length() * 6);
        int activeEncoderIdx = 0;
        int previousEncoderIdx = 0;
        boolean b = false;
        block1: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (DicomCharsetCoder.isDicomControlCharacter(c)) {
                activeEncoderIdx = 0;
            }
            for (int j = 0; j < encoders.length; ++j) {
                b = false;
                if (!encoders[j].canEncode(c)) continue;
                if (startWithEscape && i == 0) {
                    byte[] escapeBuf = this.getEscapeSequence(dicomCharsets[j], c);
                    byteBuffer.put((byte)27);
                    byteBuffer.put(escapeBuf);
                }
                if (dicomCharsets.length == 1) {
                    encoders[j].encode(CharBuffer.wrap(str), byteBuffer, true);
                    break block1;
                }
                previousEncoderIdx = activeEncoderIdx;
                activeEncoderIdx = j;
                this.encodeCharacter(c, dicomCharsets[activeEncoderIdx], dicomCharsets[previousEncoderIdx], encoders[activeEncoderIdx], byteBuffer);
                b = true;
                break;
            }
            if (b) continue;
            throw new DicomCharsetException("Unable to encode string with specified charsets", null);
        }
        return this.createArrayFromBuffer(byteBuffer);
    }

    private static final boolean isDicomControlCharacter(char c) {
        return c == '\n' || c == '\f' || c == '\r';
    }

    private byte[] getEscapeSequence(DicomCharset charset, char c) {
        byte[] escapeBuf;
        ByteBuffer tempBuffer = charset.getJavaCharset().encode(CharBuffer.wrap(new char[]{c}));
        tempBuffer.rewind();
        if (tempBuffer.get() > 0) {
            escapeBuf = charset.getEscapeSequenceG0();
            if (escapeBuf == null) {
                throw new DicomCharsetException("no G0 escape sequence found for " + charset.getDefinedTerm());
            }
        } else {
            escapeBuf = charset.getEscapeSequenceG1();
            if (escapeBuf == null) {
                throw new DicomCharsetException("no G1 escape sequence found for " + charset.getDefinedTerm());
            }
        }
        return escapeBuf;
    }

    private void encodeCharacter(char c, DicomCharset currentCharset, DicomCharset previousCharset, CharsetEncoder coder, ByteBuffer byteBuffer) {
        ByteBuffer tempBuffer = null;
        try {
            tempBuffer = coder.encode(CharBuffer.wrap(new char[]{c}));
            tempBuffer.rewind();
        }
        catch (CharacterCodingException ex) {
            throw new DicomCharsetException("Unable to encode character:" + ex, ex);
        }
        if (currentCharset != previousCharset) {
            byte[] escapeBuf;
            if (tempBuffer.get() > 0) {
                escapeBuf = currentCharset.getEscapeSequenceG0();
                if (escapeBuf == null) {
                    throw new DicomCharsetException("no G0 escape sequence found for " + currentCharset.getDefinedTerm());
                }
            } else {
                escapeBuf = currentCharset.getEscapeSequenceG1();
                if (escapeBuf == null) {
                    throw new DicomCharsetException("no G1 escape sequence found for " + currentCharset.getDefinedTerm());
                }
            }
            tempBuffer.rewind();
            byteBuffer.put((byte)27);
            byteBuffer.put(escapeBuf);
        }
        byteBuffer.put(tempBuffer);
    }

    public String decode(byte[] ar) throws DicomCharsetException {
        return this.decode(ar, 0, ar.length);
    }

    public String decode(byte[] ar, int offset, int len) throws DicomCharsetException {
        return this.decode(ar, offset, len, new DicomCharset[]{DicomCharset.DEFAULT});
    }

    public String decode(byte[] ar, DicomCharset[] dicomCharsets) throws DicomCharsetException {
        return this.decode(ar, 0, ar.length, dicomCharsets);
    }

    public String decode(byte[] ar, int offset, int len, DicomCharset[] dicomCharsets) throws DicomCharsetException {
        ByteBuffer bb = ByteBuffer.wrap(ar, offset, len);
        if (dicomCharsets.length == 1) {
            try {
                CharsetDecoder decoder = dicomCharsets[0].getJavaCharset().newDecoder();
                return decoder.decode(bb).toString();
            }
            catch (CharacterCodingException ex) {
                this.log.warn("decoding using specified characterset failed,using fail-over: " + ex);
                this.log.debug("", ex);
                return this.decodeFailOver(ar, offset, len, ex);
            }
            catch (UnsupportedCharsetException ex) {
                this.log.warn("decoding using specified characterset failed,using fail-over: " + ex);
                this.log.debug("", ex);
                return this.decodeFailOver(ar, offset, len, ex);
            }
        }
        StringBuffer sb = new StringBuffer();
        byte[] esc2 = new byte[2];
        byte[] esc3 = new byte[3];
        int startpos = bb.position();
        Charset currentCharset = dicomCharsets[0].getJavaCharset();
        while (bb.hasRemaining()) {
            byte b = bb.get();
            if (b != 27) continue;
            ByteBuffer bb2 = ByteBuffer.wrap(bb.array(), startpos, bb.position() - startpos - 1);
            try {
                sb.append(currentCharset.newDecoder().decode(bb2).toString());
            }
            catch (CharacterCodingException ex) {
                throw new DicomCharsetException("unable to decode bytes into String", ex);
            }
            esc2[0] = bb.get();
            esc2[1] = bb.get();
            DicomCharset dc = DicomCharset.lookup(esc2);
            if (dc == null) {
                esc3[0] = esc2[0];
                esc3[1] = esc2[1];
                esc3[2] = bb.get();
                dc = DicomCharset.lookup(esc3);
                if (dc == null) {
                    throw new DicomCharsetException("unknown escape sequence encountered", null);
                }
            }
            currentCharset = dc.getJavaCharset();
            startpos = bb.position();
        }
        if (startpos < bb.limit()) {
            bb.position(startpos);
            try {
                sb.append(currentCharset.newDecoder().decode(bb).toString());
            }
            catch (CharacterCodingException ex) {
                throw new DicomCharsetException("unable to decode bytes into String", ex);
            }
        }
        return sb.toString();
    }

    private String decodeFailOver(byte[] ar, int offset, int len, Exception ex) {
        if (Jdt.isThrowCodingException()) {
            throw new DicomCharsetException("unable to decode bytes into String: " + ex, ex);
        }
        if (Jdt.isUsePlatformCharset()) {
            return new String(ar, offset, len);
        }
        CharsetDecoder decoder = DicomCharset.lookup("ISO_IR 100").getJavaCharset().newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        try {
            ByteBuffer bb = ByteBuffer.wrap(ar, offset, len);
            bb.position(offset);
            return decoder.decode(bb).toString();
        }
        catch (CharacterCodingException ex_) {
            throw new DicomCharsetException("unable to decode bytes into String with ISO_IR 100 charset: " + ex_, ex_);
        }
    }
}

