/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.charset;

import com.archimed.dicom.Jdt;
import com.archimed.log.JdtLogger;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class DicomCharset {
    protected static JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomCharset.class);
    private static final HashMap map = new HashMap();
    public static final DicomCharset DEFAULT = DicomCharset.create("", "Default repertoire", null, null, "US-ASCII");
    public static final DicomCharset ISO_IR_100 = DicomCharset.create("ISO_IR 100", "Latin alphabet No. 1", null, null, "ISO-8859-1");
    public static final DicomCharset ISO_IR_101 = DicomCharset.create("ISO_IR 101", "Latin alphabet No. 2", null, null, "ISO-8859-2");
    public static final DicomCharset ISO_IR_109 = DicomCharset.create("ISO_IR 109", "Latin alphabet No. 3", null, null, "ISO-8859-3");
    public static final DicomCharset ISO_IR_110 = DicomCharset.create("ISO_IR 110", "Latin alphabet No. 4", null, null, "ISO-8859-4");
    public static final DicomCharset ISO_IR_144 = DicomCharset.create("ISO_IR 144", "Cyrillic", null, null, "ISO-8859-5");
    public static final DicomCharset ISO_IR_127 = DicomCharset.create("ISO_IR 127", "Arabic", null, null, "ISO-8859-6");
    public static final DicomCharset ISO_IR_126 = DicomCharset.create("ISO_IR 126", "Greek", null, null, "ISO-8859-7");
    public static final DicomCharset ISO_IR_138 = DicomCharset.create("ISO_IR 138", "Hebrew", null, null, "ISO-8859-8");
    public static final DicomCharset ISO_IR_148 = DicomCharset.create("ISO_IR 148", "Latin alphabet No. 5", null, null, "ISO-8859-9");
    public static final DicomCharset ISO_IR_13 = DicomCharset.create("ISO_IR 13", "Japanese", null, null, "JIS_X0201");
    public static final DicomCharset ISO_IR_166 = DicomCharset.create("ISO_IR 166", "Thai", null, null, "TIS-620");
    public static final DicomCharset ISO_2022_IR_6 = DicomCharset.create("ISO 2022 IR 6", "Default repertoire (Code Extensions)", null, new byte[]{40, 66}, "US-ASCII");
    public static final DicomCharset ISO_2022_IR_100 = DicomCharset.create("ISO 2022 IR 100", "Latin alphabet No. 1 (Code Extensions)", new byte[]{45, 65}, new byte[]{40, 66}, "ISO-8859-1");
    public static final DicomCharset ISO_2022_IR_101 = DicomCharset.create("ISO 2022 IR 101", "Latin alphabet No. 2 (Code Extensions)", new byte[]{45, 66}, new byte[]{40, 66}, "ISO-8859-2");
    public static final DicomCharset ISO_2022_IR_109 = DicomCharset.create("ISO 2022 IR 109", "Latin alphabet No. 3 (Code Extensions)", new byte[]{45, 67}, new byte[]{40, 66}, "ISO-8859-3");
    public static final DicomCharset ISO_2022_IR_110 = DicomCharset.create("ISO 2022 IR 110", "Latin alphabet No. 4 (Code Extensions)", new byte[]{45, 68}, new byte[]{40, 66}, "ISO-8859-4");
    public static final DicomCharset ISO_2022_IR_144 = DicomCharset.create("ISO 2022 IR 144", "Cyrillic (Code Extensions)", new byte[]{45, 76}, new byte[]{40, 66}, "ISO-8859-5");
    public static final DicomCharset ISO_2022_IR_127 = DicomCharset.create("ISO 2022 IR 127", "Arabic (Code Extensions)", new byte[]{45, 71}, new byte[]{40, 66}, "ISO-8859-6");
    public static final DicomCharset ISO_2022_IR_126 = DicomCharset.create("ISO 2022 IR 126", "Greek (Code Extensions)", new byte[]{45, 70}, new byte[]{40, 66}, "ISO-8859-7");
    public static final DicomCharset ISO_2022_IR_138 = DicomCharset.create("ISO 2022 IR 138", "Hebrew (Code Extensions)", new byte[]{45, 72}, new byte[]{40, 66}, "ISO-8859-8");
    public static final DicomCharset ISO_2022_IR_148 = DicomCharset.create("ISO 2022 IR 148", "Latin alphabet No. 5 (Code Extensions)", new byte[]{45, 77}, new byte[]{40, 66}, "ISO-8859-9");
    public static final DicomCharset ISO_2022_IR_13 = DicomCharset.create("ISO 2022 IR 13", "Japanese (Code Extensions)", new byte[]{41, 73}, new byte[]{40, 74}, "JIS_X0201");
    public static final DicomCharset ISO_2022_IR_166 = DicomCharset.create("ISO 2022 IR 166", "Thai (Code Extensions)", new byte[]{45, 84}, new byte[]{40, 66}, "TIS-620");
    public static final DicomCharset ISO_2022_IR_87 = DicomCharset.create("ISO 2022 IR 87", "Japanese (JIS X 0208)", null, new byte[]{36, 66}, "x-JIS0208");
    public static final DicomCharset ISO_2022_IR_159 = DicomCharset.create("ISO 2022 IR 159", "Japanese (JIS X 0212)", null, new byte[]{36, 40, 68}, "JIS_X0212-1990");
    public static final DicomCharset ISO_2022_IR_149 = DicomCharset.create("ISO 2022 IR 149", "Korean (KS X 1001)", new byte[]{36, 41, 67}, null, "EUC-KR");
    public static final DicomCharset ISO_IR_192 = DicomCharset.create("ISO_IR 192", "Unicode in UTF-8", null, null, "UTF-8");
    public static final DicomCharset GB18030 = DicomCharset.create("GB18030", "GB18030", null, null, "GB18030");
    private String description;
    private String definedTerm;
    private byte[] escapeSequence1;
    private byte[] escapeSequence2;
    private String jCharsetName;

    public DicomCharset(String definedTerm, String description, byte[] escapeSequence1, byte[] escapeSequence2, String jCharsetName) {
        this.description = description;
        this.definedTerm = definedTerm;
        this.escapeSequence1 = escapeSequence1;
        this.escapeSequence2 = escapeSequence2;
        this.jCharsetName = jCharsetName;
    }

    private static DicomCharset create(String definedTerm, String description, byte[] escapeSequence1, byte[] escapeSequence2, String jCharsetName) {
        DicomCharset dcs = new DicomCharset(definedTerm, description, escapeSequence1, escapeSequence2, jCharsetName);
        map.put(definedTerm, dcs);
        try {
            Charset.forName(jCharsetName);
        }
        catch (IllegalCharsetNameException ex) {
            log.warn("charset " + definedTerm + " (" + jCharsetName + ") not available, no decoding/encoding in this charset possible. " + ex);
        }
        catch (UnsupportedCharsetException ex) {
            log.warn("charset " + definedTerm + " (" + jCharsetName + ") not available, no decoding/encoding in this charset possible. " + ex);
        }
        return dcs;
    }

    public static DicomCharset lookup(String definedTerm) {
        return (DicomCharset)map.get(definedTerm);
    }

    public static DicomCharset lookup(byte[] escapeSequence) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            DicomCharset dc = (DicomCharset)map.get(it.next());
            if (Arrays.equals(escapeSequence, dc.escapeSequence1)) {
                return dc;
            }
            if (!Arrays.equals(escapeSequence, dc.escapeSequence2)) continue;
            return dc;
        }
        return null;
    }

    public Charset getJavaCharset() throws UnsupportedCharsetException, IllegalCharsetNameException {
        return Charset.forName(this.jCharsetName);
    }

    public String getDefinedTerm() {
        return this.definedTerm;
    }

    public byte[] getEscapeSequenceG1() {
        return this.escapeSequence1;
    }

    public byte[] getEscapeSequenceG0() {
        return this.escapeSequence2;
    }
}

