/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.LengthUtils;
import com.archimed.dicom.MultiVRInputStream;
import com.archimed.dicom.MultiVROutputStream;
import com.archimed.dicom.PrimitiveInputStream;
import com.archimed.dicom.PrimitiveOutputStream;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.UID;
import com.archimed.log.JdtLogger;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Enumeration;
import java.util.Vector;

class VR
extends DataElement {
    private static final int UNDEFINED_LENGTH_INT = -1;
    private static final long UNDEFINED_LENGTH_LONG = 0xFFFFFFFFL;
    private static final long serialVersionUID = 1L;
    static final int SEQ_NEW = 1;
    static final int SEQ_UNDEFLEN = 2;
    static final int SEQ_DEFLEN = 3;
    static final int PUSH_AND_CONTINUE = 1;
    static final int SKIP_AND_CONTINUE = 2;
    static final int PUSH_AND_STOP = 3;
    static final int SKIP_AND_STOP = 4;
    protected int headerLen = 0;
    protected int seqLenState = 1;
    protected boolean readEncapsulated = false;
    protected transient JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(VR.class);

    protected VR(DicomObject dcm) {
        this.dcm = dcm;
        this.group = 0;
        this.element = 0;
        this.val = new Vector();
        this.dcm_type = 0;
        this.dataLen = 0L;
        this.headerLen = 0;
    }

    protected VR(DicomObject dcm, int g, int e, int dcm_t) {
        this.dcm = dcm;
        this.group = g;
        this.element = e;
        this.dcm_type = dcm_t;
    }

    protected VR(DicomObject dcm, int g, int e, int dcm_t, Object data, int data_l) {
        this.dcm = dcm;
        this.group = g;
        this.element = e;
        this.val = new Vector();
        this.dcm_type = dcm_t;
        this.val.addElement(data);
        this.dataLen = data_l;
        this.headerLen = 8;
    }

    private Object readResolve() throws ObjectStreamException {
        this.log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomObject.class);
        return this;
    }

    protected int getDDType() {
        int dd_type = DDict.lookupDDict(this.group, this.element);
        return dd_type;
    }

    protected void writeVRHeader(PrimitiveOutputStream os, int seqLengthOpt) throws IOException, DicomException {
        this.printDebugMessage("VR.writeVRHeader", this.group, this.element);
        int transSyn = os.getTransferSyntax();
        int dlen = 0;
        byte[] reserved = new byte[]{0, 0};
        os.writeInt16(this.group);
        os.writeInt16(this.element);
        if (this.group == 2) {
            transSyn = 8194;
        }
        dlen = (int)this.dataLen;
        if (this.dcm_type == 10 && this.mustWriteUndefLenSeq(seqLengthOpt)) {
            dlen = -1;
        } else if ((this.dcm_type == 24 || this.dcm_type == 8 || this.dcm_type == 22) && this.val.size() > 1) {
            dlen = -1;
        } else if (this.size() == 0) {
            dlen = 0;
        }
        if (transSyn == 8193 || transSyn == 8227) {
            os.writeInt32(dlen);
        } else {
            if (this.dcm_type == 22) {
                this.dcm_type = this.selectOBOW(this.dcm, this.group, this.element, transSyn);
            }
            this.checkOBOW(this.dcm, this.group, this.element, transSyn);
            String typeDesc = DDict.getTypeName(this.dcm_type);
            os.writeString(typeDesc.substring(0, 2));
            switch (this.dcm_type) {
                case 0: 
                case 8: 
                case 10: 
                case 22: 
                case 24: 
                case 27: 
                case 29: {
                    os.write(reserved);
                    os.writeInt32(dlen);
                    break;
                }
                default: {
                    os.writeInt16(dlen);
                }
            }
        }
    }

    private void writeSequenceItem(MultiVROutputStream os, DicomObject seq_item, int seqLengthOpt, int groupLengthOpt) throws IOException, DicomException {
        Enumeration e = seq_item.enumerateVRs(os.getTransferSyntax(), seqLengthOpt, groupLengthOpt);
        while (e.hasMoreElements()) {
            VR vr2 = (VR)e.nextElement();
            vr2.writeVRHeader(os, seqLengthOpt);
            vr2.writeVRData(os, seqLengthOpt, groupLengthOpt);
        }
    }

    private boolean mustWriteUndefLenSeq(int seqLengthOpt) {
        if (seqLengthOpt == 8200) {
            return true;
        }
        if (seqLengthOpt == 8201) {
            return false;
        }
        if (seqLengthOpt == 8208) {
            return this.seqLenState != 3;
        }
        if (seqLengthOpt == 8209) {
            return this.seqLenState == 2;
        }
        throw new IllegalArgumentException("unknown seqLengthOpt");
    }

    protected boolean isEncapsulatedPixelData() {
        if (this.group != 32736 || this.element != 16) {
            return false;
        }
        return this.val.size() > 1;
    }

    private void writeSequence(MultiVROutputStream os, int seqLengthOpt, int grouplengthOpt) throws DicomException, IOException {
        if (this.mustWriteUndefLenSeq(seqLengthOpt)) {
            for (int i = 0; i < this.val.size(); ++i) {
                DicomObject si = (DicomObject)this.val.elementAt(i);
                os.writeInt16(65534);
                os.writeInt16(57344);
                os.writeInt32(-1);
                this.writeSequenceItem(os, si, seqLengthOpt, grouplengthOpt);
                os.writeInt16(65534);
                os.writeInt16(57357);
                os.writeInt32(0);
            }
            os.writeInt16(65534);
            os.writeInt16(57565);
            os.writeInt32(0);
        } else {
            for (int i = 0; i < this.val.size(); ++i) {
                DicomObject si = (DicomObject)this.val.elementAt(i);
                os.writeInt16(65534);
                os.writeInt16(57344);
                os.writeInt32((int)(LengthUtils.sequenceItemLength(si, os.getTransferSyntax(), seqLengthOpt, grouplengthOpt) - 8L));
                this.writeSequenceItem(os, si, seqLengthOpt, grouplengthOpt);
            }
        }
    }

    private void writeMultiValuedOBOW(MultiVROutputStream os) throws IOException, DicomException {
        for (int i = 0; i < this.val.size(); ++i) {
            ByteArray frame = (ByteArray)this.val.elementAt(i);
            os.writeInt16(65534);
            os.writeInt16(57344);
            long length = frame.length() % 2L > 0L ? frame.length() + 1L : frame.length();
            os.writeInt32((int)length);
            if (frame.length() == 0L) continue;
            os.write(frame);
            if (frame.length() % 2L <= 0L) continue;
            os.write(0);
        }
        os.writeInt16(65534);
        os.writeInt16(57565);
        os.writeInt32(0);
    }

    protected void writeVRData(MultiVROutputStream os, int seqLengthOpt, int groupLengthOpt) throws IOException, DicomException {
        switch (this.dcm_type) {
            case 10: {
                this.printDebugMessage("VR.writeVRData <sequence>", this.group, this.element);
                this.writeSequence(os, seqLengthOpt, groupLengthOpt);
                return;
            }
            case 8: 
            case 22: 
            case 24: {
                if (this.val.size() > 1) {
                    this.printDebugMessage("VR.writeVRData <multi valued OW or OB>", this.group, this.element);
                    this.writeMultiValuedOBOW(os);
                    return;
                }
                if (this.val.size() == 1) {
                    this.printDebugMessage("VR.writeVRData <single valued OW or OB>", this.group, this.element);
                    if (this.group == 32736 && this.element == 16 && os.getTransferSyntax() == 8227) {
                        this.printDebugMessage("GEPrivate syntax: setting pixeldata to OW and temporarely switching to ExplicitVRBigEndian to read big endian OW pixel data", this.group, this.element);
                        this.dcm_type = 24;
                        os.setTransferSyntax(8195);
                    }
                    os.writeVRValues(this.val, this.dcm_type);
                    if (this.group == 32736 && this.element == 16 && os.getTransferSyntax() == 8227) {
                        this.printDebugMessage("switching back to GEPrivate", this.group, this.element);
                        os.setTransferSyntax(8227);
                    }
                    return;
                }
                return;
            }
        }
        if (this.dataLen == 0L || this.size() == 0) {
            this.printDebugMessage("VR.writeVRData <empty>", this.group, this.element);
            return;
        }
        this.printDebugMessage("VR.writeVRData <normal>", this.group, this.element);
        os.writeVRValues(this.val, this.dcm_type);
    }

    protected int readVR(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, boolean processPixelData) throws IOException, DicomException {
        long offset = is.getOffset();
        this.readVRHeader(is);
        if (this.dataLen < 0L && this.dataLen != 0xFFFFFFFFL) {
            String s = "value length for tag " + DumpUtils.tagDescriptionString(this.group, this.element) + " exceeds internal limit of 2^31-1, file probably corrupt";
            this.log.fatal(s);
            throw new DicomException(s);
        }
        if (!processPixelData && this.group == 32736 && this.element == 16) {
            if (this.dataLen >= 0L) {
                is.skipBytes(this.dataLen);
            } else {
                this.readCompressedPixelData(is);
            }
            return 2;
        }
        if (this.group == 65534 && this.element == 57357) {
            return 2;
        }
        TagReadEvent tre = dicomReader.fireAfterReadHeader(this, is, offset);
        if (tre == null || tre.getDataReadStatus() == 0) {
            ReadState readState = new ReadState();
            this.readVRData(dcm, dicomReader, is, readState);
            if (tre != null) {
                tre = dicomReader.fireAfterReadData(tre);
            }
            if (readState.isStopped()) {
                return 3;
            }
            if (this.element != 0) {
                return tre != null && tre.isStopReading() ? 3 : 1;
            }
            return tre != null && tre.isStopReading() ? 4 : 2;
        }
        if (tre.getDataReadStatus() == 1) {
            if (this.dataLen == 0xFFFFFFFFL) {
                this.skipUndefinedLengthTag(dcm, dicomReader, is);
            } else {
                is.skipBytes(this.dataLen);
            }
            this.dataLen = 0L;
            if (this.element != 0) {
                return tre.isStopReading() ? 3 : 1;
            }
            return tre.isStopReading() ? 4 : 2;
        }
        if (tre.getDataReadStatus() == 2) {
            if (tre.isStopReading()) {
                return 4;
            }
            if (this.dataLen == 0xFFFFFFFFL) {
                this.skipUndefinedLengthTag(dcm, dicomReader, is);
            } else {
                is.skipBytes(this.dataLen);
            }
            return 2;
        }
        if (tre.getDataReadStatus() == 3) {
            return tre.isStopReading() ? 4 : 2;
        }
        return tre.isStopReading() ? 4 : 2;
    }

    private void skipUndefinedLengthTag(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is) throws DicomException, IOException {
        switch (this.dcm_type) {
            case 10: {
                this.readSequence(dcm, dicomReader, is, new ReadState());
                break;
            }
            case 8: 
            case 22: 
            case 24: {
                this.readCompressedPixelData(is);
                break;
            }
            case 0: {
                this.readUNVRUndefinedLength(dcm, dicomReader, is);
                break;
            }
            default: {
                throw new DicomException("encountered illegal undefined length for VR: " + DDict.getTypeCodeName(this.dcm_type));
            }
        }
    }

    private boolean readVRHeader(PrimitiveInputStream is) throws IOException, DicomException {
        String tc;
        long offset;
        block21: {
            offset = is.getOffset();
            int ts = is.getTransferSyntax();
            this.group = is.readUInt16();
            this.element = is.readUInt16();
            tc = null;
            if (this.group == 2) {
                ts = 8194;
            }
            if (this.element == 0) {
                this.dcm_type = 1;
            } else if (DDictBase.isPrivateTag(this.group, this.element)) {
                String creator = null;
                try {
                    creator = this.dcm.getString_ge(this.group, this.element >> 8, 0);
                    this.dcm_type = DDict.getTypeCode(this.group, this.element, creator);
                }
                catch (Throwable ex) {
                    this.log.warn("Exception while getting private creator for private data element: " + ex);
                    creator = null;
                    this.dcm_type = DDict.getTypeCode(this.group, this.element);
                }
            } else {
                this.dcm_type = DDictBase.isPrivateCreatorTag(this.group, this.element) ? 6 : DDict.getTypeCode(this.group, this.element);
            }
            if (ts == 8193 || ts == 8227) {
                this.dataLen = is.readUInt32AsLong();
                this.headerLen = 8;
            } else {
                tc = is.readString(2);
                if (this.group != 65534 || this.element != 57357) {
                    try {
                        this.dcm_type = DDict.getTypeCode(tc);
                    }
                    catch (DicomException ex) {
                        if (this.group == 2 && Jdt.isReadFileMetaImplicit()) {
                            is.unread(tc.getBytes());
                            this.dataLen = is.readUInt32AsLong();
                            this.headerLen = 8;
                            break block21;
                        }
                        throw ex;
                    }
                }
                switch (this.dcm_type) {
                    case 0: 
                    case 8: 
                    case 10: 
                    case 24: 
                    case 27: 
                    case 29: {
                        is.skipBytes(2L);
                        this.dataLen = is.readUInt32AsLong();
                        this.headerLen = 12;
                        break;
                    }
                    default: {
                        this.dataLen = is.readUInt16();
                        this.headerLen = 8;
                    }
                }
                if (Jdt.isLookupDDict() && this.dcm_type == 0) {
                    this.dcm_type = DDict.getTypeCode(this.group, this.element);
                }
            }
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("VR.readVRHeader (ts: ");
            sb.append(UID.getUIDEntry(is.getTransferSyntax()).getValue());
            sb.append(") offset: ");
            sb.append(offset);
            sb.append(" length: ");
            sb.append(this.dataLen);
            if (tc != null) {
                sb.append(" VR: ");
                sb.append(tc);
            }
            this.printDebugMessage(sb.toString(), this.group, this.element);
        }
        catch (IllegalValueException e) {
            // empty catch block
        }
        if (this.group == 32736 && this.element == 16 && this.dataLen == 0xFFFFFFFFL) {
            this.readEncapsulated = true;
        }
        return true;
    }

    DicomObject readOrphanedSequenceItem(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream multiVRin) throws IOException, DicomException {
        ReadState readState = new ReadState();
        return this.readSequenceItem(dcm, dicomReader, multiVRin, readState);
    }

    private DicomObject readSequenceItem(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, ReadState readState) throws IOException, DicomException {
        DicomObject v = new DicomObject(dcm);
        v.offset = is.getOffset() - 4L;
        long len = is.readUInt32AsLong();
        if (len != 0xFFFFFFFFL) {
            v.setSeqItemLenState(3);
            v.length = 0L;
            long end = is.getOffset() + len;
            while (is.getOffset() != end) {
                VR vr2 = new VR(v);
                int rs = vr2.readVR(v, dicomReader, is, true);
                v.length += (long)vr2.headerLen;
                v.length += vr2.dataLen;
                if (rs == 1) {
                    v.push(vr2);
                    continue;
                }
                if (rs == 3) {
                    v.push(vr2);
                    readState.setStopped(true);
                    return v;
                }
                if (rs == 2 || rs != 4) continue;
                readState.setStopped(true);
                return v;
            }
        } else {
            v.setSeqItemLenState(2);
            boolean item_end = false;
            v.length = 0L;
            while (!item_end) {
                VR vr3 = new VR(v);
                int rs = vr3.readVR(v, dicomReader, is, true);
                if (vr3.group != 65534 || vr3.element != 57357) {
                    v.length += (long)vr3.headerLen;
                    v.length += vr3.dataLen;
                    if (rs == 1) {
                        v.push(vr3);
                        continue;
                    }
                    if (rs == 3) {
                        v.push(vr3);
                        readState.setStopped(true);
                        return v;
                    }
                    if (rs == 2 || rs != 4) continue;
                    readState.setStopped(true);
                    return v;
                }
                break;
            }
        }
        v.length += 16L;
        dicomReader.fireAfterReadSequenceItem(this, v, is);
        return v;
    }

    private Vector readSequence(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, ReadState readState) throws DicomException, IOException {
        Vector<DicomObject> seq = new Vector<DicomObject>();
        if (this.dataLen != 0xFFFFFFFFL) {
            this.seqLenState = 3;
            long end = is.getOffset() + this.dataLen;
            this.dataLen = 0L;
            while (is.getOffset() != end) {
                DicomObject seq_item;
                int tagg = is.readUInt16();
                int tage = is.readUInt16();
                if (tagg != 65534 || tage != 57344 || (seq_item = this.readSequenceItem(dcm, dicomReader, is, readState)) == null) continue;
                this.dataLen += seq_item.length;
                seq.addElement(seq_item);
                if (!readState.isStopped()) continue;
                break;
            }
        } else {
            this.seqLenState = 2;
            boolean seq_end = false;
            this.dataLen = 0L;
            while (!seq_end) {
                int tagg = is.readUInt16();
                int tage = is.readUInt16();
                if (tagg == 65534 && tage == 57344) {
                    DicomObject seq_item = this.readSequenceItem(dcm, dicomReader, is, readState);
                    if (seq_item == null) continue;
                    this.dataLen += seq_item.length;
                    seq.addElement(seq_item);
                    if (!readState.isStopped()) continue;
                    break;
                }
                if (tagg == 65534 && tage == 57565) {
                    is.skipBytes(4L);
                    seq_end = true;
                    continue;
                }
                if (Jdt.isNoSeqDelim()) {
                    this.log.warn("unexpected tag read in private sequence of undefined length and seqdelim=true: unreading 4bytes and treating this as end of sequence");
                    is.unreadUInt16(tage);
                    is.unreadUInt16(tagg);
                    seq_end = true;
                    continue;
                }
                this.log.error("unexpected tag read in private sequence of undefined length and seqdelim=false: throwing exception");
                throw new DicomException("Unexpected tag read: (" + tagg + "," + tage + ") at offset " + is.getOffset());
            }
        }
        this.dataLen += 8L;
        return seq;
    }

    private Vector readUNVRUndefinedLength(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is) throws DicomException, IOException {
        Vector<DicomObject> seq = new Vector<DicomObject>();
        int orgts = is.getTransferSyntax();
        is.setTransferSyntax(8193);
        boolean firstTime = true;
        boolean seq_end = false;
        this.dataLen = 0L;
        while (!seq_end) {
            int tagg = is.readUInt16();
            int tage = is.readUInt16();
            if (tagg == 65534 && tage == 57344) {
                DicomObject seq_item;
                if (firstTime) {
                    this.dcm_type = 10;
                    firstTime = false;
                }
                if ((seq_item = this.readSequenceItem(dcm, dicomReader, is, new ReadState())) == null) continue;
                this.dataLen += seq_item.length;
                seq.addElement(seq_item);
                continue;
            }
            if (tagg == 65534 && tage == 57565) {
                is.skipBytes(4L);
                seq_end = true;
                continue;
            }
            if (Jdt.isNoSeqDelim()) {
                this.log.warn("unexpected tag read in private sequence of undefined length and seqdelim=true: unreading 4bytes and treating this as end of sequence");
                is.unreadUInt16(tage);
                is.unreadUInt16(tagg);
                seq_end = true;
                continue;
            }
            this.log.error("unexpected tag read in private sequence of undefined length and seqdelim=false: throwing exception");
            throw new DicomException("Unexpected tag read: (" + tagg + "," + tage + ") at offset " + is.getOffset());
        }
        this.dataLen += 8L;
        is.setTransferSyntax(orgts);
        return seq;
    }

    private Vector readVRUndefinedLengthHelper(MultiVRInputStream is) throws DicomException, IOException {
        Vector<byte[]> obar = new Vector<byte[]>();
        this.dataLen = 0L;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrimitiveOutputStream primout = new PrimitiveOutputStream(bout);
        primout.setTransferSyntax(is.getTransferSyntax());
        int tagg = is.readUInt16();
        this.dataLen += 2L;
        while (true) {
            int tage = is.readUInt16();
            if (tagg == 65534 && tage == 57565) {
                is.skipBytes(4L);
                this.dataLen -= 2L;
                obar.addElement(bout.toByteArray());
                return obar;
            }
            primout.writeInt16(tagg);
            this.dataLen += 2L;
            tagg = tage;
        }
    }

    private Vector readCompressedPixelData(MultiVRInputStream is) throws DicomException, IOException {
        int tage;
        int tagg;
        Vector<ByteArray> obar = new Vector<ByteArray>();
        while (true) {
            tagg = is.readUInt16();
            tage = is.readUInt16();
            this.dataLen += 4L;
            if (tagg == 65534 && tage == 57565) {
                is.skipBytes(4L);
                this.dataLen += 4L;
                return obar;
            }
            if (tagg != 65534 || tage != 57344) break;
            long len = is.readUInt32();
            this.dataLen += 4L;
            ByteArray byteArray = new ByteArray(len);
            is.readFully(byteArray);
            this.dataLen += len;
            obar.addElement(byteArray);
        }
        throw new DicomException("Unexpected tag encountered: (" + tagg + "," + tage + ").");
    }

    private void checkCorruptDAs(MultiVRInputStream is) throws IOException {
        if (this.dcm_type != 11 || this.dataLen != 8L) {
            return;
        }
        this.printDebugMessage("Checking DA corruption for:", this.getGroup(), this.getElement());
        if (is.available() == 0) {
            this.log.debug("0 bytes available in stream: -> resetting tag length to 0");
            this.dataLen = 0L;
            return;
        }
        is.mark(8);
        boolean knownTag = false;
        int nextGroup = is.readUInt16();
        int nextElem = is.readUInt16();
        if (DDict.lookupDDict(nextGroup, nextElem) != Integer.MAX_VALUE) {
            this.printDebugMessage("\t8 next bytes can be interpreted as a known tag", nextGroup, nextElem);
            knownTag = true;
        } else {
            this.printDebugMessage("\t8 next bytes can NOT be interpreted as a known tag", nextGroup, nextElem);
        }
        is.reset();
        boolean illegalChar = false;
        byte[] buf = new byte[8];
        is.read(buf);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] >= 48 && buf[i] <= 57) continue;
            this.printDebugMessage("\tfound non-numerical char for", this.getGroup(), this.getElement());
            illegalChar = true;
            break;
        }
        if (!illegalChar) {
            this.printDebugMessage("\tall chars numerical for", this.getGroup(), this.getElement());
        }
        is.reset();
        if (knownTag && illegalChar) {
            this.log.debug("\t-> RESETTING length to 0");
            this.dataLen = 0L;
        } else {
            this.log.debug("\t-> keeping tag as is");
        }
    }

    private void readVRData(DicomObject dcm, DicomReader dicomReader, MultiVRInputStream is, ReadState readState) throws IOException, DicomException {
        if (Jdt.isFixDA()) {
            this.checkCorruptDAs(is);
        }
        if (this.dataLen == 0L) {
            this.printDebugMessage("VR.readVRData <empty>", this.group, this.element);
            this.val = new Vector();
            return;
        }
        if (this.dcm_type == 10) {
            this.printDebugMessage("VR.readVRData <sequence>", this.group, this.element);
            this.val = this.readSequence(dcm, dicomReader, is, readState);
            return;
        }
        if (this.dataLen == 0xFFFFFFFFL) {
            if (this.dcm_type == 0) {
                this.printDebugMessage("VR.readVRData <type unknown and undefined length>", this.group, this.element);
                this.val = this.readUNVRUndefinedLength(dcm, dicomReader, is);
                return;
            }
            if (this.dcm_type == 8 || this.dcm_type == 24 || this.dcm_type == 22) {
                this.printDebugMessage("VR.readVRData <type OB or OW and undefined length>", this.group, this.element);
                this.val = this.readCompressedPixelData(is);
                return;
            }
            throw new DicomException("illegal type with undefined length: " + DDict.getTypeCode(this.dcm_type));
        }
        this.printDebugMessage("VR.readVRData <normal>", this.group, this.element);
        int ts = is.getTransferSyntax();
        if (this.group == 32736 && this.element == 16 && ts == 8227) {
            this.printDebugMessage("GEPrivate syntax: setting pixeldata to OW and temporarely switching to ExplicitVRBigEndian to read big endian OW pixel data", this.group, this.element);
            this.dcm_type = 24;
            is.setTransferSyntax(8195);
        }
        try {
            this.val = is.readVRValues(this.dcm_type, this.dataLen);
        }
        catch (EOFException ex) {
            String s = "Encountered EOFException while reading data part of data element ";
            s = s + DumpUtils.tagString(this.group, this.element) + " with specified length: " + this.dataLen;
            s = s + ". Data Element will be added or not depending on value of Jdt property 'readincompletetag'";
            this.log.error(s);
            throw ex;
        }
        if (this.group == 32736 && this.element == 16 && ts == 8227) {
            this.printDebugMessage("switching back to GEPrivate", this.group, this.element);
            is.setTransferSyntax(8227);
        }
    }

    private int selectOBOW(DicomObject dcm, int group, int element, int ts) {
        int tag2 = DDict.lookupDDict(group, element);
        boolean topLevel = dcm.getParent() == null;
        boolean encapTS = ts != 8194 && ts != 8193 && ts != 8195;
        switch (tag2) {
            case 0x7FFFFFFF: {
                return 24;
            }
            case 1184: {
                if (topLevel && encapTS) {
                    return 8;
                }
                if (this.val.size() > 1) {
                    return 8;
                }
                return 24;
            }
        }
        return 24;
    }

    private void checkOBOW(DicomObject dcm, int group, int element, int ts) {
        boolean encapTS;
        int tag2 = DDict.lookupDDict(group, element);
        boolean topLevel = dcm.getParent() == null;
        boolean bl = encapTS = ts != 8194 && ts != 8193 && ts != 8195;
        if (tag2 == 1184 && topLevel && encapTS && this.dcm_type == 24) {
            this.log.warn("Pixeldata in top-level Data Set must have VR OB when transfer syntax is encapsulated");
        }
    }

    private void printDebugMessage(String msg, int g, int e) {
        this.log.debug(msg + " " + DumpUtils.tagDescriptionString(g, e));
    }

    class ReadState {
        boolean stopped = false;

        ReadState() {
        }

        public void setStopped(boolean b) {
            this.stopped = b;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

