/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.Jdt;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

class Sleutel {
    private long num = 122L;
    private long sleutel = Long.MAX_VALUE;

    Sleutel() {
    }

    private long decodeTime(BufferedReader in) {
        long k = 0L;
        try {
            for (int i = 0; i < 19; ++i) {
                k *= 10L;
                String s = in.readLine();
                long l = Long.parseLong(s) % this.num;
                k += l;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0L;
        }
        return k;
    }

    private String decodeVersion(BufferedReader in) {
        String version2 = "";
        for (int i = 0; i < 3; ++i) {
            try {
                String line = in.readLine();
                if (line == null) {
                    return null;
                }
                long l = Long.parseLong(line) % this.num;
                version2 = version2 + (char)l;
                continue;
            }
            catch (Throwable _ex) {
                _ex.printStackTrace();
                return null;
            }
        }
        return version2;
    }

    private long numberOfDays() {
        long diff = this.sleutel - System.currentTimeMillis();
        return diff / 86400000L;
    }

    private boolean checkTime() {
        if (this.sleutel == Long.MAX_VALUE) {
            return true;
        }
        if (this.sleutel == 0L) {
            return false;
        }
        if (this.sleutel > System.currentTimeMillis()) {
            System.out.println("Your evaluation copy of JDT expires in " + this.numberOfDays() + " days.");
            return true;
        }
        return false;
    }

    private void printPest() {
        System.out.println("Your evaluation copy of Trispark JDT has expired.");
        System.out.println("Please contact Trispark (www.trispark.com) for a license.");
    }

    private void printKeyNotFound() {
        System.out.println("Unable to find key file 'jdt.key' in classpath");
    }

    private void printIncompatibleKey() {
        System.out.println("Key is for JDT version < 1.19. This is JDT version: " + Jdt.getVersion());
        System.out.println("Please contact Trispark (www.trispark.com) for a new key.");
    }

    private void printWrongVersionKey(String keyVersion) {
        System.out.println("Key is for JDT version " + keyVersion + ". This is JDT version " + Jdt.getVersion());
        System.out.println("Please contact Trispark (www.trispark.com) for a new key.");
    }

    void checkKey() {
        InputStream in = this.getClass().getResourceAsStream("/jdt.key");
        if (in == null) {
            this.printKeyNotFound();
            System.exit(0);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        this.sleutel = this.decodeTime(br);
        String version2 = this.decodeVersion(br);
        try {
            Long.parseLong(version2);
        }
        catch (NumberFormatException ex) {
            version2 = null;
        }
        if (version2 == null) {
            this.printIncompatibleKey();
            System.exit(0);
        } else if (!version2.equals("000") && !version2.equals("" + Jdt.MAJOR_VERSION + Jdt.MINOR_VERSION)) {
            this.printWrongVersionKey(version2);
            System.exit(0);
        }
        if (!this.checkTime()) {
            this.printPest();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Sleutel sl = new Sleutel();
        sl.checkKey();
    }
}

