/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.PrimitiveOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class SingleVROutputStream
extends PrimitiveOutputStream {
    SingleVROutputStream(OutputStream out) {
        super(out);
    }

    SingleVROutputStream(OutputStream out, long beginoff) {
        super(out, beginoff);
    }

    int writeAS(Object o) throws IOException {
        return this.writeString((String)o);
    }

    int writeAT(Object o) throws IOException {
        ATValue at = (ATValue)o;
        return this.writeInt16(at.getGroup()) + this.writeInt16(at.getElement());
    }

    int writeFL(Object o) throws IOException {
        return this.writeInt32(Float.floatToIntBits(((Float)o).floatValue()));
    }

    int writeFD(Object o) throws IOException {
        return this.writeInt64(Double.doubleToLongBits((Double)o));
    }

    int writeSL(Object o) throws IOException {
        return this.writeInt32(((Long)o).intValue());
    }

    int writeSS(Object o) throws IOException {
        return this.writeInt16(((Short)o).intValue());
    }

    int writeUL(Object o) throws IOException {
        return this.writeInt32(((Long)o).intValue());
    }

    int writeUS(Object o) throws IOException {
        return this.writeInt16((Integer)o);
    }

    int writeUS_SS(Object o) throws IOException {
        return this.writeInt16((Integer)o);
    }

    int writeFixed(Object o, int dcm_type) throws IOException {
        switch (dcm_type) {
            case 17: {
                return this.writeAS(o);
            }
            case 5: {
                return this.writeAT(o);
            }
            case 26: {
                return this.writeFL(o);
            }
            case 20: {
                return this.writeFD(o);
            }
            case 19: {
                return this.writeSL(o);
            }
            case 23: {
                return this.writeSS(o);
            }
            case 1: {
                return this.writeUL(o);
            }
            case 3: {
                return this.writeUS(o);
            }
            case 21: {
                return this.writeUS_SS(o);
            }
        }
        return 0;
    }
}

