/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.PrimitiveInputStream;
import java.io.IOException;
import java.io.InputStream;

class SingleVRInputStream
extends PrimitiveInputStream {
    SingleVRInputStream(InputStream in) {
        super(in);
    }

    SingleVRInputStream(InputStream in, int beginoff) {
        super(in, beginoff);
    }

    String readAS() throws IOException {
        return this.readString(4);
    }

    ATValue readAT() throws IOException {
        return new ATValue(this.readUInt16(), this.readUInt16());
    }

    Float readFL() throws IOException {
        return new Float(Float.intBitsToFloat(this.readUInt32()));
    }

    Double readFD() throws IOException {
        return new Double(Double.longBitsToDouble(this.readSInt64()));
    }

    Long readSL() throws IOException {
        return new Long(this.readSInt32());
    }

    Short readSS() throws IOException {
        return new Short((short)this.readSInt16());
    }

    Long readUL() throws IOException {
        return new Long(this.unsignToLong(this.readUInt32()));
    }

    Integer readUS() throws IOException {
        return new Integer(this.readUInt16());
    }

    Integer readUS_SS() throws IOException {
        return new Integer(this.readUInt16());
    }

    Object readFixed(int dcm_type) throws IOException {
        switch (dcm_type) {
            case 17: {
                return this.readAS();
            }
            case 5: {
                return this.readAT();
            }
            case 26: {
                return this.readFL();
            }
            case 20: {
                return this.readFD();
            }
            case 19: {
                return this.readSL();
            }
            case 23: {
                return this.readSS();
            }
            case 1: {
                return this.readUL();
            }
            case 3: {
                return this.readUS();
            }
            case 21: {
                return this.readUS_SS();
            }
        }
        return null;
    }
}

