/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.SOPClassUID;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class SOPClass
extends UID {
    public static final int Verification = 4097;
    public static final SOPClassUID VerificationUID = SOPClass.create(4097, "1.2.840.10008.1.1", "Verification SOP Class", "VE", false);
    public static final int MediaStorageDirectoryStorage = 4098;
    public static final SOPClassUID MediaStorageDirectoryStorageUID = SOPClass.create(4098, "1.2.840.10008.1.3.10", "Media Storage Directory Storage SOP Class", "Media Storage Directory", false);
    public static final int BasicStudyContentNotification = 4099;
    public static final SOPClassUID BasicStudyContentNotificationUID = SOPClass.create(4099, "1.2.840.10008.1.9", "Basic Study Content Notification SOP Class", "CN", false);
    public static final int StorageCommitmentPushModel = 4100;
    public static final SOPClassUID StorageCommitmentPushModelUID = SOPClass.create(4100, "1.2.840.10008.1.20.1", "Storage Commitment Push Model SOP Class", "SP", false);
    public static final int StorageCommitmentPullModel = 4101;
    public static final SOPClassUID StorageCommitmentPullModelUID = SOPClass.create(4101, "1.2.840.10008.1.20.2", "Storage Commitment Pull Model SOP Class", "SP", false);
    public static final int DetachedPatientManagement = 4102;
    public static final SOPClassUID DetachedPatientManagementUID = SOPClass.create(4102, "1.2.840.10008.3.1.2.1.1", "Detached Patient Management SOP Class", "PM", false);
    public static final int DetachedVisitManagement = 4103;
    public static final SOPClassUID DetachedVisitManagementUID = SOPClass.create(4103, "1.2.840.10008.3.1.2.2.1", "Detached Visit Management SOP Class", "VM", false);
    public static final int DetachedStudyManagement = 4104;
    public static final SOPClassUID DetachedStudyManagementUID = SOPClass.create(4104, "1.2.840.10008.3.1.2.3.1", "Detached Study Management SOP Class", "SM", false);
    public static final int StudyComponentManagement = 4105;
    public static final SOPClassUID StudyComponentManagementUID = SOPClass.create(4105, "1.2.840.10008.3.1.2.3.2", "Study Component Management SOP Class", "SM", false);
    public static final int DetachedResultsManagement = 4106;
    public static final SOPClassUID DetachedResultsManagementUID = SOPClass.create(4106, "1.2.840.10008.3.1.2.5.1", "Detached Results Management SOP Class", "RM", false);
    public static final int DetachedInterpretationManagement = 4107;
    public static final SOPClassUID DetachedInterpretationManagementUID = SOPClass.create(4107, "1.2.840.10008.3.1.2.6.1", "Detached Interpretation Management SOP Class", "IM", false);
    public static final int BasicFilmSession = 4108;
    public static final SOPClassUID BasicFilmSessionUID = SOPClass.create(4108, "1.2.840.10008.5.1.1.1", "Basic Film Session SOP Class", "FS", false);
    public static final int BasicFilmBox = 4109;
    public static final SOPClassUID BasicFilmBoxUID = SOPClass.create(4109, "1.2.840.10008.5.1.1.2", "Basic Film Box SOP Class", "FB", false);
    public static final int BasicGrayscaleImageBox = 4110;
    public static final SOPClassUID BasicGrayscaleImageBoxUID = SOPClass.create(4110, "1.2.840.10008.5.1.1.4", "Basic Grayscale Image Box SOP Class", "GI", false);
    public static final int BasicColorImageBox = 4111;
    public static final SOPClassUID BasicColorImageBoxUID = SOPClass.create(4111, "1.2.840.10008.5.1.1.4.1", "Basic Color ImageBox SOP Class", "CI", false);
    public static final int ReferencedImageBox = 4112;
    public static final SOPClassUID ReferencedImageBoxUID = SOPClass.create(4112, "1.2.840.10008.5.1.1.4.2", "Referenced Image Box SOP Class", "RI", false);
    public static final int PrintJob = 4113;
    public static final SOPClassUID PrintJobUID = SOPClass.create(4113, "1.2.840.10008.5.1.1.14", "Print Job SOP Class", "PJ", false);
    public static final int BasicAnnotationBox = 4114;
    public static final SOPClassUID BasicAnnotationBoxUID = SOPClass.create(4114, "1.2.840.10008.5.1.1.15", "Basic Annotation Box SOP Class", "AB", false);
    public static final int Printer = 4115;
    public static final SOPClassUID PrinterUID = SOPClass.create(4115, "1.2.840.10008.5.1.1.16", "Printer SOP Class", "P ", false);
    public static final int VOILUTBox = 4116;
    public static final SOPClassUID VOILUTBoxUID = SOPClass.create(4116, "1.2.840.10008.5.1.1.22", "VOI LUT Box SOP Class", "VL", false);
    public static final int ImageOverlayBox = 4117;
    public static final SOPClassUID ImageOverlayBoxUID = SOPClass.create(4117, "1.2.840.10008.5.1.1.24", "Image Overlay Box SOP Class", "IO", false);
    public static final int ComputedRadiographyImageStorage = 4118;
    public static final SOPClassUID ComputedRadiographyImageStorageUID = SOPClass.create(4118, "1.2.840.10008.5.1.4.1.1.1", "Computed Radiography Image Storage SOP Class", "Computed Radiography", true);
    public static final int CTImageStorage = 4119;
    public static final SOPClassUID CTImageStorageUID = SOPClass.create(4119, "1.2.840.10008.5.1.4.1.1.2", "CT Image Storage SOP Class", "CT", true);
    public static final int UltrasoundMultiframeImageStorage = 4120;
    public static final SOPClassUID UltrasoundMultiframeImageStorageUID = SOPClass.create(4120, "1.2.840.10008.5.1.4.1.1.3.1", "Ultrasound Multi-frame Image Storage SOP Class", "Ultrasound Multi-frame", true);
    public static final int MRImageStorage = 4121;
    public static final SOPClassUID MRImageStorageUID = SOPClass.create(4121, "1.2.840.10008.5.1.4.1.1.4", "MR Image Storage SOP Class", "MR", true);
    public static final int UltrasoundImageStorage = 4122;
    public static final SOPClassUID UltrasoundImageStorageUID = SOPClass.create(4122, "1.2.840.10008.5.1.4.1.1.6.1", "Ultrasound Image Storage SOP Class", "Ultrasound", true);
    public static final int SecondaryCaptureImageStorage = 4123;
    public static final SOPClassUID SecondaryCaptureImageStorageUID = SOPClass.create(4123, "1.2.840.10008.5.1.4.1.1.7", "Secondary Capture Image Storage SOP Class", "Secondary Capture", true);
    public static final int StandaloneOverlayStorage = 4124;
    public static final SOPClassUID StandaloneOverlayStorageUID = SOPClass.create(4124, "1.2.840.10008.5.1.4.1.1.8", "Standalone Overlay Storage SOP Class", "Standalone Overlay", true);
    public static final int StandaloneCurveStorage = 4125;
    public static final SOPClassUID StandaloneCurveStorageUID = SOPClass.create(4125, "1.2.840.10008.5.1.4.1.1.9", "Standalone Curve Storage SOP Class", "Standalone Curve", true);
    public static final int StandaloneModalityLUTStorage = 4126;
    public static final SOPClassUID StandaloneModalityLUTStorageUID = SOPClass.create(4126, "1.2.840.10008.5.1.4.1.1.10", "Standalone Modality LUT Storage SOP Class", "Standalone Modality LUT", true);
    public static final int StandaloneVOILUTStorage = 4127;
    public static final SOPClassUID StandaloneVOILUTStorageUID = SOPClass.create(4127, "1.2.840.10008.5.1.4.1.1.11", "Standalone VOI LUT Storage SOP Class", "Standalone VOI LUT", true);
    public static final int XRayAngiographicImageStorage = 4128;
    public static final SOPClassUID XRayAngiographicImageStorageUID = SOPClass.create(4128, "1.2.840.10008.5.1.4.1.1.12.1", "X-Ray Angiographic Image Storage SOP Class", "X-Ray Angiographic", true);
    public static final int XRayRadiofluoroscopicImageStorage = 4129;
    public static final SOPClassUID XRayRadiofluoroscopicImageStorageUID = SOPClass.create(4129, "1.2.840.10008.5.1.4.1.1.12.2", "X-Ray Radiofluoroscopic Image Storage SOP Class", "X-Ray Radiofluoroscopic", true);
    public static final int XRayAngiographicBiPlaneImageStorage = 4130;
    public static final SOPClassUID XRayAngiographicBiPlaneImageStorageUID = SOPClass.create(4130, "1.2.840.10008.5.1.4.1.1.12.3", "X-Ray Angiographic Bi-Plane Image Storage SOP Class", "X-Ray Angiographic Bi-Plane", true);
    public static final int NuclearMedicineImageStorage = 4131;
    public static final SOPClassUID NuclearMedicineImageStorageUID = SOPClass.create(4131, "1.2.840.10008.5.1.4.1.1.20", "Nuclear Medicine Image Storage SOP Class", "Nuclear Medicine", true);
    public static final int PatientRootQueryRetrieveInformationModelFIND = 4132;
    public static final SOPClassUID PatientRootQueryRetrieveInformationModelFINDUID = SOPClass.create(4132, "1.2.840.10008.5.1.4.1.2.1.1", "Patient Root Query/Retrieve Information Model - FIND SOP Class", "PF", false);
    public static final int PatientRootQueryRetrieveInformationModelMOVE = 4133;
    public static final SOPClassUID PatientRootQueryRetrieveInformationModelMOVEUID = SOPClass.create(4133, "1.2.840.10008.5.1.4.1.2.1.2", "Patient Root Query/Retrieve Information Model - MOVE SOP Class", "PM", false);
    public static final int PatientRootQueryRetrieveInformationModelGET = 4134;
    public static final SOPClassUID PatientRootQueryRetrieveInformationModelGETUID = SOPClass.create(4134, "1.2.840.10008.5.1.4.1.2.1.3", "Patient Root Query/Retrieve Information Model - GET SOP Class", "PG", false);
    public static final int StudyRootQueryRetrieveInformationModelFIND = 4135;
    public static final SOPClassUID StudyRootQueryRetrieveInformationModelFINDUID = SOPClass.create(4135, "1.2.840.10008.5.1.4.1.2.2.1", "Study Root Query/Retrieve Information Model - FIND SOP Class", "SF", false);
    public static final int StudyRootQueryRetrieveInformationModelMOVE = 4136;
    public static final SOPClassUID StudyRootQueryRetrieveInformationModelMOVEUID = SOPClass.create(4136, "1.2.840.10008.5.1.4.1.2.2.2", "Study Root Query/Retrieve Information Model - MOVE SOP Class", "SM", false);
    public static final int StudyRootQueryRetrieveInformationModelGET = 4137;
    public static final SOPClassUID StudyRootQueryRetrieveInformationModelGETUID = SOPClass.create(4137, "1.2.840.10008.5.1.4.1.2.2.3", "Study Root Query/Retrieve Information Model - GET SOP Class", "SG", false);
    public static final int PatientStudyOnlyQueryRetrieveInformationModelFIND = 4138;
    public static final SOPClassUID PatientStudyOnlyQueryRetrieveInformationModelFINDUID = SOPClass.create(4138, "1.2.840.10008.5.1.4.1.2.3.1", "Patient/Study Only Query/Retrieve Information Model - FIND SOP Class", "F ", false);
    public static final int PatientStudyOnlyQueryRetrieveInformationModelMOVE = 4139;
    public static final SOPClassUID PatientStudyOnlyQueryRetrieveInformationModelMOVEUID = SOPClass.create(4139, "1.2.840.10008.5.1.4.1.2.3.2", "Patient/Study Only Query/Retrieve Information Model - MOVE SOP Class", "M ", false);
    public static final int PatientStudyOnlyQueryRetrieveInformationModelGET = 4140;
    public static final SOPClassUID PatientStudyOnlyQueryRetrieveInformationModelGETUID = SOPClass.create(4140, "1.2.840.10008.5.1.4.1.2.3.3", "Patient/Study Only Query/Retrieve Information Model - GET SOP Class", "G ", false);
    public static final int ModalityWorklistInformationModelFIND = 4141;
    public static final SOPClassUID ModalityWorklistInformationModelFINDUID = SOPClass.create(4141, "1.2.840.10008.5.1.4.31", "Modality Worklist Information Model - FIND SOP Class", "MW", false);
    public static final int ModalityPerformedProcedureStep = 4142;
    public static final SOPClassUID ModalityPerformedProcedureStepUID = SOPClass.create(4142, "1.2.840.10008.3.1.2.3.3", "Modality Performed Procedure Step SOP Class", "MP", false);
    public static final int ModalityPerformedProcedureStepRetrieve = 4143;
    public static final SOPClassUID ModalityPerformedProcedureStepRetrieveUID = SOPClass.create(4143, "1.2.840.10008.3.1.2.3.4", "Modality Performed Procedure Step Retrieve  SOP Class", "PR", false);
    public static final int ModalityPerformedProcedureStepNotification = 4144;
    public static final SOPClassUID ModalityPerformedProcedureStepNotificationUID = SOPClass.create(4144, "1.2.840.10008.3.1.2.3.5", "Modality Performed Procedure Step Notification SOP Class", "PN", false);
    public static final int PresentationLUT = 4145;
    public static final SOPClassUID PresentationLUTUID = SOPClass.create(4145, "1.2.840.10008.5.1.1.23", "Presentation LUT SOP Class", "PL", false);
    public static final int PrintQueueManagement = 4146;
    public static final SOPClassUID PrintQueueManagementUID = SOPClass.create(4146, "1.2.840.10008.5.1.1.26", "Print Queue Management SOP Class", "PQ", false);
    public static final int StoredPrintStorage = 4147;
    public static final SOPClassUID StoredPrintStorageUID = SOPClass.create(4147, "1.2.840.10008.5.1.1.27", "Stored Print Storage SOP Class", "SP", true);
    public static final int HardcopyGrayscaleImageStorage = 4148;
    public static final SOPClassUID HardcopyGrayscaleImageStorageUID = SOPClass.create(4148, "1.2.840.10008.5.1.1.29", "Hardcopy Grayscale Image Storage SOP Class", "Hardcopy Grayscale", true);
    public static final int HardcopyColorImageStorage = 4149;
    public static final SOPClassUID HardcopyColorImageStorageUID = SOPClass.create(4149, "1.2.840.10008.5.1.1.30", "Hardcopy Color Image Storage SOP Class", "Hardcopy Color", true);
    public static final int PullPrintRequest = 4150;
    public static final SOPClassUID PullPrintRequestUID = SOPClass.create(4150, "1.2.840.10008.5.1.1.31", "Pull Print Request SOP Class", "PP", false);
    public static final int PositronEmissionTomographyImageStorage = 4151;
    public static final SOPClassUID PositronEmissionTomographyImageStorageUID = SOPClass.create(4151, "1.2.840.10008.5.1.4.1.1.128", "Positron Emission Tomography Image Storage SOP Class", "PET", true);
    public static final int StandalonePETCurveStorage = 4152;
    public static final SOPClassUID StandalonePETCurveStorageUID = SOPClass.create(4152, "1.2.840.10008.5.1.4.1.1.129", "Standalone PET Curve Storage SOP Class", "Standalone PET Curve", true);
    public static final int RTImageStorage = 4153;
    public static final SOPClassUID RTImageStorageUID = SOPClass.create(4153, "1.2.840.10008.5.1.4.1.1.481.1", "RT Image Storage SOP Class", "RT Image", true);
    public static final int RTDoseStorage = 4154;
    public static final SOPClassUID RTDoseStorageUID = SOPClass.create(4154, "1.2.840.10008.5.1.4.1.1.481.2", "RT Dose Storage SOP Class", "RT Dose", true);
    public static final int RTStructureSetStorage = 4155;
    public static final SOPClassUID RTStructureSetStorageUID = SOPClass.create(4155, "1.2.840.10008.5.1.4.1.1.481.3", "RT Structure Set Storage SOP Class", "RT Structure Set", true);
    public static final int RTPlanStorage = 4156;
    public static final SOPClassUID RTPlanStorageUID = SOPClass.create(4156, "1.2.840.10008.5.1.4.1.1.481.5", "RT Plan Storage SOP Class", "RT Plan", true);
    public static final int UltrasoundMultiframeImageStorage_Retired = 4157;
    public static final SOPClassUID UltrasoundMultiframeImageStorage_RetiredUID = SOPClass.create(4157, "1.2.840.10008.5.1.4.1.1.3", "Ultrasound Multi-frame Image Storage Retired SOP Class", "Ultrasound Multi-frame Retired", true);
    public static final int NuclearMedicineImageStorage_Retired = 4158;
    public static final SOPClassUID NuclearMedicineImageStorage_RetiredUID = SOPClass.create(4158, "1.2.840.10008.5.1.4.1.1.5", "Nuclear Medicine Image Storage Retired SOP Class", "Nuclear Medicine Retired", true);
    public static final int UltrasoundImageStorage_Retired = 4159;
    public static final SOPClassUID UltrasoundImageStorage_RetiredUID = SOPClass.create(4159, "1.2.840.10008.5.1.4.1.1.6", "Ultrasound Image Storage Retired SOP Class", "Ultrasound Retired", true);
    public static final int BasicPrintImageOverlayBox = 4160;
    public static final SOPClassUID BasicPrintImageOverlayBoxUID = SOPClass.create(4160, "1.2.840.10008.5.1.1.24.1", "Basic Print Image Overlay Box SOP Class", "OB", false);
    public static final int VLEndoscopicImageStorage = 4161;
    public static final SOPClassUID VLEndoscopicImageStorageUID = SOPClass.create(4161, "1.2.840.10008.5.1.4.1.1.77.1.1", "Visible Light Endoscopic Image Storage SOP Class", "Visible Light Endoscopic", true);
    public static final int VLMicroscopicImageStorage = 4162;
    public static final SOPClassUID VLMicroscopicImageStorageUID = SOPClass.create(4162, "1.2.840.10008.5.1.4.1.1.77.1.2", "Visible Light Microscopic Image Storage SOP Class", "Visible Light Microscopic", true);
    public static final int VLSlideCoordinatesMicroscopicImageStorage = 4163;
    public static final SOPClassUID VLSlideCoordinatesMicroscopicImageStorageUID = SOPClass.create(4163, "1.2.840.10008.5.1.4.1.1.77.1.3", "Visible Light Slide Coordinates Microscopic Image Storage SOP Class", "Visible Light Slide Coordinates Microscopic", true);
    public static final int VLPhotographicImageStorage = 4164;
    public static final SOPClassUID VLPhotographicImageStorageUID = SOPClass.create(4164, "1.2.840.10008.5.1.4.1.1.77.1.4", "Visible Light Photographic Image Storage SOP Class", "Visible Light Photographic", true);
    public static final int GrayscaleSoftcopyPresentationState = 4165;
    public static final SOPClassUID GrayscaleSoftcopyPresentationStateUID = SOPClass.create(4165, "1.2.840.10008.5.1.4.1.1.11.1", "Grayscale Softcopy Presentation State SOP Class", "Grayscale Softcopy PS", true);
    public static final int BasicTextSR = 4166;
    public static final SOPClassUID BasicTextSRUID = SOPClass.create(4166, "1.2.840.10008.5.1.4.1.1.88.11", "Basic Text SR SOP Class", "Basic Text SR", true);
    public static final int EnhancedSR = 4167;
    public static final SOPClassUID EnhancedSRUID = SOPClass.create(4167, "1.2.840.10008.5.1.4.1.1.88.22", "Enhanced SR SOP Class", "Enhanced SR", true);
    public static final int ComprehensiveSR = 4168;
    public static final SOPClassUID ComprehensiveSRUID = SOPClass.create(4168, "1.2.840.10008.5.1.4.1.1.88.33", "Comprehensive SR SOP Class", "Comprehensive SR", true);
    public static final int TwelveLeadECGWaveformStorage = 4169;
    public static final SOPClassUID TwelveLeadECGWaveformStorageUID = SOPClass.create(4169, "1.2.840.10008.5.1.4.1.1.9.1.1", "12-lead ECG Waveform Storage SOP Class", "12-lead ECG Waveform", true);
    public static final int GeneralECGWaveformStorage = 4170;
    public static final SOPClassUID GeneralECGWaveformStorageUID = SOPClass.create(4170, "1.2.840.10008.5.1.4.1.1.9.1.2", "General ECG Waveform Storage SOP Class", "General ECG Waveform", true);
    public static final int AmbulatoryECGWaveformStorage = 4171;
    public static final SOPClassUID AmbulatoryECGWaveformStorageUID = SOPClass.create(4171, "1.2.840.10008.5.1.4.1.1.9.1.3", "Ambulatory ECG Waveform Storage SOP Class", "Ambulatory ECG Waveform", true);
    public static final int HemodynamicWaveformStorage = 4172;
    public static final SOPClassUID HemodynamicWaveformStorageUID = SOPClass.create(4172, "1.2.840.10008.5.1.4.1.1.9.2.1", "Hemodynamic Waveform Storage SOP Class", "Hemodynamic Waveform", true);
    public static final int CardiacElectrophysiologyWaveformStorage = 4173;
    public static final SOPClassUID CardiacElectrophysiologyWaveformStorageUID = SOPClass.create(4173, "1.2.840.10008.5.1.4.1.1.9.3.1", "Cardiac Electrophysiology Waveform Storage SOP Class", "Cardiac Electrophysiology Waveform", true);
    public static final int BasicVoiceAudioWaveformStorage = 4174;
    public static final SOPClassUID BasicVoiceAudioWaveformStorageUID = SOPClass.create(4174, "1.2.840.10008.5.1.4.1.1.9.4.1", "Basic Voice Audio Waveform Storage SOP Class", "Basic Voice Audio Waveform", true);
    public static final int PrinterConfigurationRetrieval = 4175;
    public static final SOPClassUID PrinterConfigurationRetrievalUID = SOPClass.create(4175, "1.2.840.10008.5.1.1.16.376", "Printer Configuration Retrieval SOP Class", "CP", false);
    public static final int DigitalMammographyXRayImageStoragePresentation = 4176;
    public static final SOPClassUID DigitalMammographyXRayImageStoragePresentationUID = SOPClass.create(4176, "1.2.840.10008.5.1.4.1.1.1.2", "Digital Mammography X-Ray Image Storage - For Presentation", "Digital Mammography X-Ray Presentation", true);
    public static final int DigitalMammographyXRayImageStorageProcessing = 4177;
    public static final SOPClassUID DigitalMammographyXRayImageStorageProcessingUID = SOPClass.create(4177, "1.2.840.10008.5.1.4.1.1.1.2.1", "Digital Mammography X-Ray Image Storage - For Processing", "Digital Mammography X-Ray Processing", true);
    public static final int DigitalXRayImageStoragePresentation = 4178;
    public static final SOPClassUID DigitalXRayImageStoragePresentationUID = SOPClass.create(4178, "1.2.840.10008.5.1.4.1.1.1.1", "Digital X-Ray Image Storage - For Presentation", "Digital X-Ray Presentation", true);
    public static final int DigitalXRayImageStorageProcessing = 4179;
    public static final SOPClassUID DigitalXRayImageStorageProcessingUID = SOPClass.create(4179, "1.2.840.10008.5.1.4.1.1.1.1.1", "Digital X-Ray Image Storage - For Processing", "Digital X-Ray Processing", true);
    public static final int DigitalIntraoralXRayImageStoragePresentation = 4180;
    public static final SOPClassUID DigitalIntraoralXRayImageStoragePresentationUID = SOPClass.create(4180, "1.2.840.10008.5.1.4.1.1.1.3", "Digital Intra-oral X-Ray Image Storage - For Presentation", "Digital Intra-oral X-Ray Presentation", true);
    public static final int DigitalIntraoralXRayImageStorageProcessing = 4181;
    public static final SOPClassUID DigitalIntraoralXRayImageStorageProcessingUID = SOPClass.create(4181, "1.2.840.10008.5.1.4.1.1.1.3.1", "Digital Intra-oral X-Ray Image Storage - For Processing", "Digital Intra-oral X-Ray Processing", true);
    public static final int MultiframeSingleBitSecondaryCaptureImageStorage = 4182;
    public static final SOPClassUID MultiframeSingleBitSecondaryCaptureImageStorageUID = SOPClass.create(4182, "1.2.840.10008.5.1.4.1.1.7.1", "Multi-frame Single Bit Secondary Capture Image Storage", "Multi-frame Single Bit Secondary Capture", true);
    public static final int MultiframeGrayscaleByteSecondaryCaptureImageStorage = 4183;
    public static final SOPClassUID MultiframeGrayscaleByteSecondaryCaptureImageStorageUID = SOPClass.create(4183, "1.2.840.10008.5.1.4.1.1.7.2", "Multi-frame Grayscale Byte Secondary Capture Image Storage", "Multi-frame Grayscale Byte Secondary Capture", true);
    public static final int MultiframeGrayscaleWordSecondaryCaptureImageStorage = 4184;
    public static final SOPClassUID MultiframeGrayscaleWordSecondaryCaptureImageStorageUID = SOPClass.create(4184, "1.2.840.10008.5.1.4.1.1.7.3", "Multi-frame Grayscale Word Secondary Capture Image Storage", "Multi-frame Grayscale Word Secondary Capture", true);
    public static final int MultiframeTrueColorSecondaryCaptureImageStorage = 4185;
    public static final SOPClassUID MultiframeTrueColorSecondaryCaptureImageStorageUID = SOPClass.create(4185, "1.2.840.10008.5.1.4.1.1.7.4", "Multi-frame True Color Secondary Capture Image Storage", "Multi-frame True Color Secondary Capture", true);
    public static final int MammographyCADSR = 4186;
    public static final SOPClassUID MammographyCADSRUID = SOPClass.create(4186, "1.2.840.10008.5.1.4.1.1.88.50", "Mammography CAD SR", "Mammography CAD SR", true);
    public static final int KeyObjectSelectionDocument = 4187;
    public static final SOPClassUID KeyObjectSelectionDocumentUID = SOPClass.create(4187, "1.2.840.10008.5.1.4.1.1.88.59", "Key Object Selection Document", "Key Object Selection Document", true);
    public static final int RTBeamsTreatmentRecordStorage = 4188;
    public static final SOPClassUID RTBeamsTreatmentRecordStorageUID = SOPClass.create(4188, "1.2.840.10008.5.1.4.1.1.481.4", "RT Beams Treatment Record Storage", "RT Beams Treatment Record", true);
    public static final int RTBrachyTreatmentRecordStorage = 4189;
    public static final SOPClassUID RTBrachyTreatmentRecordStorageUID = SOPClass.create(4189, "1.2.840.10008.5.1.4.1.1.481.6", "RT Brachy Treatment Record Storage", "RT Brachy Treatment Record", true);
    public static final int RTTreatmentSummaryRecordStorage = 4190;
    public static final SOPClassUID RTTreatmentSummaryRecordStorageUID = SOPClass.create(4190, "1.2.840.10008.5.1.4.1.1.481.7", "RT Treatment Summary Record Storage", "RT Treatment Summary Record", true);
    public static final int GeneralPurposeWorklistInformationModelFIND = 4191;
    public static final SOPClassUID GeneralPurposeWorklistInformationModelFINDUID = SOPClass.create(4191, "1.2.840.10008.5.1.4.32.1", "General Purpose Worklist Information Model - FIND", "GF", false);
    public static final int GeneralPurposeScheduledProcedureStepSOPClass = 4192;
    public static final SOPClassUID GeneralPurposeScheduledProcedureStepSOPClassUID = SOPClass.create(4192, "1.2.840.10008.5.1.4.32.2", "General Purpose Scheduled Procedure Step SOP Class", "SP", false);
    public static final int GeneralPurposePerformedProcedureStepSOPClass = 4193;
    public static final SOPClassUID GeneralPurposePerformedProcedureStepSOPClassUID = SOPClass.create(4193, "1.2.840.10008.5.1.4.32.3", "General Purpose Performed Procedure Step SOP Class", "PP", false);
    public static final int EnhancedMRImageStorage = 4194;
    public static final SOPClassUID EnhancedMRImageStorageUID = SOPClass.create(4194, "1.2.840.10008.5.1.4.1.1.4.1", "Enhanced MR Image Storage", "Enhanced MR", true);
    public static final int MRSpectroscopyStorage = 4195;
    public static final SOPClassUID MRSpectroscopyStorageUID = SOPClass.create(4195, "1.2.840.10008.5.1.4.1.1.4.2", "MR Spectroscopy Storage", "MR Spectroscopy", true);
    public static final int RawDataStorage = 4196;
    public static final SOPClassUID RawDataStorageUID = SOPClass.create(4196, "1.2.840.10008.5.1.4.1.1.66", "Raw Data Storage", "Raw Data Storage", true);
    public static final int ChestCADSR = 4197;
    public static final SOPClassUID ChestCADSRUID = SOPClass.create(4197, "1.2.840.10008.5.1.4.1.1.88.65", "Chest CAD SR", "Chest CAD SR", true);
    public static final int ProceduralEventLoggingSOPClass = 4198;
    public static final SOPClassUID ProceduralEventLoggingSOPClassUID = SOPClass.create(4198, "1.2.840.10008.1.40", "Procedural Event Logging SOP", "PE", false);
    public static final int MediaCreationManagementSOPClassUID = 4199;
    public static final SOPClassUID MediaCreationManagementSOPClassUIDUID = SOPClass.create(4199, "1.2.840.10008.5.1.1.33", "Media Creation Management SOP Class UID", "MC", false);
    public static final int EnhancedCTImageStorage = 4200;
    public static final SOPClassUID EnhancedCTImageStorageUID = SOPClass.create(4200, "1.2.840.10008.5.1.4.1.1.2.1", "Enhanced CT Image Storage", "Enhanced CT", true);
    public static final int SpatialRegistrationStorage = 4201;
    public static final SOPClassUID SpatialRegistrationStorageUID = SOPClass.create(4201, "1.2.840.10008.5.1.4.1.1.66.1", "Spatial Registration Storage", "Spatial Registration Storage", true);
    public static final int SpatialFiducialsStorage = 4202;
    public static final SOPClassUID SpatialFiducialsStorageUID = SOPClass.create(4202, "1.2.840.10008.5.1.4.1.1.66.2", "Spatial Fiducials Storage", "Spatial Fiducials Storage", true);
    public static final int VideoEndoscopicImageStorage = 4203;
    public static final SOPClassUID VideoEndoscopicImageStorageUID = SOPClass.create(4203, "1.2.840.10008.5.1.4.1.1.77.1.1.1", "Video Endoscopic Image Storage", "Video Endoscopic", true);
    public static final int VideoMicroscopicImageStorage = 4204;
    public static final SOPClassUID VideoMicroscopicImageStorageUID = SOPClass.create(4204, "1.2.840.10008.5.1.4.1.1.77.1.2.1", "Video Microscopic Image Storage", "Video Microscopic", true);
    public static final int VideoPhotographicImageStorage = 4205;
    public static final SOPClassUID VideoPhotographicImageStorageUID = SOPClass.create(4205, "1.2.840.10008.5.1.4.1.1.77.1.4.1", "Video Photographic Image Storage", "Video Photographic", true);
    public static final int OphthalmicPhotography8BitImageStorage = 4206;
    public static final SOPClassUID OphthalmicPhotography8BitImageStorageUID = SOPClass.create(4206, "1.2.840.10008.5.1.4.1.1.77.1.5.1", "Ophthalmic Photography 8 Bit Image Storage", "Ophthalmic Photography 8 Bit", true);
    public static final int OphthalmicPhotography16BitImageStorage = 4207;
    public static final SOPClassUID OphthalmicPhotography16BitImageStorageUID = SOPClass.create(4207, "1.2.840.10008.5.1.4.1.1.77.1.5.2", "Ophthalmic Photography 16 Bit Image Storage", "Ophthalmic Photography 16 Bit", true);
    public static final int StereometricRelationshipStorage = 4208;
    public static final SOPClassUID StereometricRelationshipStorageUID = SOPClass.create(4208, "1.2.840.10008.5.1.4.1.1.77.1.5.3", "Stereometric Relationship Storage", "Stereometric Relationship", true);
    public static final int ProcedureLogStorage = 4209;
    public static final SOPClassUID ProcedureLogStorageUID = SOPClass.create(4209, "1.2.840.10008.5.1.4.1.1.88.40", "Procedure Log Storage", "Procedure Log", true);
    public static final int InstanceAvailabilityNotificationSOPClass = 4210;
    public static final SOPClassUID InstanceAvailabilityNotificationSOPClassUID = SOPClass.create(4210, "1.2.840.10008.5.1.4.33", "Instance Availability Notification SOP Class", "IA", false);
    public static final int GeneralRelevantPatientInformationQuery = 4211;
    public static final SOPClassUID GeneralRelevantPatientInformationQueryUID = SOPClass.create(4211, "1.2.840.10008.5.1.4.37.1", "General Relevant Patient Information Query SOP Class", "GR", false);
    public static final int BreastImagingRelevantPatientInformationQuery = 4212;
    public static final SOPClassUID BreastImagingRelevantPatientInformationQueryUID = SOPClass.create(4212, "1.2.840.10008.5.1.4.37.2", "Breast Imaging Relevant Patient Information Query SOP Class", "BR", false);
    public static final int CardiacRelevantPatientInformationQuery = 4213;
    public static final SOPClassUID CardiacRelevantPatientInformationQueryUID = SOPClass.create(4213, "1.2.840.10008.5.1.4.37.3", "Cardiac Relevant Patient Information Query SOP Class", "CP", false);
    public static final int VisibleLightImageStorage_Retired = 4214;
    public static final SOPClassUID VisibleLightImageStorage_RetiredUID = SOPClass.create(4214, "1.2.840.10008.5.1.4.1.1.77.1", "Visible Light Image Storage (Retired)", "Visible Light Retired", true);
    public static final int VisibleLightMultiFrameImageStorage_Retired = 4215;
    public static final SOPClassUID VisibleLightMultiFrameImageStorage_RetiredUID = SOPClass.create(4215, "1.2.840.10008.5.1.4.1.1.77.2", "Visible Light Multi-Frame Image Storage (Retired)", "Visible Light Multi-Frame Retired", true);
    public static final int ColorSoftcopyPresentationStateStorage = 4216;
    public static final SOPClassUID ColorSoftcopyPresentationStateStorageUID = SOPClass.create(4216, "1.2.840.10008.5.1.4.1.1.11.2", "Color Softcopy Presentation State Storage", "Color Softcopy PS", true);
    public static final int PseudoColorSoftcopyPresentationStateStorage = 4217;
    public static final SOPClassUID PseudoColorSoftcopyPresentationStateStorageUID = SOPClass.create(4217, "1.2.840.10008.5.1.4.1.1.11.3", "Pseudo-Color Softcopy Presentation State Storage", "Pseudo-Color Softcopy PS", true);
    public static final int BlendingColorSoftcopyPresentationStateStorage = 4218;
    public static final SOPClassUID BlendingColorSoftcopyPresentationStateStorageUID = SOPClass.create(4218, "1.2.840.10008.5.1.4.1.1.11.4", "Blending Softcopy Presentation State Storage", "Blending Softcopy PS", true);
    public static final int EnhancedXAImageStorage = 4219;
    public static final SOPClassUID EnhancedXAImageStorageUID = SOPClass.create(4219, "1.2.840.10008.5.1.4.1.1.12.1.1", "Enhanced XA Image Storage", "Enhanced XA", true);
    public static final int EnhancedXRFImageStorage = 4220;
    public static final SOPClassUID EnhancedXRFImageStorageUID = SOPClass.create(4220, "1.2.840.10008.5.1.4.1.1.12.2.1", "Enhanced XRF Image Storage", "Enhanced XRF", true);
    public static final int RealWorldValueMappingStorage = 4221;
    public static final SOPClassUID RealWorldValueMappingStorageUID = SOPClass.create(4221, "1.2.840.10008.5.1.4.1.1.67", "Real World Value Mapping Storage", "Real World Value Mapping", true);
    public static final int XRayRadiationDoseSR = 4222;
    public static final SOPClassUID XRayRadiationDoseSRUID = SOPClass.create(4222, "1.2.840.10008.5.1.4.1.1.88.67", "X-Ray Radiation Dose SR", "X-Ray Radiation Dose SR", true);
    public static final int EncapsulatedPDFStorage = 4223;
    public static final SOPClassUID EncapsulatedPDFStorageUID = SOPClass.create(4223, "1.2.840.10008.5.1.4.1.1.104.1", "Encapsulated PDF Storage", "Encapsulated PDF", true);
    public static final int RTIonPlanStorage = 4224;
    public static final SOPClassUID RTIonPlanStorageUID = SOPClass.create(4224, "1.2.840.10008.5.1.4.1.1.481.8", "RT Ion Plan Storage", "RT Ion Plan", true);
    public static final int RTIonBeamsTreatmentRecordStorage = 4225;
    public static final SOPClassUID RTIonBeamsTreatmentRecordStorageUID = SOPClass.create(4225, "1.2.840.10008.5.1.4.1.1.481.9", "RT Ion Beams Treatment Record Storage", "RT Ion Beams Treatment", true);
    public static final int HangingProtocolStorage = 4226;
    public static final SOPClassUID HangingProtocolStorageUID = SOPClass.create(4226, "1.2.840.10008.5.1.4.38.1", "Hanging Protocol Storage", "Hanging Protocol", true);
    public static final int HangingProtocolInformationModelFIND = 4227;
    public static final SOPClassUID HangingProtocolInformationModelFINDUID = SOPClass.create(4227, "1.2.840.10008.5.1.4.38.2", "Hanging Protocol Information Model - FIND", "XX", false);
    public static final int HangingProtocolInformationModelMOVE = 4228;
    public static final SOPClassUID HangingProtocolInformationModelMOVEUID = SOPClass.create(4228, "1.2.840.10008.5.1.4.38.3", "Hanging Protocol Information Model - MOVE", "XX", false);
    public static final int DeformableSpatialRegistrationStorage = 4229;
    public static final SOPClassUID DeformableSpatialRegistrationStorageUID = SOPClass.create(4229, "1.2.840.10008.5.1.4.1.1.66.3", "Deformable Spatial Registration Storage", "Deformable Spatial Registration", true);
    public static final int SegmentationStorage = 4230;
    public static final SOPClassUID SegmentationStorageUID = SOPClass.create(4230, "1.2.840.10008.5.1.4.1.1.66.4", "Segmentation Storage", "Segmentation", true);

    private static SOPClassUID create(int constant, String value, String name, String shortname, boolean storageSOPClass) {
        SOPClassUID sopClassUID = new SOPClassUID(constant, value, name, shortname, storageSOPClass);
        entries.put(new Integer(constant), sopClassUID);
        return sopClassUID;
    }

    public static synchronized int addEntry(UIDEntry entry) throws DicomException {
        return SOPClass.addEntry(entry, false);
    }

    public static synchronized int addEntry(UIDEntry entry, boolean storageSOPClass) throws DicomException {
        if (entry.getType() != 1) {
            throw new DicomException("UIDEntry added should be of type SOPClass");
        }
        int max = Integer.MIN_VALUE;
        Enumeration enum_ = entries.keys();
        while (enum_.hasMoreElements()) {
            int i = (Integer)enum_.nextElement();
            if (i <= max) continue;
            max = i;
        }
        SOPClassUID newSOPClassUID = SOPClass.create(max + 1, entry.getValue(), entry.getName(), entry.getShortName(), storageSOPClass);
        entries.put(new Integer(max + 1), newSOPClassUID);
        return max + 1;
    }

    public static boolean isStorageSOPClass(int sopclass) throws DicomException, IllegalValueException {
        UIDEntry entry = SOPClass.getUIDEntry(sopclass);
        return entry.isStorageSOPClass();
    }

    public static List listStorageSOPClasses() {
        Iterator iterator = entries.values().iterator();
        ArrayList<UIDEntry> l = new ArrayList<UIDEntry>();
        while (iterator.hasNext()) {
            UIDEntry entry = (UIDEntry)iterator.next();
            if (entry.getType() != 1 || !entry.isStorageSOPClass()) continue;
            l.add(entry);
        }
        return l;
    }
}

