/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.OffsetOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class PrimitiveOutputStream
extends OffsetOutputStream {
    int ts = 8193;
    int temp = 0;
    byte[] temp16 = new byte[2];
    byte[] temp32 = new byte[4];
    byte[] temp64 = new byte[8];

    PrimitiveOutputStream(OutputStream out) {
        super(out);
    }

    PrimitiveOutputStream(OutputStream out, long beginoff) {
        super(out, beginoff);
    }

    void setTransferSyntax(int transyn) {
        this.ts = transyn;
    }

    int getTransferSyntax() {
        return this.ts;
    }

    int writeInt16(int val) throws IOException {
        if (this.ts == 8195) {
            this.temp16[1] = (byte)val;
            this.temp16[0] = (byte)(val >>> 8);
        } else {
            this.temp16[0] = (byte)val;
            this.temp16[1] = (byte)(val >>> 8);
        }
        this.write(this.temp16);
        return 2;
    }

    int writeInt32(int val) throws IOException {
        if (this.ts == 8195) {
            this.temp32[3] = (byte)val;
            this.temp32[2] = (byte)(val >>> 8);
            this.temp32[1] = (byte)(val >>> 16);
            this.temp32[0] = (byte)(val >>> 24);
        } else {
            this.temp32[0] = (byte)val;
            this.temp32[1] = (byte)(val >>> 8);
            this.temp32[2] = (byte)(val >>> 16);
            this.temp32[3] = (byte)(val >>> 24);
        }
        this.write(this.temp32);
        return 4;
    }

    int writeInt64(long val) throws IOException {
        if (this.ts == 8195) {
            this.temp64[7] = (byte)val;
            this.temp64[6] = (byte)(val >>> 8);
            this.temp64[5] = (byte)(val >>> 16);
            this.temp64[4] = (byte)(val >>> 24);
            this.temp64[3] = (byte)(val >>> 32);
            this.temp64[2] = (byte)(val >>> 40);
            this.temp64[1] = (byte)(val >>> 48);
            this.temp64[0] = (byte)(val >>> 56);
        } else {
            this.temp64[0] = (byte)val;
            this.temp64[1] = (byte)(val >>> 8);
            this.temp64[2] = (byte)(val >>> 16);
            this.temp64[3] = (byte)(val >>> 24);
            this.temp64[4] = (byte)(val >>> 32);
            this.temp64[5] = (byte)(val >>> 40);
            this.temp64[6] = (byte)(val >>> 48);
            this.temp64[7] = (byte)(val >>> 56);
        }
        this.write(this.temp64);
        return 8;
    }

    int writeString(String s) throws IOException {
        this.write(s.getBytes());
        return s.length();
    }
}

