/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.OffsetInputStream;
import java.io.IOException;
import java.io.InputStream;

class PrimitiveInputStream
extends OffsetInputStream {
    int ts = 8193;
    int temp = 0;
    long templ = 0L;
    byte[] temp16 = new byte[2];
    byte[] temp32 = new byte[4];
    byte[] temp64 = new byte[8];

    PrimitiveInputStream(InputStream in) {
        super(in);
    }

    PrimitiveInputStream(InputStream in, int beginoff) {
        super(in, beginoff);
    }

    private int unsign(byte b) {
        return b & 0xFF;
    }

    long unsignToLong(int i) {
        return 0xFFFFFFFFL & (long)i;
    }

    void setTransferSyntax(int transyn) {
        this.ts = transyn;
    }

    int getTransferSyntax() {
        return this.ts;
    }

    int readUInt16() throws IOException {
        this.readFully(this.temp16);
        if (this.ts == 8195) {
            return (this.unsign(this.temp16[0]) << 8) + this.unsign(this.temp16[1]);
        }
        return (this.unsign(this.temp16[1]) << 8) + this.unsign(this.temp16[0]);
    }

    void unreadUInt16(int val) throws IOException {
        if (this.ts == 8195) {
            this.temp16[1] = (byte)val;
            this.temp16[0] = (byte)(val >>> 8);
        } else {
            this.temp16[0] = (byte)val;
            this.temp16[1] = (byte)(val >>> 8);
        }
        this.unread(this.temp16);
    }

    int readSInt16() throws IOException {
        this.readFully(this.temp16);
        if (this.ts == 8195) {
            return (this.temp16[0] << 8) + this.unsign(this.temp16[1]);
        }
        return (this.temp16[1] << 8) + this.unsign(this.temp16[0]);
    }

    int readUInt32() throws IOException {
        this.readFully(this.temp32);
        if (this.ts == 8195) {
            this.temp = this.unsign(this.temp32[3]);
            this.temp += this.unsign(this.temp32[2]) << 8;
            this.temp += this.unsign(this.temp32[1]) << 16;
            this.temp += this.unsign(this.temp32[0]) << 24;
        } else {
            this.temp = this.unsign(this.temp32[0]);
            this.temp += this.unsign(this.temp32[1]) << 8;
            this.temp += this.unsign(this.temp32[2]) << 16;
            this.temp += this.unsign(this.temp32[3]) << 24;
        }
        return this.temp;
    }

    int readSInt32() throws IOException {
        this.readFully(this.temp32);
        if (this.ts == 8195) {
            this.temp = this.unsign(this.temp32[3]);
            this.temp += this.unsign(this.temp32[2]) << 8;
            this.temp += this.unsign(this.temp32[1]) << 16;
            this.temp += this.temp32[0] << 24;
        } else {
            this.temp = this.unsign(this.temp32[0]);
            this.temp += this.unsign(this.temp32[1]) << 8;
            this.temp += this.unsign(this.temp32[2]) << 16;
            this.temp += this.temp32[3] << 24;
        }
        return this.temp;
    }

    long readSInt64() throws IOException {
        this.readFully(this.temp64);
        this.templ = this.ts == 8195 ? (long)this.unsign(this.temp64[7]) + ((long)this.unsign(this.temp64[6]) << 8) + ((long)this.unsign(this.temp64[5]) << 16) + ((long)this.unsign(this.temp64[4]) << 24) + ((long)this.unsign(this.temp64[3]) << 32) + ((long)this.unsign(this.temp64[2]) << 40) + ((long)this.unsign(this.temp64[1]) << 48) + ((long)this.unsign(this.temp64[0]) << 56) : (long)this.unsign(this.temp64[0]) + ((long)this.unsign(this.temp64[1]) << 8) + ((long)this.unsign(this.temp64[2]) << 16) + ((long)this.unsign(this.temp64[3]) << 24) + ((long)this.unsign(this.temp64[4]) << 32) + ((long)this.unsign(this.temp64[5]) << 40) + ((long)this.unsign(this.temp64[6]) << 48) + ((long)this.unsign(this.temp64[7]) << 56);
        return this.templ;
    }

    long readUInt64() throws IOException {
        long l;
        this.readFully(this.temp64);
        if (this.ts == 8195) {
            l = this.unsign(this.temp64[7]);
            l += (long)(this.unsign(this.temp64[6]) << 8);
            l += (long)(this.unsign(this.temp64[5]) << 16);
            l += (long)(this.unsign(this.temp64[4]) << 24);
            l += (long)(this.unsign(this.temp64[3]) << 32);
            l += (long)(this.unsign(this.temp64[2]) << 40);
            l += (long)(this.unsign(this.temp64[1]) << 48);
            l += (long)(this.unsign(this.temp64[0]) << 56);
        } else {
            l = this.unsign(this.temp64[0]);
            l += (long)(this.unsign(this.temp64[1]) << 8);
            l += (long)(this.unsign(this.temp64[2]) << 16);
            l += (long)(this.unsign(this.temp64[3]) << 24);
            l += (long)(this.unsign(this.temp64[4]) << 32);
            l += (long)(this.unsign(this.temp64[5]) << 40);
            l += (long)(this.unsign(this.temp64[6]) << 48);
            l += (long)(this.unsign(this.temp64[7]) << 56);
        }
        return l;
    }

    String readString(int len) throws IOException {
        byte[] s = new byte[len];
        this.readFully(s);
        return new String(s);
    }

    long readUInt32AsLong() throws IOException {
        return this.unsignToLong(this.readUInt32());
    }
}

