/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class OffsetOutputStream
extends FilterOutputStream {
    private long offset = 0L;

    public OffsetOutputStream(OutputStream out) {
        this(out, 0L);
    }

    public OffsetOutputStream(OutputStream out, long beginoff) {
        super(out);
        this.offset = beginoff;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.offset += (long)len;
        this.out.write(b, off, len);
    }

    public void write(int b) throws IOException {
        ++this.offset;
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(ByteArray byteArray) throws IOException {
        for (int i = 0; i < byteArray.arrays(); ++i) {
            this.write(byteArray.getArray(i));
        }
    }

    long getOffset() {
        return this.offset;
    }
}

