/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DicomUtils;
import com.archimed.dicom.SingleVROutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

class MultiVROutputStream
extends SingleVROutputStream {
    Vector v;
    private static final int DELIMITER = 92;

    MultiVROutputStream(OutputStream out) {
        super(out);
    }

    MultiVROutputStream(OutputStream out, long beginoff) {
        super(out, beginoff);
    }

    private int padChar(int dcm_type) {
        switch (dcm_type) {
            case 2: 
            case 8: 
            case 22: 
            case 24: {
                return 0;
            }
        }
        return 32;
    }

    private int writeFixed(Vector val, int dcm_type) throws IOException {
        int len = 0;
        for (int i = 0; i < val.size(); ++i) {
            len += this.writeFixed(val.elementAt(i), dcm_type);
        }
        return len;
    }

    private int writeSingleByteArray(Vector val, int dcm_type) throws IOException {
        byte[] ar = (byte[])val.firstElement();
        this.write(ar);
        return ar.length;
    }

    private int writeMultiByteArray(Vector val, int dcm_type) throws IOException {
        int len = 0;
        for (int i = 0; i < val.size(); ++i) {
            if (i > 0) {
                this.write(92);
                ++len;
            }
            byte[] ar = (byte[])val.elementAt(i);
            this.write(ar);
            len += ar.length;
        }
        return len;
    }

    private long writeSingleValue(Vector val, int dcm_type) throws IOException {
        ByteArray byteArray = (ByteArray)val.elementAt(0);
        if (dcm_type == 24 && this.getTransferSyntax() == 8195) {
            ByteArray temp = byteArray.copy();
            DicomUtils.swapBytes(temp);
            this.write(temp);
            return temp.length();
        }
        this.write(byteArray);
        return byteArray.length();
    }

    int writeSingleOFValue(Vector val) throws IOException {
        float[] temp = (float[])val.elementAt(0);
        for (int i = 0; i < temp.length; ++i) {
            this.writeInt32(Float.floatToIntBits(temp[i]));
        }
        return temp.length * 4;
    }

    int writeVRValues(Vector val, int dcm_type) throws IOException {
        int len = 0;
        switch (dcm_type) {
            case 1: 
            case 3: 
            case 5: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                return this.writeFixed(val, dcm_type);
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: {
                len = (int)((long)len + this.writeSingleValue(val, dcm_type));
                break;
            }
            case 29: {
                len += this.writeSingleOFValue(val);
                break;
            }
            case 13: 
            case 18: 
            case 27: {
                len += this.writeSingleByteArray(val, dcm_type);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: {
                len += this.writeMultiByteArray(val, dcm_type);
                break;
            }
            default: {
                assert (false);
                throw new Error("unknown DICOM VR type constant: " + dcm_type);
            }
        }
        if (len % 2 == 1) {
            this.write(this.padChar(dcm_type));
            ++len;
        }
        return len;
    }
}

