/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DicomUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.SingleVRInputStream;
import com.archimed.log.JdtLogger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class MultiVRInputStream
extends SingleVRInputStream {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(MultiVRInputStream.class);
    private static final byte DELIMITER = 92;

    MultiVRInputStream(InputStream in) {
        super(in);
    }

    MultiVRInputStream(InputStream in, int beginoff) {
        super(in, beginoff);
    }

    private Vector readFixed(int dcm_type, long num) throws IOException {
        Vector<Object> v = new Vector<Object>();
        this.resetCounter();
        for (long i = 0L; i < num; ++i) {
            v.addElement(this.readFixed(dcm_type));
        }
        return v;
    }

    private Vector readSingleByteArray(long len) throws IOException {
        Vector<byte[]> v = new Vector<byte[]>();
        byte[] buf = new byte[(int)len];
        this.readFully(buf);
        v.addElement(buf);
        return v;
    }

    private Vector readMultiByteArray(long len) throws IOException {
        byte[] buf2;
        Vector<byte[]> v = new Vector<byte[]>();
        byte[] buf = new byte[(int)len];
        this.readFully(buf);
        int offset = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 92) continue;
            buf2 = new byte[i - offset];
            System.arraycopy(buf, offset, buf2, 0, buf2.length);
            v.addElement(buf2);
            offset = i + 1;
        }
        if (offset == 0) {
            v.addElement(buf);
        } else {
            buf2 = new byte[buf.length - offset];
            System.arraycopy(buf, offset, buf2, 0, buf2.length);
            v.addElement(buf2);
        }
        return v;
    }

    private Vector readSingleValue(int dcm_type, long len) throws IOException {
        ByteArray byteArray = new ByteArray(len);
        try {
            this.readFully(byteArray);
        }
        catch (EOFException ex) {
            if (Jdt.isReadIncompleteTag()) {
                this.log.warn("encountered EOFException while reading OB,OW or UN. Proceeding with partially read data");
            }
            throw ex;
        }
        if (dcm_type == 24 && this.getTransferSyntax() == 8195) {
            DicomUtils.swapBytes(byteArray);
        }
        Vector<ByteArray> v = new Vector<ByteArray>();
        v.addElement(byteArray);
        return v;
    }

    private Vector readSingleOFValue(long len) throws IOException {
        int l = (int)(len / 4L);
        float[] floatArray = new float[l];
        for (int i = 0; i < l; ++i) {
            floatArray[i] = Float.intBitsToFloat(this.readUInt32());
        }
        int remainder = (int)(len % 4L);
        if (remainder > 0) {
            this.readFully(new byte[remainder]);
        }
        Vector<float[]> v = new Vector<float[]>();
        v.addElement(floatArray);
        return v;
    }

    Vector readVRValues(int dcm_type, long len) throws IOException {
        switch (dcm_type) {
            case 3: 
            case 21: 
            case 23: {
                return this.readFixed(dcm_type, len / 2L);
            }
            case 1: 
            case 5: 
            case 19: 
            case 26: {
                return this.readFixed(dcm_type, len / 4L);
            }
            case 20: {
                return this.readFixed(dcm_type, len / 8L);
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: {
                return this.readSingleValue(dcm_type, len);
            }
            case 29: {
                return this.readSingleOFValue(len);
            }
            case 13: 
            case 18: 
            case 27: {
                return this.readSingleByteArray(len);
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 28: {
                return this.readMultiByteArray(len);
            }
        }
        assert (false);
        throw new Error("unknown DICOM VR type constant: " + dcm_type);
    }
}

