/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.VR;
import java.util.Enumeration;
import java.util.Vector;

class LengthUtils {
    LengthUtils() {
    }

    private static long addOneIfOdd(long n) {
        if ((n & 1L) == 1L) {
            return n + 1L;
        }
        return n;
    }

    private static int delimLength(Vector val) {
        if (val.size() > 0) {
            return val.size() - 1;
        }
        return 0;
    }

    private static int byteLength(Vector val) {
        int len = 0;
        for (int i = 0; i < val.size(); ++i) {
            len += ((byte[])val.elementAt(i)).length;
        }
        return len;
    }

    private static long byteArrayLength(Vector val) {
        long len = 0L;
        for (int i = 0; i < val.size(); ++i) {
            len += ((ByteArray)val.elementAt(i)).length();
        }
        return len;
    }

    static long sequenceItemLength(DicomObject si, int ts, int seqLengthOpt, int groupLengthOpt) {
        long len = 0L;
        if (seqLengthOpt == 8200) {
            len = 16L;
        } else if (seqLengthOpt == 8201) {
            len = 8L;
        } else if (seqLengthOpt == 8209) {
            len = si.getSeqItemLenState() == 1 || si.getSeqItemLenState() == 3 ? 8L : 16L;
        } else if (seqLengthOpt == 8208) {
            len = si.getSeqItemLenState() == 1 || si.getSeqItemLenState() == 2 ? 16L : 8L;
        }
        Enumeration e = si.enumerateVRs(ts, seqLengthOpt, groupLengthOpt);
        while (e.hasMoreElements()) {
            VR vr2 = (VR)e.nextElement();
            len += (long)LengthUtils.calculateHeaderLength(vr2.dcm_type, ts);
            len += LengthUtils.calculateDataLength(vr2, vr2.dcm_type, ts, seqLengthOpt, groupLengthOpt);
        }
        return len;
    }

    private static long sequenceLength(Vector val, int ts, int seqLengthOpt, int groupLengthOpt) {
        long len = 0L;
        for (int i = 0; i < val.size(); ++i) {
            DicomObject item = (DicomObject)val.elementAt(i);
            item.length = LengthUtils.sequenceItemLength(item, ts, seqLengthOpt, groupLengthOpt);
            len += item.length;
        }
        return len;
    }

    private static int sequenceHeaderLength(int seqLenState, int seqLengthOpt) {
        int DEFINEDLENGTH = 0;
        int UNDEFINEDLENGTH = 8;
        if (seqLengthOpt == 8201) {
            return DEFINEDLENGTH;
        }
        if (seqLengthOpt == 8200) {
            return UNDEFINEDLENGTH;
        }
        if (seqLengthOpt == 8209) {
            if (seqLenState == 1 || seqLenState == 3) {
                return DEFINEDLENGTH;
            }
            if (seqLenState == 2) {
                return UNDEFINEDLENGTH;
            }
            throw new IllegalArgumentException("illegal constant for seqLenState");
        }
        if (seqLengthOpt == 8208) {
            if (seqLenState == 1 || seqLenState == 2) {
                return UNDEFINEDLENGTH;
            }
            if (seqLenState == 3) {
                return DEFINEDLENGTH;
            }
            throw new IllegalArgumentException("illegal constant for seqLenState");
        }
        throw new IllegalArgumentException("illegal constant for seqLenState");
    }

    private static int encapsulatedPixelHeaderLength(Vector val) {
        return 8 + val.size() * 8;
    }

    private static int floatArrayForOFLength(Vector val) {
        int len = 0;
        for (int i = 0; i < val.size(); ++i) {
            len += ((float[])val.elementAt(i)).length * 4;
        }
        return len;
    }

    static long calculateDataLength(VR vr2, int dcm_type, int ts, int seqLengthOpt, int groupLengthOpt) {
        int fix = DDict.getTypeFixed(dcm_type);
        int len = 0;
        if (fix != 0) {
            return fix * vr2.val.size();
        }
        switch (dcm_type) {
            case 10: {
                return LengthUtils.addOneIfOdd(LengthUtils.sequenceLength(vr2.val, ts, seqLengthOpt, groupLengthOpt) + (long)LengthUtils.sequenceHeaderLength(vr2.seqLenState, seqLengthOpt));
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: {
                if (vr2.isEncapsulatedPixelData()) {
                    return LengthUtils.addOneIfOdd(LengthUtils.byteArrayLength(vr2.val) + (long)LengthUtils.encapsulatedPixelHeaderLength(vr2.val));
                }
                return vr2.val.size() > 0 ? LengthUtils.addOneIfOdd(((ByteArray)vr2.val.elementAt(0)).length()) : 0L;
            }
            case 29: {
                len = LengthUtils.floatArrayForOFLength(vr2.val);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                len = LengthUtils.byteLength(vr2.val);
                break;
            }
            default: {
                len = LengthUtils.byteLength(vr2.val);
            }
        }
        return LengthUtils.addOneIfOdd(len += LengthUtils.delimLength(vr2.val));
    }

    static int calculateHeaderLength(int dcm_type, int ts) {
        if (ts == 8193 || ts == 8227) {
            return 8;
        }
        switch (dcm_type) {
            case 0: 
            case 8: 
            case 10: 
            case 22: 
            case 24: 
            case 27: {
                return 12;
            }
        }
        return 8;
    }
}

