/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomUtils;
import com.archimed.dicom.IntHashtable;
import com.archimed.dicom.LengthUtils;
import com.archimed.dicom.VR;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class GroupList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IntHashtable groups = new IntHashtable();

    void push(VR vr2) {
        if (vr2 == null) {
            return;
        }
        IntHashtable ge = (IntHashtable)this.groups.get(vr2.group);
        if (ge == null) {
            ge = new IntHashtable();
            this.groups.put(vr2.group, (Object)ge);
        }
        ge.put(vr2.element, (Object)vr2);
    }

    public void clear() {
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            IntHashtable el = (IntHashtable)e.nextElement();
            el.clear();
        }
        this.groups.clear();
    }

    VR getVR(int g, int e) {
        IntHashtable ge = (IntHashtable)this.groups.get(g);
        if (ge == (IntHashtable)null) {
            return null;
        }
        VR vr2 = (VR)ge.get(e);
        return vr2;
    }

    VR removeVR(int g, int e) {
        IntHashtable ge = (IntHashtable)this.groups.get(g);
        if (ge == null) {
            return null;
        }
        VR vr2 = (VR)ge.remove(e);
        return vr2;
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public Enumeration enumerateVRs(boolean grouplens) {
        return this.enumerateVRs(grouplens, 8193, true);
    }

    Enumeration enumerateVRs(boolean grouplens, int ts, boolean seq_undef) {
        return this.enumerateVRs(ts, seq_undef ? 8200 : 8201, grouplens ? 2 : 1);
    }

    public Enumeration enumerateVRs(int ts, int seqLengthOpt, int groupLengthOpt) {
        Vector evec = new Vector();
        Vector gvec = new Vector();
        Vector<VR> allvec = new Vector<VR>();
        this.updateLengths(ts, seqLengthOpt, groupLengthOpt);
        Enumeration g = this.groups.keys();
        while (g.hasMoreElements()) {
            gvec.addElement(g.nextElement());
        }
        gvec = DicomUtils.bubbleSort(gvec);
        for (int i = 0; i < gvec.size(); ++i) {
            evec = new Vector();
            int gkey = (Integer)gvec.elementAt(i);
            IntHashtable elements = (IntHashtable)this.groups.get(gkey);
            Enumeration e = elements.keys();
            while (e.hasMoreElements()) {
                evec.addElement(e.nextElement());
            }
            evec = DicomUtils.bubbleSort(evec);
            for (int j = 0; j < evec.size(); ++j) {
                VR vr2 = (VR)elements.get(evec.elementAt(j));
                allvec.addElement(vr2);
            }
        }
        return allvec.elements();
    }

    private void updateLengths(int ts, int seqLengthOpt, int groupLengthOpt) {
        VR vr2;
        Enumeration e;
        Enumeration g = this.groups.keys();
        while (g.hasMoreElements()) {
            Integer gnr = (Integer)g.nextElement();
            e = ((IntHashtable)this.groups.get(gnr)).elements();
            int transyn = gnr == 2 ? 8194 : ts;
            while (e.hasMoreElements()) {
                vr2 = (VR)e.nextElement();
                if (vr2.element == 0) continue;
                vr2.dataLen = LengthUtils.calculateDataLength(vr2, vr2.dcm_type, transyn, seqLengthOpt, groupLengthOpt);
                vr2.headerLen = LengthUtils.calculateHeaderLength(vr2.dcm_type, transyn);
            }
        }
        Enumeration groupEnum = this.groups.keys();
        while (groupEnum.hasMoreElements()) {
            int gkey = (Integer)groupEnum.nextElement();
            IntHashtable elements = (IntHashtable)this.groups.get(gkey);
            VR glVR = (VR)elements.get(0);
            if (groupLengthOpt == 1) {
                elements.remove(0);
                continue;
            }
            if (groupLengthOpt != 2 && (groupLengthOpt != 3 || glVR == null)) continue;
            int glen = 0;
            e = elements.elements();
            while (e.hasMoreElements()) {
                vr2 = (VR)e.nextElement();
                if (vr2.element == 0) continue;
                glen = (int)((long)glen + ((long)vr2.headerLen + vr2.dataLen));
            }
            elements.put(0, (Object)new VR((DicomObject)this, gkey, 0, 1, new Long(glen), 4));
        }
    }

    public DicomObject copyGroup(int groupnr) {
        DicomObject dcmObj = new DicomObject();
        IntHashtable ght = (IntHashtable)this.groups.get(groupnr);
        Enumeration e = ght.keys();
        while (e.hasMoreElements()) {
            VR vr2 = (VR)ght.get(e.nextElement());
            dcmObj.push(vr2);
        }
        return dcmObj;
    }

    public DicomObject removeGroup(int groupnr) {
        DicomObject dcmObj = new DicomObject();
        if (this.groups == null) {
            return null;
        }
        IntHashtable ght = (IntHashtable)this.groups.get(groupnr);
        if (ght == null) {
            return null;
        }
        Enumeration e = ght.keys();
        while (e.hasMoreElements()) {
            VR vr2 = (VR)ght.get(e.nextElement());
            dcmObj.push(vr2);
        }
        this.groups.remove(groupnr);
        System.gc();
        return dcmObj;
    }

    public boolean containsGroup(int groupnr) {
        return this.groups.containsKey(groupnr);
    }

    void addGroup(DicomObject o) {
        Enumeration e = o.groups.keys();
        int g = (Integer)e.nextElement();
        if (!this.containsGroup(g)) {
            this.groups.put(g, o.groups.get(g));
        }
    }

    public void addGroups(DicomObject o) {
        Enumeration e = o.groups.keys();
        while (e.hasMoreElements()) {
            int g = (Integer)e.nextElement();
            DicomObject tmp = o.copyGroup(g);
            this.addGroup(tmp);
        }
    }

    public int numberOfGroups() {
        return this.groups.size();
    }

    public int numberOfElements() {
        int len = 0;
        Enumeration e = this.groups.elements();
        while (e.hasMoreElements()) {
            IntHashtable g = (IntHashtable)e.nextElement();
            len += g.size();
        }
        return len;
    }
}

