/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.VR;
import com.archimed.dicom.charset.DicomCharset;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class DumpUtils {
    private int maxdescription;
    private int maxvalue;
    private int indentsize;
    private boolean metainfo;
    private boolean grouplengths;
    private String lineSeparator;

    public DumpUtils(boolean metainfo, boolean grouplengths) {
        this(35, 60, 6, metainfo, grouplengths);
    }

    public DumpUtils(int maxdescription, int maxvalue, int indentsize, boolean metainfo, boolean grouplengths) {
        this.maxdescription = maxdescription;
        this.maxvalue = maxvalue;
        this.metainfo = metainfo;
        this.indentsize = indentsize;
        this.grouplengths = grouplengths;
        SecurityManager secMgr = System.getSecurityManager();
        if (secMgr != null) {
            try {
                secMgr.checkPropertyAccess("line.separator");
                this.lineSeparator = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException ex) {
                System.err.println("SecurityException when reading system property line.separator ." + ex);
                this.lineSeparator = "\n";
            }
        } else {
            this.lineSeparator = System.getProperty("line.separator", "\n");
        }
    }

    public DumpUtils(int maxdescription, int maxvalue, int indentsize, boolean metainfo) {
        this(maxdescription, maxvalue, indentsize, metainfo, false);
    }

    private static String pad(String s, int len) {
        if (s.length() > len) {
            return s.substring(0, len);
        }
        int r = len - s.length();
        for (int i = 0; i < r; ++i) {
            s = s + " ";
        }
        return s;
    }

    private static String cut(String s, int len) {
        if (s.length() < 4) {
            return "...";
        }
        return s.substring(0, len - 3) + "...";
    }

    private static String fix(String s, int len) {
        if (s.length() > len) {
            return DumpUtils.cut(s, len);
        }
        StringBuffer sb = new StringBuffer(s);
        int r = len - s.length();
        for (int i = 0; i < r; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String toHexString(byte b) {
        return DumpUtils.toHexString(b & 0xFF, 2);
    }

    public static String toHexString(int i, int n) {
        String zero = "";
        String s = Integer.toHexString(i);
        if (n < s.length()) {
            s = s.substring(0, n);
        }
        for (int j = 0; j < n - s.length(); ++j) {
            zero = zero + "0";
        }
        return zero + s;
    }

    public static String tagString(int g, int e) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(DumpUtils.toHexString(g, 4));
        sb.append(",");
        sb.append(DumpUtils.toHexString(e, 4));
        sb.append(") ");
        return sb.toString();
    }

    public static String tagDescriptionString(int g, int e) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(DumpUtils.toHexString(g, 4));
        sb.append(",");
        sb.append(DumpUtils.toHexString(e, 4));
        sb.append(") ");
        sb.append(DDict.getDescription(DDict.lookupDDict(g, e)));
        return sb.toString();
    }

    public void dump(DicomObject dcm, StringBuffer stringBuffer) throws IOException {
        DicomObject metainfodcm;
        if (this.metainfo && (metainfodcm = dcm.getFileMetaInformation()) != null) {
            this.dump(metainfodcm, 0, stringBuffer);
        }
        this.dump(dcm, 0, stringBuffer);
    }

    public void dump(DicomObject dcm, OutputStream out) throws IOException {
        DicomObject metainfodcm;
        StringBuffer sb = new StringBuffer();
        if (this.metainfo && (metainfodcm = dcm.getFileMetaInformation()) != null) {
            this.dump(metainfodcm, 0, sb);
        }
        this.dump(dcm, 0, sb);
        out.write(sb.toString().getBytes());
        out.flush();
    }

    private void dump(DicomObject dcm, int level, StringBuffer sb) throws IOException {
        Enumeration e = dcm.enumerateVRs(this.grouplengths, 8193, true);
        while (e.hasMoreElements()) {
            boolean seq;
            VR vr2 = (VR)e.nextElement();
            boolean bl = seq = vr2.dcm_type == 10;
            if (seq) {
                this.dumpSeqStart(dcm, vr2, level, sb);
                for (int i = 0; i < vr2.val.size(); ++i) {
                    DicomObject item = (DicomObject)vr2.val.elementAt(i);
                    if (item != null) {
                        this.dump(item, level + 1, sb);
                    }
                    if (i == vr2.val.size() - 1) continue;
                    this.dumpItemSepLine(level + 1, sb);
                }
                this.dumpSeqEnd(level, sb);
                continue;
            }
            this.dumpNormalTag(dcm, vr2, level, dcm.dicomCharsets(), sb);
        }
    }

    private void dumpItemSepLine(int level, StringBuffer sb) {
        this.indent(sb, level);
        sb.append("\\");
        sb.append(this.lineSeparator);
    }

    private void dumpSeqStart(DicomObject dcm, VR vr2, int level, StringBuffer sb) {
        this.indent(sb, level);
        this.appendVRinfo(dcm, sb, vr2, level);
        sb.append(this.lineSeparator);
        sb = new StringBuffer("");
        this.indent(sb, level);
        sb.append("[");
        sb.append(this.lineSeparator);
    }

    private void dumpSeqEnd(int level, StringBuffer sb) {
        this.indent(sb, level);
        sb.append("]");
        sb.append(this.lineSeparator);
    }

    private void dumpNormalTag(DicomObject dcm, VR vr2, int level, DicomCharset[] dicomCharsets, StringBuffer sb) throws IOException {
        this.indent(sb, level);
        this.appendVRinfo(dcm, sb, vr2, level);
        sb.append("[");
        StringBuffer val = new StringBuffer("");
        String el = null;
        for (int k = 0; k < vr2.val.size(); ++k) {
            el = vr2.getString(k, false);
            if (el != null) {
                val.append(el);
            }
            if (k == vr2.val.size() - 1) continue;
            val.append("\\");
        }
        if (val != null) {
            if (val.length() > this.maxvalue) {
                sb.append(DumpUtils.cut(val.toString(), this.maxvalue));
            } else {
                sb.append(val);
            }
        }
        sb.append("]");
        sb.append(this.lineSeparator);
    }

    private void indent(StringBuffer sb, int level) {
        int indentSize = level * this.indentsize;
        for (int i = 0; i < indentSize; ++i) {
            sb.append(" ");
        }
    }

    private void appendVRinfo(DicomObject dcm, StringBuffer sb, VR vr2, int level) {
        sb.append("(");
        sb.append(DumpUtils.toHexString(vr2.group, 4));
        sb.append(",");
        sb.append(DumpUtils.toHexString(vr2.element, 4));
        sb.append(")");
        sb.append(" ");
        DDictEntry entry = DDict.getEntry(DDict.lookupDDict(vr2.group, vr2.element));
        String desc = "";
        if (entry == null) {
            desc = "Undefined";
        } else if (vr2.group % 2 == 1) {
            if (vr2.element >= 16 && vr2.element <= 255) {
                desc = "Private Creator";
            } else {
                String cr;
                try {
                    cr = dcm.getString_ge(vr2.getGroup(), vr2.getElement() >> 8, 0);
                }
                catch (Throwable ex) {
                    cr = null;
                }
                desc = entry.getPrivateCreatorID() != null && cr != null && cr.equals(entry.getPrivateCreatorID()) ? entry.getDescription() : "Private Tag";
            }
        } else {
            desc = entry.getDescription();
        }
        int subtract = this.maxdescription - this.indentsize * level;
        subtract = Math.max(subtract, 3);
        sb.append(DumpUtils.fix(desc, subtract));
        sb.append(" ");
        sb.append(DumpUtils.pad(DDict.getTypeName(vr2.dcm_type), 5));
        sb.append(" ");
        sb.append("# ");
        sb.append(DumpUtils.pad(Long.toString(vr2.dataLen), 10));
        sb.append(" ");
        sb.append(DumpUtils.pad(Integer.toString(vr2.val.size()), 8));
        sb.append(" ");
    }
}

