/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.MultiVROutputStream;
import com.archimed.dicom.TagWriteEvent;
import com.archimed.dicom.TagWriteListener;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.VR;
import com.archimed.log.JdtLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DicomWriter {
    public static final int GRPLEN_NONE = 1;
    public static final int GRPLEN_ALL = 2;
    public static final int GRPLEN_KEEP = 3;
    public static final int DCMFILE_NO = 4101;
    public static final int DCMFILE_YES = 4102;
    public static final int DCMFILE_GENERATE = 4103;
    public static final int SEQLEN_UNDEFINED = 8200;
    public static final int SEQLEN_DEFINED = 8201;
    public static final int SEQLEN_KEEPANDUNDEF = 8208;
    public static final int SEQLEN_KEEPANDDEF = 8209;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomWriter.class);
    private Map tagWriteListeners = new HashMap();

    public void addTagWriteListener(TagWriteListener listener, int tag2) {
        this.addTagWriteListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void addTagWriteListener(TagWriteListener listener, int group, int element) {
        Integer key = this.computeListenerKey(group, element);
        Vector<TagWriteListener> v = (Vector<TagWriteListener>)this.tagWriteListeners.get(key);
        if (v == null) {
            v = new Vector<TagWriteListener>();
            this.tagWriteListeners.put(key, v);
        }
        v.add(listener);
    }

    public synchronized void addTagWriteListener(TagWriteListener listener) {
        Vector<TagWriteListener> v = (Vector<TagWriteListener>)this.tagWriteListeners.get(null);
        if (v == null) {
            v = new Vector<TagWriteListener>();
            this.tagWriteListeners.put(null, v);
        }
        v.add(listener);
    }

    public synchronized void removeTagWriteListener(TagWriteListener listener, int tag2) {
        this.removeTagWriteListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void removeTagWriteListener(TagWriteListener listener, int group, int element) {
        Vector v = (Vector)this.tagWriteListeners.get(this.computeListenerKey(group, element));
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public synchronized void removeTagWriteListener(TagWriteListener listener) {
        Vector v = (Vector)this.tagWriteListeners.get(null);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    TagWriteEvent fireBeforeData(DataElement dataElement, OutputStream outputStream, long offset) {
        int i;
        boolean hasListeners = false;
        TagWriteEvent e = new TagWriteEvent(dataElement, outputStream, offset);
        Vector v = (Vector)this.tagWriteListeners.get(null);
        if (v != null && v.size() > 0) {
            hasListeners = true;
            for (i = 0; i < v.size(); ++i) {
                ((TagWriteListener)v.get(i)).beforeHeader(e);
            }
        }
        if ((v = (Vector)this.tagWriteListeners.get(this.computeListenerKey(dataElement))) != null && v.size() > 0) {
            hasListeners = true;
            for (i = 0; i < v.size(); ++i) {
                ((TagWriteListener)v.get(i)).beforeHeader(e);
            }
        }
        return hasListeners ? e : null;
    }

    private Integer computeListenerKey(DataElement dataElement) {
        return this.computeListenerKey(dataElement.getGroup(), dataElement.getElement());
    }

    private Integer computeListenerKey(int g, int e) {
        return new Integer(g * 65535 + e);
    }

    public void write(DicomObject dcm, OutputStream out, boolean dicomfile) throws DicomException, IOException {
        int ts;
        DicomObject filemetainfo = dcm.getFileMetaInformation();
        if (dicomfile && filemetainfo == null) {
            dcm.changeDICOMFileMetaInformation(8193);
        }
        try {
            ts = UID.getUIDEntry(filemetainfo.getS(31)).getConstant();
        }
        catch (Exception e) {
            ts = 8193;
        }
        this.write(dcm, out, dicomfile, ts, Jdt.isWriteDefaultUndefLenSequences(), Jdt.isWriteDefaultGroupLengths());
    }

    public void write(DicomObject dcm, OutputStream out, boolean dicomfile, int transfersyntax, boolean seq_undef) throws DicomException, IOException {
        this.write(dcm, out, dicomfile, transfersyntax, seq_undef, true);
    }

    public void write(DicomObject dcm, OutputStream out, boolean dicomfile, int transfersyntax, boolean seq_undef, boolean grouplens) throws DicomException, IOException {
        int groupLengthOpt;
        int seqLengthOpt = seq_undef ? 8200 : 8201;
        int n = groupLengthOpt = grouplens ? 2 : 1;
        if (dicomfile) {
            if (dcm.getFileMetaInformation() == null) {
                dcm.changeDICOMFileMetaInformation(transfersyntax);
            }
            this.writeFile(dcm, out, seqLengthOpt, groupLengthOpt);
        } else {
            this.writeDataSet(dcm, out, transfersyntax, seqLengthOpt, groupLengthOpt);
        }
    }

    public void writeFile(DicomObject dcm, OutputStream out, int seqLengthOpt, int groupLengthOpt) throws DicomException, IOException {
        int ts;
        this.checkOptions(seqLengthOpt, groupLengthOpt);
        DicomObject meta = dcm.getFileMetaInformation();
        if (meta == null) {
            throw new DicomException("Cannot write DICOM file: no meta information object specified in DicomObject");
        }
        if (meta.getSize(31) == 0) {
            throw new DicomException("Cannot write DICOM file: transfer syntax missing in file meta information");
        }
        String s = null;
        try {
            s = (String)meta.get(31);
            ts = UID.getUIDEntry(s).getConstant();
        }
        catch (UnknownUIDException e) {
            throw new DicomException("Cannot write DICOM file: unknown transfer syntax '" + s + "'");
        }
        long offset = this.writeHeader(dcm, out);
        if (offset >= 0L) {
            this.writeTags(dcm, out, ts, seqLengthOpt, groupLengthOpt, offset);
        }
    }

    public void writeDataSet(DicomObject dcm, OutputStream out, int transferSyntax, int seqLengthOpt, int groupLengthOpt) throws DicomException, IOException {
        this.checkOptions(seqLengthOpt, groupLengthOpt);
        this.writeTags(dcm, out, transferSyntax, seqLengthOpt, groupLengthOpt, 0L);
    }

    private void checkOptions(int seqLengthOpt, int groupLengthOpt) {
        if (groupLengthOpt < 1 || groupLengthOpt > 3) {
            throw new IllegalArgumentException("Illegal value for groupOpt");
        }
        if (seqLengthOpt < 8200 || seqLengthOpt > 8209) {
            throw new IllegalArgumentException("Illegal value for seqLengthOpt");
        }
    }

    long writeHeader(DicomObject dcm, OutputStream f) throws IOException, DicomException {
        this.log.debug("DicomObject.writeHeader.");
        byte[] buffer = dcm.getPreamble();
        if (buffer == null) {
            buffer = new byte[128];
        }
        assert (buffer.length == 128);
        f.write(buffer);
        f.write(68);
        f.write(73);
        f.write(67);
        f.write(77);
        return this.writeTags(dcm.getFileMetaInformation(), f, 8194, 8201, 2, 0L);
    }

    long writeTags(DicomObject dcm, OutputStream out, int transferSyntax, int seqLengthOpt, int groupLengthOpt, long startOffset) throws IOException, DicomException {
        this.log.debug("DicomObject.writeTags.");
        MultiVROutputStream os = new MultiVROutputStream(out, startOffset);
        os.setTransferSyntax(transferSyntax);
        Enumeration e = dcm.enumerateVRs(transferSyntax, seqLengthOpt, groupLengthOpt);
        while (e.hasMoreElements()) {
            VR vr2 = (VR)e.nextElement();
            TagWriteEvent event = this.fireBeforeData(vr2, out, os.getOffset());
            if (event == null || event.getDataWriteStatus() == 0) {
                vr2.writeVRHeader(os, seqLengthOpt);
                vr2.writeVRData(os, seqLengthOpt, groupLengthOpt);
            } else if (event.getDataWriteStatus() == 3 && groupLengthOpt == 2) {
                throw new DicomException("cannot skip tag when writing grouplengths");
            }
            if (event == null || !event.isStopWriting()) continue;
            return -1L;
        }
        return os.getOffset();
    }
}

