/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.MultiVRInputStream;
import com.archimed.dicom.SequenceItemReadEvent;
import com.archimed.dicom.SequenceItemReadListener;
import com.archimed.dicom.TagRead2Listener;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.VR;
import com.archimed.log.JdtLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;

public class DicomReader {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomReader.class);
    private HashMap tagReadListeners = new HashMap();
    private HashMap sequenceItemReadListeners = new HashMap();

    public void addTagReadListener(TagReadListener listener, int tag2) {
        this.addTagReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void addTagReadListener(TagReadListener listener, int group, int element) {
        Integer key = new Integer(group * 65535 + element);
        Vector<TagReadListener> v = (Vector<TagReadListener>)this.tagReadListeners.get(key);
        if (v == null) {
            v = new Vector<TagReadListener>();
            this.tagReadListeners.put(key, v);
        }
        v.add(listener);
    }

    public synchronized void addTagReadListener(TagReadListener listener) {
        Vector<TagReadListener> v = (Vector<TagReadListener>)this.tagReadListeners.get(null);
        if (v == null) {
            v = new Vector<TagReadListener>();
            this.tagReadListeners.put(null, v);
        }
        v.add(listener);
    }

    public synchronized void removeTagReadListener(TagReadListener listener, int tag2) {
        this.removeTagReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void removeTagReadListener(TagReadListener listener, int group, int element) {
        Integer key = new Integer(group * 65535 + element);
        Vector v = (Vector)this.tagReadListeners.get(key);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public synchronized void removeTagReadListener(TagReadListener listener) {
        Vector v = (Vector)this.tagReadListeners.get(null);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public void addSequenceItemReadListener(SequenceItemReadListener listener, int tag2) {
        this.addSequenceItemReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void addSequenceItemReadListener(SequenceItemReadListener listener, int group, int element) {
        Integer key = new Integer(group * 65535 + element);
        Vector<SequenceItemReadListener> v = (Vector<SequenceItemReadListener>)this.sequenceItemReadListeners.get(key);
        if (v == null) {
            v = new Vector<SequenceItemReadListener>();
            this.sequenceItemReadListeners.put(key, v);
        }
        v.add(listener);
    }

    public synchronized void addSequenceItemReadListener(SequenceItemReadListener listener) {
        Vector<SequenceItemReadListener> v = (Vector<SequenceItemReadListener>)this.sequenceItemReadListeners.get(null);
        if (v == null) {
            v = new Vector<SequenceItemReadListener>();
            this.sequenceItemReadListeners.put(null, v);
        }
        v.add(listener);
    }

    public synchronized void removeSequenceItemReadListener(SequenceItemReadListener listener, int tag2) {
        this.removeSequenceItemReadListener(listener, DDict.getGroup(tag2), DDict.getElement(tag2));
    }

    public synchronized void removeSequenceItemReadListener(SequenceItemReadListener listener, int group, int element) {
        Integer key = new Integer(group * 65535 + element);
        Vector v = (Vector)this.sequenceItemReadListeners.get(key);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public synchronized void removeSequenceItemReadListener(SequenceItemReadListener listener) {
        Vector v = (Vector)this.sequenceItemReadListeners.get(null);
        if (v == null) {
            return;
        }
        v.remove(listener);
    }

    public DicomObject read(InputStream in) throws IOException, DicomException {
        return this.read(in, true);
    }

    public DicomObject read(InputStream in, int transfersyntax, boolean readpixels) throws IOException, DicomException {
        DicomObject dcm = new DicomObject();
        MultiVRInputStream multiVRIn = new MultiVRInputStream(in);
        this.readDICOMStream(dcm, multiVRIn, transfersyntax, readpixels);
        return dcm;
    }

    public DicomObject read(InputStream in, boolean readpixels) throws IOException, DicomException {
        DicomObject dcm = new DicomObject();
        this.read(dcm, in, readpixels);
        return dcm;
    }

    public DicomObject readSequenceItem(InputStream in, int transferSyntax) throws IOException, DicomException {
        MultiVRInputStream multiVRin = new MultiVRInputStream(in);
        multiVRin.setTransferSyntax(transferSyntax);
        int group = multiVRin.readUInt16();
        int element = multiVRin.readUInt16();
        if (group != 65534 || element != 57344) {
            throw new DicomException("illegal value for group,element tag, expecting (FFFE,E000)");
        }
        DicomObject parent = new DicomObject();
        VR vr2 = new VR(parent);
        return vr2.readOrphanedSequenceItem(parent, this, multiVRin);
    }

    TagReadEvent fireAfterReadHeader(DataElement dataElement, InputStream in, long offset) {
        Integer key;
        boolean hasListeners = false;
        TagReadEvent e = new TagReadEvent(dataElement, in, offset);
        Vector v = (Vector)this.tagReadListeners.get(null);
        if (v != null && v.size() > 0) {
            hasListeners = true;
            for (int i = 0; i < v.size(); ++i) {
                ((TagReadListener)v.get(i)).afterHeader(e);
            }
        }
        if ((v = (Vector)this.tagReadListeners.get(key = new Integer(dataElement.getGroup() * 65535 + dataElement.getElement()))) != null && v.size() > 0) {
            hasListeners = true;
            for (int i = 0; i < v.size(); ++i) {
                ((TagReadListener)v.get(i)).afterHeader(e);
            }
        }
        return hasListeners ? e : null;
    }

    TagReadEvent fireAfterReadData(TagReadEvent e) {
        Integer key;
        boolean hasListeners = false;
        Vector v = (Vector)this.tagReadListeners.get(null);
        if (v != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (!TagRead2Listener.class.isAssignableFrom(v.get(i).getClass())) continue;
                hasListeners = true;
                ((TagRead2Listener)v.get(i)).afterData(e);
            }
        }
        if ((v = (Vector)this.tagReadListeners.get(key = new Integer(e.getGroup() * 65535 + e.getElement()))) != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (!TagRead2Listener.class.isAssignableFrom(v.get(i).getClass())) continue;
                hasListeners = true;
                ((TagRead2Listener)v.get(i)).afterData(e);
            }
        }
        return hasListeners ? e : null;
    }

    void fireAfterReadSequenceItem(DataElement dataElement, DicomObject sequenceItem, MultiVRInputStream in) {
        Integer key;
        boolean hasListeners = false;
        SequenceItemReadEvent e = new SequenceItemReadEvent(dataElement, sequenceItem, in);
        Vector v = (Vector)this.sequenceItemReadListeners.get(null);
        if (v != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                hasListeners = true;
                ((SequenceItemReadListener)v.get(i)).afterSequenceItem(e);
            }
        }
        if ((v = (Vector)this.sequenceItemReadListeners.get(key = new Integer(dataElement.getGroup() * 65535 + dataElement.getElement()))) != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                hasListeners = true;
                ((SequenceItemReadListener)v.get(i)).afterSequenceItem(e);
            }
        }
    }

    void read(DicomObject dcm, InputStream in, boolean process) throws IOException, DicomException {
        boolean df;
        InputStream bis = in.markSupported() ? in : new BufferedInputStream(in);
        bis.mark(256);
        try {
            df = this.checkIfDicomFile(bis);
        }
        catch (Exception e) {
            df = false;
        }
        bis.reset();
        MultiVRInputStream multiVRInputStream = new MultiVRInputStream(bis);
        if (df) {
            long offset = this.readHeader(dcm, multiVRInputStream);
            if (offset == -1L) {
                return;
            }
            this.readDICOMStream(dcm, multiVRInputStream, 8193, process);
        } else {
            this.readDICOMStream(dcm, multiVRInputStream, 8193, process);
        }
    }

    public boolean checkIfDicomFile(InputStream f) throws IOException, DicomException {
        byte[] preamble = new byte[128];
        byte[] hdr = new byte[4];
        DataInputStream is = new DataInputStream(f);
        try {
            is.readFully(preamble);
            is.readFully(hdr);
        }
        catch (EOFException ex) {
            this.log.warn("EOFException before reading 132 bytes: not a DICOM file");
            return false;
        }
        return new String(hdr).equals("DICM");
    }

    void readDICOMStream(DicomObject dcm, MultiVRInputStream multiVRIn, int ts, boolean process) throws IOException, DicomException {
        this.log.debug("DicomObject.readDICOMStream.");
        DicomObject filemetainfo = dcm.getFileMetaInformation();
        if (filemetainfo != null) {
            try {
                ts = UID.getUIDEntry(filemetainfo.getS(31).trim()).getConstant();
            }
            catch (UnknownUIDException e) {
                ts = 8192;
            }
        }
        multiVRIn.setTransferSyntax(ts);
        this.readTags(dcm, multiVRIn, process);
        if (ts == 8193 || ts == 8227) {
            boolean wasAdjusted = this.adjustTypes(dcm);
        }
    }

    long readHeader(DicomObject dcm, MultiVRInputStream multiVRIn) throws IOException, DicomException {
        this.log.debug("DicomObject.readHeader.");
        byte[] preamble = new byte[128];
        byte[] hdr = new byte[4];
        multiVRIn.setTransferSyntax(8194);
        multiVRIn.readFully(preamble);
        dcm.setPreamble(preamble);
        multiVRIn.readFully(hdr);
        if (hdr[0] != 68 || hdr[1] != 73 || hdr[2] != 67 || hdr[3] != 77) {
            throw new DicomException("Not a valid DICOM file: missing DICM characters at offset 128");
        }
        DicomObject filemetainfo = new DicomObject();
        dcm.setFileMetaInformation(filemetainfo);
        int futureTS = 8192;
        while (true) {
            VR vr2 = new VR(filemetainfo);
            int group = multiVRIn.readUInt16();
            multiVRIn.unreadUInt16(group);
            if (group != 2) break;
            int readState = vr2.readVR(filemetainfo, this, multiVRIn, true);
            if (vr2.getGroup() != 2) {
                if (this.handleVR(dcm, vr2, readState)) break;
                return -1L;
            }
            if (!this.handleVR(filemetainfo, vr2, readState)) {
                return -1L;
            }
            if (vr2.getGroup() != 2 || vr2.getElement() != 16) continue;
            try {
                String s = filemetainfo.getS(31);
                if (s == null) {
                    throw new DicomException("missing Transfer Syntax UID data element in file meta information");
                }
                futureTS = UID.getUIDEntry(s.trim()).getConstant();
            }
            catch (UnknownUIDException e) {
                multiVRIn.setTransferSyntax(8192);
            }
        }
        multiVRIn.setTransferSyntax(futureTS);
        return multiVRIn.getOffset();
    }

    /*
     * Exception decompiling
     */
    void readTags(DicomObject dcm, MultiVRInputStream is, boolean process) throws IOException, DicomException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean handleVR(DicomObject dcm, VR vr2, int readState) {
        switch (readState) {
            case 1: {
                dcm.push(vr2);
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                dcm.push(vr2);
                return false;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    private boolean adjustTypes(DicomObject dcm) {
        boolean b = false;
        b = this.adjustToOW(dcm, 1184);
        b = this.adjustToOW(dcm, 1505);
        b = this.adjustToOW(dcm, 498);
        b = this.adjustToOW(dcm, 499);
        b = this.adjustToOW(dcm, 500);
        b = this.adjustToOW(dcm, 501);
        b = this.adjustToOW(dcm, 502);
        b = this.adjustToOW(dcm, 503);
        for (int g = 0; g < 64; ++g) {
            b = this.adjustType(dcm, 24576 + g, 12288, 24);
            b = this.adjustType(dcm, 20480 + g, 12288, 8);
            VR vr2 = dcm.getVR(20480 + g, 8194);
            b = vr2 != null && vr2.getValue() != null && (Integer)vr2.getValue() == 0 ? this.adjustType(dcm, 20480, 8204, 24) : this.adjustType(dcm, 20480, 8204, 8);
        }
        return b;
    }

    private boolean adjustToOW(DicomObject dcm, int dct) {
        int group = DDict.getGroup(dct);
        int element = DDict.getElement(dct);
        return this.adjustType(dcm, group, element, 24);
    }

    private boolean adjustType(DicomObject dcm, int group, int element, int vrtype) {
        VR vr2 = dcm.getVR(group, element);
        if (vr2 != null && vr2.dcm_type == 22) {
            vr2.dcm_type = vrtype;
            return true;
        }
        return false;
    }
}

