/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DDictMap;
import com.archimed.dicom.DicomException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class DDictBase {
    public static final int tUN = 0;
    public static final int tUNKNOWN = 0;
    public static final int tUL = 1;
    public static final int tUI = 2;
    public static final int tUS = 3;
    public static final int tAE = 4;
    public static final int tAT = 5;
    public static final int tLO = 6;
    public static final int tSH = 7;
    public static final int tOB = 8;
    public static final int tCS = 9;
    public static final int tSQ = 10;
    public static final int tDA = 11;
    public static final int tTM = 12;
    public static final int tST = 13;
    public static final int tPN = 14;
    public static final int tIS = 15;
    public static final int tDS = 16;
    public static final int tAS = 17;
    public static final int tLT = 18;
    public static final int tSL = 19;
    public static final int tFD = 20;
    public static final int tUS_SS = 21;
    public static final int tOW_OB = 22;
    public static final int tSS = 23;
    public static final int tOW = 24;
    public static final int tNONE = 25;
    public static final int tFL = 26;
    public static final int tUT = 27;
    public static final int tDT = 28;
    public static final int tOF = 29;
    private static String[] typeCodeNames = new String[]{"UN", "UL", "UI", "US", "AE", "AT", "LO", "SH", "OB", "CS", "SQ", "DA", "TM", "ST", "PN", "IS", "DS", "AS", "LT", "SL", "FD", "US_SS", "OW_OB", "SS", "OW", "NONE", "FL", "UT", "DT", "OF"};
    public static final int dUNDEFINED = Integer.MAX_VALUE;
    protected static HashMap dctList = new HashMap();
    protected static DDictMap geList = new DDictMap();
    protected static HashMap privateList = new HashMap();

    public static String getTypeName(int type) {
        if (type < 0 || type > typeCodeNames.length) {
            throw new IllegalArgumentException("unknown DDict tXX type constant: " + type);
        }
        return typeCodeNames[type];
    }

    public static String getTypeCodeName(int dct) {
        DDictEntry ddictEntry = DDict.getEntry(dct);
        if (ddictEntry == null) {
            return DDictBase.getTypeName(0);
        }
        return DDictBase.getTypeName(ddictEntry.getType());
    }

    public static int lookupDDict(int group, int element, String creator) {
        if (creator != null && (DDictBase.isPrivateTag(group, element) || DDictBase.isPrivateCreatorTag(group, element))) {
            Integer dctKey = (Integer)privateList.get(DDictBase.createPrivateListKey(group, element, creator));
            return dctKey == null ? Integer.MAX_VALUE : dctKey;
        }
        if ((group & 0xFF00) == 20480 && (group & 1) != 1) {
            group = 20480;
        } else if ((group & 0xFF00) == 24576 && (group & 1) != 1) {
            group = 24576;
        }
        int gekey = (group << 16) + element;
        int i = geList.get(gekey);
        return i == Integer.MAX_VALUE ? Integer.MAX_VALUE : i;
    }

    public static int lookupDDict(int group, int element) {
        return DDictBase.lookupDDict(group, element, null);
    }

    public static int getGroup(int dct) {
        return ((DDictEntry)dctList.get(new Integer(dct))).getGroup();
    }

    public static int getElement(int dct) {
        return ((DDictEntry)dctList.get(new Integer(dct))).getElement();
    }

    public static int getTypeCode(int dct) {
        DDictEntry ddictEntry = DDict.getEntry(dct);
        if (ddictEntry == null) {
            return 0;
        }
        return ddictEntry.getType();
    }

    public static int getTypeCode(int group, int element) {
        int tc = DDictBase.getTypeCode(DDictBase.lookupDDict(group, element));
        if (tc == 0 && (group & 1) == 1) {
            if (element >= 16 && element <= 255) {
                return 6;
            }
            return 0;
        }
        return tc;
    }

    public static int getTypeCode(int group, int element, String creator) {
        int dctKey = DDictBase.lookupDDict(group, element, creator);
        DDictEntry dDictEntry = (DDictEntry)dctList.get(dctKey);
        return dDictEntry == null ? 0 : dDictEntry.getType();
    }

    public static String getDescription(int dct) {
        DDictEntry entry = DDictBase.getEntry(dct);
        if (entry == null) {
            return "Undefined";
        }
        return entry.getDescription();
    }

    public static Enumeration ddictEntries() {
        Enumeration enu = new Enumeration(){
            private Iterator it = dctList.keySet().iterator();

            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                return dctList.get(this.it.next());
            }
        };
        return enu;
    }

    public static DDictEntry getEntry(int dct) {
        return (DDictEntry)dctList.get(new Integer(dct));
    }

    static DDictEntry getEntry(int group, int element, String creator) {
        if (creator == null) {
            return DDictBase.getEntry(DDictBase.lookupDDict(group, element));
        }
        Integer deKey = (Integer)privateList.get(DDictBase.createPrivateListKey(group, element, creator));
        return DDictBase.getEntry(deKey);
    }

    public static int addEntry(DDictEntry de) throws DicomException {
        Iterator iterator = dctList.keySet().iterator();
        int key = 0;
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index == Integer.MAX_VALUE || key >= index) continue;
            key = index;
        }
        dctList.put(new Integer(++key), de);
        int gekey = (de.getGroup() << 16) + de.getElement();
        geList.put(gekey, key);
        DDictBase.addExtraEntriesForPrivateTag(de.getGroup(), de.getElement(), key);
        if (DDictBase.isPrivateTag(de.getGroup(), de.getElement()) || DDictBase.isPrivateCreatorTag(de.getGroup(), de.getElement())) {
            privateList.put(DDictBase.createPrivateListKey(de.getGroup(), de.getElement(), de.getPrivateCreatorID()), key);
        }
        return key;
    }

    private static void addExtraEntriesForPrivateTag(int group, int element, int key) {
        if (!DDict.isPrivateTag(group, element)) {
            return;
        }
        for (int i = 17; i <= 255; ++i) {
            int gekey = group << 16 | i << 8 | element;
            geList.put(gekey, key);
        }
    }

    static int getTypeFixed(int typecode) {
        switch (typecode) {
            case 3: 
            case 21: 
            case 23: {
                return 2;
            }
            case 1: 
            case 5: 
            case 19: 
            case 26: {
                return 4;
            }
            case 20: {
                return 8;
            }
        }
        return 0;
    }

    static int getTypeCode(String s) throws DicomException {
        if (s.equals("UL")) {
            return 1;
        }
        if (s.equals("UI")) {
            return 2;
        }
        if (s.equals("LO")) {
            return 6;
        }
        if (s.equals("US")) {
            return 3;
        }
        if (s.equals("AE")) {
            return 4;
        }
        if (s.equals("AT")) {
            return 5;
        }
        if (s.equals("SH")) {
            return 7;
        }
        if (s.equals("IS")) {
            return 15;
        }
        if (s.equals("OB")) {
            return 8;
        }
        if (s.equals("DA")) {
            return 11;
        }
        if (s.equals("TM")) {
            return 12;
        }
        if (s.equals("CS")) {
            return 9;
        }
        if (s.equals("SQ")) {
            return 10;
        }
        if (s.equals("LT")) {
            return 18;
        }
        if (s.equals("ST")) {
            return 13;
        }
        if (s.equals("PN")) {
            return 14;
        }
        if (s.equals("DS")) {
            return 16;
        }
        if (s.equals("AS")) {
            return 17;
        }
        if (s.equals("SL")) {
            return 19;
        }
        if (s.equals("FD")) {
            return 20;
        }
        if (s.equals("FL")) {
            return 26;
        }
        if (s.equals("OW")) {
            return 24;
        }
        if (s.equals("SS")) {
            return 23;
        }
        if (s.equals("UN")) {
            return 0;
        }
        if (s.equals("UT")) {
            return 27;
        }
        if (s.equals("DT")) {
            return 28;
        }
        if (s.equals("OF")) {
            return 29;
        }
        throw new DicomException("getTypeCode: unexpected type " + s);
    }

    static final boolean isPrivateTag(int group, int element) {
        return (group & 1) == 1 && element >= 4096 && element <= 65535;
    }

    static final boolean isPrivateCreatorTag(int group, int element) {
        return (group & 1) == 1 && element >= 16 && element <= 255;
    }

    private static String createPrivateListKey(int g, int e, String creator) {
        int gekey = (g << 16) + (0xFF & e);
        return gekey + creator;
    }

    private static int mapGroupElementToKey(int group, int element, String creator) {
        if (DDictBase.isPrivateTag(group, element)) {
            if (creator == null) {
                throw new IllegalArgumentException("A private creator must be specified when this method is invoked for a private tag.");
            }
            return (group << 16) + element;
        }
        return (group << 16) + element;
    }

    static {
        dctList.put(new Integer(Integer.MAX_VALUE), new DDictEntry(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, "Undefined", "1"));
        DDict.initDDict();
    }
}

