/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDate;
import java.text.DateFormat;

public class DDateRange {
    DDate d1;
    DDate d2;

    public DDateRange(DDate dd1, DDate dd2) {
        this.d1 = dd1 != null ? dd1 : new DDate();
        this.d2 = dd2 != null ? dd2 : new DDate();
    }

    public DDateRange(String s) throws NumberFormatException {
        int idx = s.indexOf(45);
        if (idx == -1) {
            throw new NumberFormatException(s + " cannot parse this string into DDateRange");
        }
        this.d1 = new DDate(s.substring(0, idx));
        this.d2 = new DDate(s.substring(idx + 1));
    }

    public String toString() {
        return this.d1.toString() + " - " + this.d2.toString();
    }

    public String toString(DateFormat df) {
        return this.d1.toString(df) + " - " + this.d2.toString(df);
    }

    public String toDICOMString() {
        return this.d1.toDICOMString() + "-" + this.d2.toDICOMString();
    }

    public DDate getDate1() {
        if (!this.d1.isEmpty()) {
            return this.d1;
        }
        return null;
    }

    public DDate getDate2() {
        if (!this.d2.isEmpty()) {
            return this.d2;
        }
        return null;
    }
}

