/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.log.JdtLogger;
import java.io.ObjectStreamException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DDate {
    private static final long serialVersionUID = 1L;
    private Calendar cal;
    private boolean empty = false;
    private String original = null;
    protected transient JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DDate.class);

    public DDate() {
        this.cal = new GregorianCalendar();
        this.empty = true;
    }

    public DDate(String str) throws NumberFormatException {
        this.original = str;
        if (str.equals("")) {
            this.empty = true;
            return;
        }
        if (str.length() == 8) {
            try {
                int y = Integer.parseInt(str.substring(0, 4));
                int m = Integer.parseInt(str.substring(4, 6));
                int d = Integer.parseInt(str.substring(6, 8));
                this.cal = new GregorianCalendar(y, m - 1, d);
            }
            catch (NumberFormatException ex) {
                this.log.warn("Error parsing date: '" + str + "' keeping original");
            }
        } else {
            this.log.warn("Error parsing date: '" + str + "' keeping original");
        }
    }

    private Object readResolve() throws ObjectStreamException {
        this.log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomObject.class);
        return this;
    }

    public String toString() {
        if (this.empty) {
            return "";
        }
        if (this.cal == null) {
            return this.original;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("EEE dd MMM yyyy");
        return formatter.format(this.cal.getTime());
    }

    public String toString(DateFormat format) {
        if (this.empty) {
            return "";
        }
        if (this.cal == null) {
            return this.original;
        }
        return format.format(this.cal.getTime());
    }

    public String toDICOMString() {
        if (this.empty) {
            return "";
        }
        if (this.cal == null) {
            return this.original;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        return formatter.format(this.cal.getTime());
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

