/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.ATValue;
import com.archimed.dicom.ByteArray;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DDateRange;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DumpUtils;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.Person;
import com.archimed.dicom.charset.DicomCharset;

class ConvertUtils {
    ConvertUtils() {
    }

    static Object objectToExternalObject(Object o, int dcm_type, DicomCharset[] dicomCharsets, boolean trim) {
        switch (dcm_type) {
            case 6: 
            case 7: 
            case 13: 
            case 18: 
            case 27: {
                byte[] ar = (byte[])o;
                if (trim) {
                    int[] pos = ConvertUtils.trim(ar, dcm_type);
                    return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1], dicomCharsets);
                }
                return Jdt.getCharsetCoder().decode(ar, 0, ar.length, dicomCharsets);
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 17: 
            case 28: {
                byte[] ar = (byte[])o;
                if (trim) {
                    int[] pos = ConvertUtils.trim(ar, dcm_type);
                    return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1]);
                }
                return Jdt.getCharsetCoder().decode(ar, 0, ar.length);
            }
            case 15: {
                byte[] ar = (byte[])o;
                int[] pos = ConvertUtils.trim(ar, dcm_type);
                String s = Jdt.getCharsetCoder().decode(ar, pos[0], pos[1]);
                return Integer.valueOf(s, 10);
            }
            case 14: {
                byte[] ar = (byte[])o;
                if (trim) {
                    int[] pos = ConvertUtils.trim(ar, dcm_type);
                    if (Jdt.isPNAsByteArray()) {
                        byte[] ar2 = new byte[pos[1]];
                        System.arraycopy(ar, pos[0], ar2, 0, pos[1]);
                        return ar2;
                    }
                    return new Person(Jdt.getCharsetCoder().decode(ar, pos[0], pos[1], dicomCharsets));
                }
                if (Jdt.isPNAsByteArray()) {
                    return ar;
                }
                return new Person(Jdt.getCharsetCoder().decode(ar, 0, ar.length, dicomCharsets));
            }
            case 11: {
                byte[] ar = (byte[])o;
                String s = Jdt.getCharsetCoder().decode(ar);
                assert (s != null);
                if (s.indexOf(45) != -1) {
                    return new DDateRange(s);
                }
                return new DDate(s);
            }
            case 16: {
                byte[] ar = (byte[])o;
                if (Jdt.isDSAsString()) {
                    if (trim) {
                        int[] pos = ConvertUtils.trim(ar, dcm_type);
                        return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1]);
                    }
                    return Jdt.getCharsetCoder().decode(ar, 0, ar.length);
                }
                int[] pos = ConvertUtils.trim(ar, dcm_type);
                String s = Jdt.getCharsetCoder().decode(ar, pos[0], pos[1]);
                if (s == null || s.equals("")) {
                    return null;
                }
                return Float.valueOf(s);
            }
            case 5: {
                ATValue at = (ATValue)o;
                return new Integer(at.getGroup() << 16 + at.getElement());
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: {
                ByteArray byteArray = (ByteArray)o;
                if (byteArray.arrays() == 1) {
                    return byteArray.getArray(0);
                }
                return o;
            }
        }
        return o;
    }

    static String objectToString(Object o, int dcm_type, DicomCharset[] dicomCharsets, boolean trim) {
        String s = "";
        if (o == null) {
            return null;
        }
        switch (dcm_type) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 27: 
            case 28: {
                return (String)ConvertUtils.objectToExternalObject(o, dcm_type, dicomCharsets, trim);
            }
            case 16: {
                if (Jdt.isDSAsString()) {
                    return (String)ConvertUtils.objectToExternalObject(o, dcm_type, dicomCharsets, trim);
                }
                return ((Float)ConvertUtils.objectToExternalObject(o, dcm_type, dicomCharsets, trim)).toString();
            }
            case 15: {
                byte[] ar = (byte[])o;
                if (trim) {
                    int[] pos = ConvertUtils.trim(ar, dcm_type);
                    return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1]);
                }
                return Jdt.getCharsetCoder().decode(ar, 0, ar.length);
            }
            case 14: {
                byte[] ar = (byte[])o;
                if (trim) {
                    int[] pos = ConvertUtils.trim(ar, dcm_type);
                    return Jdt.getCharsetCoder().decode(ar, pos[0], pos[1], dicomCharsets);
                }
                return Jdt.getCharsetCoder().decode(ar, 0, ar.length, dicomCharsets);
            }
            case 11: {
                return Jdt.getCharsetCoder().decode((byte[])o);
            }
            case 1: 
            case 3: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                return o.toString();
            }
            case 0: 
            case 8: 
            case 22: 
            case 24: {
                s = "";
                int len = ((byte[])o).length;
                if (len > 12) {
                    len = 12;
                }
                for (int i = 0; i < len; ++i) {
                    s = i != len - 1 ? s + DumpUtils.toHexString(((byte[])o)[i], 2) + "\\" : s + DumpUtils.toHexString(((byte[])o)[i], 2);
                }
                if (len == 12) {
                    s = s + "...";
                }
                return s;
            }
            case 5: {
                ATValue at = (ATValue)o;
                int g = at.getGroup();
                int e = at.getElement();
                s = "(" + DumpUtils.toHexString(g, 4) + "," + DumpUtils.toHexString(e, 4) + ")";
                return s;
            }
            case 29: {
                s = "";
                int len = ((float[])o).length;
                if (len > 2) {
                    len = 2;
                }
                for (int i = 0; i < len; ++i) {
                    s = i != len - 1 ? s + ((float[])o)[i] + ";" : s + ((float[])o)[i];
                }
                if (((float[])o).length > 2) {
                    s = s + ";...";
                }
                return s;
            }
        }
        return null;
    }

    static int objectToInt(Object o, int dcm_type) throws DicomException {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        switch (dcm_type) {
            case 23: {
                return ((Short)o).intValue();
            }
            case 3: 
            case 15: 
            case 21: {
                return (Integer)o;
            }
            case 1: 
            case 19: {
                return ((Long)o).intValue();
            }
            case 5: {
                ATValue at = (ATValue)o;
                return new Integer(at.getGroup() << 16 + at.getElement());
            }
        }
        throw new DicomException("unable to convert " + DDict.getTypeName(dcm_type) + " to int");
    }

    static int[] trim(byte[] ar, int dcm_type) {
        if (ar.length == 0) {
            return new int[]{0, 0};
        }
        switch (dcm_type) {
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 28: {
                int length;
                int startpos;
                for (startpos = 0; startpos < ar.length && (ar[startpos] == 32 || ar[startpos] == 0); ++startpos) {
                }
                for (length = ar.length; length > 0 && (ar[length - 1] == 32 || ar[length - 1] == 0); --length) {
                }
                return new int[]{startpos < ar.length ? startpos : 0, Math.max(length - startpos, 0)};
            }
            case 13: 
            case 14: 
            case 18: 
            case 27: {
                int length;
                int startpos = 0;
                for (length = ar.length; length > 0 && (ar[length - 1] == 32 || ar[length - 1] == 0); --length) {
                }
                return new int[]{startpos < ar.length ? startpos : 0, Math.max(length - startpos, 0)};
            }
            case 17: {
                return new int[]{0, ar.length};
            }
            case 2: {
                if (ar[ar.length - 1] == 0 || ar[ar.length - 1] == 32) {
                    return new int[]{0, ar.length - 1};
                }
                return new int[]{0, ar.length};
            }
        }
        assert (false);
        return null;
    }
}

