/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

public class ByteArray {
    public static final int MAXLENGTH_BYTEARRAY = 0x7FFFFFF6;
    private byte[][] arrays;

    public ByteArray(byte[] ... arrays) {
        for (int i = 0; i < arrays.length; ++i) {
            if (arrays[i] != null) continue;
            throw new IllegalArgumentException("specified byte arrays must be non-null");
        }
        this.arrays = arrays;
    }

    public ByteArray(long capacity) {
        int numBackingArrays = (int)(capacity / 0x7FFFFFF6L + 1L);
        int lastArrayLength = (int)(capacity % 0x7FFFFFF6L);
        this.arrays = new byte[numBackingArrays][];
        for (int i = 0; i < numBackingArrays - 1; ++i) {
            this.arrays[i] = new byte[0x7FFFFFF6];
        }
        this.arrays[numBackingArrays - 1] = new byte[lastArrayLength];
    }

    public long length() {
        long length = 0L;
        for (int i = 0; i < this.arrays.length; ++i) {
            length += (long)this.arrays[i].length;
        }
        return length;
    }

    public int arrays() {
        return this.arrays.length;
    }

    public byte[] getArray(int index) {
        return this.arrays[index];
    }

    ByteArray copy() {
        byte[][] copy = new byte[this.arrays()][];
        for (int i = 0; i < this.arrays(); ++i) {
            copy[i] = new byte[this.getArray(i).length];
            System.arraycopy(this.getArray(i), 0, copy[i], 0, this.getArray(i).length);
        }
        return new ByteArray(copy);
    }
}

