/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.codec.jpeg;

import com.archimed.codec.jpeg.DecompressInfo;
import com.archimed.codec.jpeg.FComponent;
import com.archimed.codec.jpeg.HuffmanTable;
import com.archimed.codec.jpeg.HuffmanTableReader;
import com.archimed.codec.jpeg.SComponent;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.Jdt;
import com.archimed.log.JdtLogger;
import java.io.IOException;

public class Jpeg14Decoder {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomReader.class);
    private static final int FIVE_SEVEN = 57;
    private static final int ONE = 1;
    private static final int OXFF = 255;
    private static final int OXFF2 = 255;
    private static final byte OXFF2Byte = -1;
    private static final int OXFFFF = 65535;
    private static final int RST0 = 208;
    private static final int SOF3 = 195;
    private static final int SOI = 216;
    private static final int SOS = 218;
    private static final int ZERO = 0;
    private long bitbuffer;
    private int bitsleft = 0;
    private int bytecounter = 0;
    private byte c;
    private byte c2;
    int code;
    private DecompressInfo dcmprI = new DecompressInfo();
    int i;
    private byte[] inbuffer;
    int j;
    private int ns;
    private byte[] outbuffer;
    private int pixelcounter = 0;
    int temp;
    int value;
    private int width;
    private int height;
    private int precision;
    private static final int APP0 = 224;
    private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private static final int DHT = 196;
    private static final int DRI = 221;
    private static final int EIGHT = 8;
    private static final int EOI = 217;
    private static final String ERROR_MESSAGE_BAD_HUFFMAN_CODE = "bad Huffman code";
    private static final int[] extendOffset = new int[]{0, -1, -3, -7, -15, -31, -63, -127, -255, -511, -1023, -2047, -4095, -8191, -16383, -32767};
    private static final int[] extendTest = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};

    public byte[] decode(byte[] inbuffer) throws IOException {
        this.bitsleft = 0;
        this.bitbuffer = 0L;
        this.bytecounter = 0;
        this.inbuffer = inbuffer;
        this.processMarkers();
        int size = this.precision > 8 ? this.width * this.height * this.ns * 2 : this.width * this.height * this.ns;
        this.outbuffer = new byte[size];
        this.processBytes();
        return this.outbuffer;
    }

    private void decodeFirstRow() throws IOException {
        int destination = 0;
        int diff = 0;
        int value = 0;
        for (int comp = 0; comp < this.ns; ++comp) {
            destination = this.dcmprI.scomps[comp].td;
            value = this.huffDecode(destination);
            if (value == 16) {
                diff = 32768;
            } else if (value != 0) {
                diff = this.get_bits(value);
                diff = this.extend(diff, value);
            } else {
                diff = 0;
            }
            if (this.precision > 8) {
                this.performanceTestLargePrecision(diff);
                continue;
            }
            this.performanceTestSmallPrecision(diff);
        }
        for (int col = 1; col < this.width; ++col) {
            for (int comp = 0; comp < this.ns; ++comp) {
                destination = this.dcmprI.scomps[comp].td;
                value = this.huffDecode(destination);
                if (value == 16) {
                    diff = 32768;
                } else if (value != 0) {
                    diff = this.get_bits(value);
                    diff = this.extend(diff, value);
                } else {
                    diff = 0;
                }
                if (this.precision > 8) {
                    this.performanceTestLargePrecisionTwo(diff);
                    continue;
                }
                this.performanceTestSmallPrecisionTwo(diff);
            }
        }
        if (this.dcmprI.restartInRows != 0) {
            --this.dcmprI.restartRowsToGo;
        }
    }

    private final int extend(int v, int t) {
        if (v < extendTest[t]) {
            return v + extendOffset[t];
        }
        return v;
    }

    private final void fillBitBuffer(int nbits) {
        while (this.bitsleft < 57) {
            if (this.bytecounter == this.inbuffer.length) {
                this.c = 0;
                break;
            }
            this.c = this.inbuffer[this.bytecounter++];
            if (this.c == -1) {
                this.c2 = this.inbuffer[this.bytecounter++];
                if (this.c2 != 0) {
                    this.bytecounter -= 2;
                    if (this.bitsleft >= nbits) break;
                    this.c = 0;
                }
            }
            this.bitbuffer = this.bitbuffer << 8 | (long)(this.c & 0xFF);
            this.bitsleft += 8;
        }
    }

    private final void flush_bits(int nbits) {
        this.bitsleft -= nbits;
    }

    private final int get_bit() {
        if (this.bitsleft == 0) {
            this.fillBitBuffer(1);
        }
        return (int)(this.bitbuffer >> --this.bitsleft) & 1;
    }

    private final int get_bits(int nbits) {
        if (this.bitsleft < nbits) {
            this.fillBitBuffer(nbits);
        }
        return (int)(this.bitbuffer >> (this.bitsleft -= nbits) & (long)bmask[nbits]);
    }

    private int get2Bytes(byte[] buffer, int position) {
        return (buffer[position] & 0xFF) + 256 * (buffer[position + 1] & 0xFF);
    }

    private final int getMarker() {
        int i = (this.inbuffer[this.bytecounter++] & 0xFF) << 8;
        return i += this.inbuffer[this.bytecounter++] & 0xFF;
    }

    private final void findFirstMarker() {
        while (this.inbuffer[this.bytecounter] != -1) {
            ++this.bytecounter;
        }
    }

    private int huffDecode(int destination) throws IOException {
        this.code = this.show_bits8();
        if (this.dcmprI.hts[destination].numbits[this.code] != 0) {
            this.performanceTestFlush(destination);
        } else {
            this.bitsleft -= 8;
            this.i = 8;
            this.performanceTestWhile(destination);
            if (this.i > 16) {
                throw new IOException(ERROR_MESSAGE_BAD_HUFFMAN_CODE);
            }
            this.performaceTestHts(destination);
        }
        return this.value;
    }

    private void performaceTestHts(int destination) {
        this.j = this.dcmprI.hts[destination].valptr[this.i];
        this.j += this.code - this.dcmprI.hts[destination].mincode[this.i];
        this.value = this.dcmprI.hts[destination].huffval[this.j];
    }

    private void performanceTestFirstForProcessBytes(int comp) throws IOException {
        int destination = this.dcmprI.scomps[comp].td;
        int value = this.huffDecode(destination);
        int diff = 0;
        if (value == 16) {
            diff = 32768;
        } else if (value != 0) {
            diff = this.get_bits(value);
            diff = this.extend(diff, value);
        }
        if (this.precision > 8) {
            byte pixvalue;
            this.outbuffer[this.pixelcounter] = pixvalue = (byte)(this.get2Bytes(this.outbuffer, this.pixelcounter - 2 * this.ns * this.width) + diff);
            this.outbuffer[this.pixelcounter + 1] = pixvalue = (byte)(this.get2Bytes(this.outbuffer, this.pixelcounter - 2 * this.ns * this.width) + diff >> 8);
            this.pixelcounter += 2;
        } else {
            byte pixvalue;
            this.outbuffer[this.pixelcounter] = pixvalue = (byte)((this.outbuffer[this.pixelcounter - this.ns * this.width] & 0xFF) + diff);
            ++this.pixelcounter;
        }
    }

    private void performanceTestFlush(int destination) {
        this.flush_bits(this.dcmprI.hts[destination].numbits[this.code]);
        this.value = this.dcmprI.hts[destination].value[this.code];
    }

    private void performanceTestLargePrecision(int diff) {
        byte pixvalue;
        this.outbuffer[this.pixelcounter] = pixvalue = (byte)((1 << this.precision - 1) + diff);
        this.outbuffer[this.pixelcounter + 1] = pixvalue = (byte)((1 << this.precision - 1) + diff >> 8);
        this.pixelcounter += 2;
    }

    private void performanceTestLargePrecisionFor(int diff) {
        byte pixvalue;
        int pixvalueInt = this.predict(this.get2Bytes(this.outbuffer, this.pixelcounter - 2 * this.ns), this.get2Bytes(this.outbuffer, this.pixelcounter - this.width * 2 * this.ns), this.get2Bytes(this.outbuffer, this.pixelcounter - this.width * 2 * this.ns - 2 * this.ns)) + diff;
        this.outbuffer[this.pixelcounter] = pixvalue = (byte)pixvalueInt;
        this.outbuffer[this.pixelcounter + 1] = pixvalue = (byte)(pixvalueInt >> 8);
        this.pixelcounter += 2;
    }

    private void performanceTestLargePrecisionTwo(int diff) {
        byte pixvalue;
        this.outbuffer[this.pixelcounter] = pixvalue = (byte)(this.get2Bytes(this.outbuffer, this.pixelcounter - 2 * this.ns) + diff);
        this.outbuffer[this.pixelcounter + 1] = pixvalue = (byte)(this.get2Bytes(this.outbuffer, this.pixelcounter - 2 * this.ns) + diff >> 8);
        this.pixelcounter += 2;
    }

    private void performanceTestSecondForProcessBytes(int comp) throws IOException {
        int value = this.huffDecode(this.dcmprI.scomps[comp].td);
        int diff = 0;
        if (value == 16) {
            diff = 32768;
        } else if (value != 0) {
            diff = this.get_bits(value);
            diff = this.extend(diff, value);
        }
        if (this.precision > 8) {
            this.performanceTestLargePrecisionFor(diff);
        } else {
            this.performanceTestSmallPrecisionFor(diff);
        }
    }

    private void performanceTestSmallPrecision(int diff) {
        byte pixvalue;
        this.outbuffer[this.pixelcounter] = pixvalue = (byte)((1 << this.precision - 1) + diff);
        ++this.pixelcounter;
    }

    private void performanceTestSmallPrecisionFor(int diff) {
        this.outbuffer[this.pixelcounter] = (byte)(this.predict(this.outbuffer[this.pixelcounter - this.ns] & 0xFF, this.outbuffer[this.pixelcounter - this.width * this.ns] & 0xFF, this.outbuffer[this.pixelcounter - this.width * this.ns - this.ns] & 0xFF) + diff);
        ++this.pixelcounter;
    }

    private void performanceTestSmallPrecisionTwo(int diff) {
        byte pixvalue;
        this.outbuffer[this.pixelcounter] = pixvalue = (byte)((this.outbuffer[this.pixelcounter - this.ns] & 0xFF) + diff);
        ++this.pixelcounter;
    }

    private void performanceTestWhile(int destination) {
        while (this.code > this.dcmprI.hts[destination].maxcode[this.i]) {
            this.temp = this.get_bit();
            this.code = this.code << 1 | this.temp;
            ++this.i;
            if (this.code == 65535) break;
            if (this.i != this.dcmprI.hts[destination].maxcode.length) continue;
            System.out.println("big problem");
        }
    }

    private int predict(int a, int b, int c) {
        switch (this.dcmprI.predictor) {
            case 0: {
                break;
            }
            case 1: {
                return a;
            }
            case 2: {
                return b;
            }
            case 3: {
                return c;
            }
            case 4: {
                return a + b - c;
            }
            case 5: {
                return a + (b - c >> 1);
            }
            case 6: {
                return b + (a - c >> 1);
            }
            case 7: {
                return a + b >> 1;
            }
        }
        return 0;
    }

    private void processBytes() throws IOException {
        this.pixelcounter = 0;
        this.dcmprI.restartRowsToGo = this.dcmprI.restartInRows = this.dcmprI.restartInterval / this.width;
        this.dcmprI.nextRestartNum = 0;
        this.decodeFirstRow();
        for (int row = 1; row < this.height; ++row) {
            if (row != 0 && this.dcmprI.restartInRows != 0) {
                if (this.dcmprI.restartRowsToGo == 0) {
                    this.processRestart();
                    this.decodeFirstRow();
                    continue;
                }
                --this.dcmprI.restartRowsToGo;
            }
            for (int comp = 0; comp < this.ns; ++comp) {
                this.performanceTestFirstForProcessBytes(comp);
            }
            for (int col = 1; col < this.width; ++col) {
                for (int comp = 0; comp < this.ns; ++comp) {
                    this.performanceTestSecondForProcessBytes(comp);
                }
            }
        }
    }

    private final void processMarkers() throws IOException {
        int i;
        this.findFirstMarker();
        int len = 0;
        int nf = 0;
        byte t = 0;
        byte c = 0;
        int marker = this.getMarker();
        if ((marker & 0xFF) != 216) {
            throw new IOException("Not a valid lossless JPEG file");
        }
        block6: do {
            marker = this.getMarker();
            switch (marker & 0xFF) {
                case 196: {
                    HuffmanTableReader htr = new HuffmanTableReader();
                    this.bytecounter = htr.read(this.inbuffer, this.bytecounter);
                    HuffmanTable[] tables = htr.getTables();
                    for (int ii = 0; ii < tables.length; ++ii) {
                        this.dcmprI.hts[tables[ii].destination] = tables[ii];
                    }
                    continue block6;
                }
                case 195: {
                    int i2;
                    len = this.getMarker();
                    this.precision = this.inbuffer[this.bytecounter++];
                    this.height = this.getMarker();
                    this.width = this.getMarker();
                    nf = this.inbuffer[this.bytecounter++];
                    this.dcmprI.fcomps = new FComponent[nf + 1];
                    for (i2 = 0; i2 < nf; ++i2) {
                        c = this.inbuffer[this.bytecounter++];
                        this.dcmprI.fcomps[c] = new FComponent();
                        t = this.inbuffer[this.bytecounter++];
                        this.dcmprI.fcomps[c].h = (t & 0xF0) >> 4;
                        this.dcmprI.fcomps[c].v = t & 0xF;
                        this.dcmprI.fcomps[c].tq = this.inbuffer[this.bytecounter++];
                    }
                    continue block6;
                }
                case 218: {
                    int i2;
                    len = this.getMarker();
                    this.ns = this.inbuffer[this.bytecounter++];
                    this.dcmprI.scomps = new SComponent[this.ns];
                    for (i2 = 0; i2 < this.ns; ++i2) {
                        c = this.inbuffer[this.bytecounter++];
                        this.dcmprI.scomps[i2] = new SComponent();
                        t = this.inbuffer[this.bytecounter++];
                        this.dcmprI.scomps[i2].td = (t & 0xF0) >> 4;
                        this.dcmprI.scomps[i2].ta = t & 0xF;
                    }
                    this.dcmprI.predictor = this.inbuffer[this.bytecounter++];
                    this.bytecounter += 2;
                    break;
                }
                case 221: {
                    len = this.getMarker();
                    this.dcmprI.restartInterval = this.getMarker();
                    break;
                }
                default: {
                    this.log.debug("Received unknown marker " + Integer.toHexString(marker) + ", trying to jump over");
                    len = this.getMarker();
                    this.bytecounter += len - 2;
                }
            }
        } while ((marker & 0xFF) != 218);
        HuffmanTable backupHuffmanTable = null;
        for (i = 0; i < this.dcmprI.hts.length; ++i) {
            if (this.dcmprI.hts[i] == null) continue;
            backupHuffmanTable = this.dcmprI.hts[i];
            break;
        }
        for (i = 0; i < this.dcmprI.hts.length; ++i) {
            if (this.dcmprI.hts[i] != null) continue;
            this.dcmprI.hts[i] = backupHuffmanTable;
        }
    }

    private void processRestart() throws IOException {
        int c;
        int nbytes = this.bitsleft / 8;
        this.bitsleft = 0;
        while (true) {
            if ((c = this.inbuffer[this.bytecounter++] & 0xFF) != 255) {
                continue;
            }
            while ((c = this.inbuffer[this.bytecounter++] & 0xFF) == 255) {
            }
            if (c != 0) break;
        }
        if (c != 208 + this.dcmprI.nextRestartNum) {
            throw new IOException("messed up restart markers");
        }
        this.dcmprI.restartRowsToGo = this.dcmprI.restartInRows;
        this.dcmprI.nextRestartNum = this.dcmprI.nextRestartNum + 1 & 7;
    }

    private final int show_bits8() {
        if (this.bitsleft < 8) {
            this.fillBitBuffer(8);
        }
        return (int)(this.bitbuffer >> this.bitsleft - 8 & 0xFFL);
    }
}

