/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.Extension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = debug != null && Debug.isOn("ocsp");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private static final int DEFAULT_MAX_CLOCK_SKEW = 900000;
    private static final int MAX_CLOCK_SKEW = OCSPResponse.initializeClockSkew();
    private static CRLReason[] values = CRLReason.values();
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private final AlgorithmId sigAlgId;
    private final byte[] signature;
    private final byte[] tbsResponseData;
    private final byte[] responseNonce;
    private List<X509CertImpl> certs;
    private X509CertImpl signerCert = null;
    private X500Principal responderName = null;
    private KeyIdentifier responderKeyId = null;

    private static int initializeClockSkew() {
        Integer tmp = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.clockSkew"));
        if (tmp == null || tmp < 0) {
            return 900000;
        }
        return tmp * 1000;
    }

    OCSPResponse(byte[] bytes) throws IOException {
        short tag;
        if (dump) {
            HexDumpEncoder hexEnc = new HexDumpEncoder();
            debug.println("OCSPResponse bytes...\n\n" + hexEnc.encode(bytes) + "\n");
        }
        DerValue der = new DerValue(bytes);
        if (der.tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derIn = der.getData();
        int status = derIn.getEnumerated();
        if (status < 0 || status >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + status);
        }
        this.responseStatus = rsvalues[status];
        if (debug != null) {
            debug.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            this.certs = new ArrayList<X509CertImpl>();
            this.sigAlgId = null;
            this.signature = null;
            this.tbsResponseData = null;
            this.responseNonce = null;
            return;
        }
        der = derIn.getDerValue();
        if (!der.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue tmp = der.data.getDerValue();
        if (tmp.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derIn = tmp.data;
        ObjectIdentifier responseType = derIn.getOID();
        if (responseType.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (debug != null) {
                debug.println("OCSP response type: basic");
            }
        } else {
            if (debug != null) {
                debug.println("OCSP response type: " + responseType);
            }
            throw new IOException("Unsupported OCSP response type: " + responseType);
        }
        DerInputStream basicOCSPResponse = new DerInputStream(derIn.getOctetString());
        DerValue[] seqTmp = basicOCSPResponse.getSequence(2);
        if (seqTmp.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue responseData = seqTmp[0];
        this.tbsResponseData = seqTmp[0].toByteArray();
        if (responseData.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream seqDerIn = responseData.data;
        DerValue seq = seqDerIn.getDerValue();
        if (seq.isContextSpecific((byte)0) && seq.isConstructed() && seq.isContextSpecific()) {
            seq = seq.data.getDerValue();
            int version = seq.getInteger();
            if (seq.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            seq = seqDerIn.getDerValue();
        }
        if ((tag = (short)((byte)(seq.tag & 0x1F))) == 1) {
            this.responderName = new X500Principal(seq.getData().toByteArray());
            if (debug != null) {
                debug.println("Responder's name: " + this.responderName);
            }
        } else if (tag == 2) {
            this.responderKeyId = new KeyIdentifier(seq.getData().getOctetString());
            if (debug != null) {
                debug.println("Responder's key ID: " + Debug.toString(this.responderKeyId.getIdentifier()));
            }
        } else {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
        }
        seq = seqDerIn.getDerValue();
        if (debug != null) {
            Date producedAtDate = seq.getGeneralizedTime();
            debug.println("OCSP response produced at: " + producedAtDate);
        }
        DerValue[] singleResponseDer = seqDerIn.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(singleResponseDer.length);
        if (debug != null) {
            debug.println("OCSP number of SingleResponses: " + singleResponseDer.length);
        }
        for (int i = 0; i < singleResponseDer.length; ++i) {
            SingleResponse singleResponse = new SingleResponse(singleResponseDer[i]);
            this.singleResponseMap.put(singleResponse.getCertId(), singleResponse);
        }
        byte[] nonce = null;
        if (seqDerIn.available() > 0 && (seq = seqDerIn.getDerValue()).isContextSpecific((byte)1)) {
            DerValue[] responseExtDer = seq.data.getSequence(3);
            for (int i = 0; i < responseExtDer.length; ++i) {
                Extension ext = new Extension(responseExtDer[i]);
                if (debug != null) {
                    debug.println("OCSP extension: " + ext);
                }
                if (ext.getExtensionId().equals((Object)OCSP.NONCE_EXTENSION_OID)) {
                    nonce = ext.getExtensionValue();
                    continue;
                }
                if (!ext.isCritical()) continue;
                throw new IOException("Unsupported OCSP critical extension: " + ext.getExtensionId());
            }
        }
        this.responseNonce = nonce;
        this.sigAlgId = AlgorithmId.parse(seqTmp[1]);
        this.signature = seqTmp[2].getBitString();
        if (seqTmp.length > 3) {
            DerValue seqCert = seqTmp[3];
            if (!seqCert.isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            DerValue[] derCerts = seqCert.getData().getSequence(3);
            this.certs = new ArrayList<X509CertImpl>(derCerts.length);
            try {
                for (int i = 0; i < derCerts.length; ++i) {
                    X509CertImpl cert = new X509CertImpl(derCerts[i].toByteArray());
                    this.certs.add(cert);
                    if (debug == null) continue;
                    debug.println("OCSP response cert #" + (i + 1) + ": " + cert.getSubjectX500Principal());
                }
            }
            catch (CertificateException ce) {
                throw new IOException("Bad encoding in X509 Certificate", ce);
            }
        } else {
            this.certs = new ArrayList<X509CertImpl>();
        }
    }

    void verify(List<CertId> certIds, X509Certificate issuerCert, X509Certificate responderCert, Date date, byte[] nonce) throws CertPathValidatorException {
        switch (this.responseStatus) {
            case SUCCESSFUL: {
                break;
            }
            case TRY_LATER: 
            case INTERNAL_ERROR: {
                throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)this.responseStatus), null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
            }
            default: {
                throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)this.responseStatus));
            }
        }
        for (CertId certId : certIds) {
            SingleResponse sr = this.getSingleResponse(certId);
            if (sr == null) {
                if (debug != null) {
                    debug.println("No response found for CertId: " + certId);
                }
                throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
            }
            if (debug == null) continue;
            debug.println("Status of certificate (with serial number " + certId.getSerialNumber() + ") is: " + (Object)((Object)sr.getCertStatus()));
        }
        if (this.signerCert == null) {
            try {
                this.certs.add(X509CertImpl.toImpl(issuerCert));
                if (responderCert != null) {
                    this.certs.add(X509CertImpl.toImpl(responderCert));
                }
            }
            catch (CertificateException ce) {
                throw new CertPathValidatorException("Invalid issuer or trusted responder certificate", ce);
            }
            if (this.responderName != null) {
                for (X509CertImpl cert : this.certs) {
                    if (!cert.getSubjectX500Principal().equals(this.responderName)) continue;
                    this.signerCert = cert;
                    break;
                }
            } else if (this.responderKeyId != null) {
                for (X509CertImpl cert : this.certs) {
                    KeyIdentifier certKeyId = cert.getSubjectKeyId();
                    if (certKeyId != null && this.responderKeyId.equals(certKeyId)) {
                        this.signerCert = cert;
                        break;
                    }
                    try {
                        certKeyId = new KeyIdentifier(cert.getPublicKey());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!this.responderKeyId.equals(certKeyId)) continue;
                    this.signerCert = cert;
                    break;
                }
            }
        }
        if (this.signerCert != null) {
            if (this.signerCert.equals(issuerCert)) {
                if (debug != null) {
                    debug.println("OCSP response is signed by the target's Issuing CA");
                }
            } else if (this.signerCert.equals(responderCert)) {
                if (debug != null) {
                    debug.println("OCSP response is signed by a Trusted Responder");
                }
            } else if (this.signerCert.getIssuerX500Principal().equals(issuerCert.getSubjectX500Principal())) {
                try {
                    List<String> keyPurposes = this.signerCert.getExtendedKeyUsage();
                    if (keyPurposes == null || !keyPurposes.contains(KP_OCSP_SIGNING_OID)) {
                        throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                    }
                }
                catch (CertificateParsingException cpe) {
                    throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses", cpe);
                }
                AlgorithmChecker algChecker = new AlgorithmChecker(new TrustAnchor(issuerCert, null));
                algChecker.init(false);
                algChecker.check(this.signerCert, Collections.emptySet());
                try {
                    if (date == null) {
                        this.signerCert.checkValidity();
                    } else {
                        this.signerCert.checkValidity(date);
                    }
                }
                catch (CertificateException e) {
                    throw new CertPathValidatorException("Responder's certificate not within the validity period", e);
                }
                Extension noCheck = this.signerCert.getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (noCheck != null && debug != null) {
                    debug.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    this.signerCert.verify(issuerCert.getPublicKey());
                    if (debug != null) {
                        debug.println("OCSP response is signed by an Authorized Responder");
                    }
                }
                catch (GeneralSecurityException e) {
                    this.signerCert = null;
                }
            } else {
                throw new CertPathValidatorException("Responder's certificate is not authorized to sign OCSP responses");
            }
        }
        if (this.signerCert != null) {
            AlgorithmChecker.check(this.signerCert.getPublicKey(), this.sigAlgId);
            if (!this.verifySignature(this.signerCert)) {
                throw new CertPathValidatorException("Error verifying OCSP Response's signature");
            }
        } else {
            throw new CertPathValidatorException("Unable to verify OCSP Response's signature");
        }
        if (nonce != null && this.responseNonce != null && !Arrays.equals(nonce, this.responseNonce)) {
            throw new CertPathValidatorException("Nonces don't match");
        }
        long now = date == null ? System.currentTimeMillis() : date.getTime();
        Date nowPlusSkew = new Date(now + (long)MAX_CLOCK_SKEW);
        Date nowMinusSkew = new Date(now - (long)MAX_CLOCK_SKEW);
        for (SingleResponse sr : this.singleResponseMap.values()) {
            if (debug != null) {
                String until = "";
                if (sr.nextUpdate != null) {
                    until = " until " + sr.nextUpdate;
                }
                debug.println("OCSP response validity interval is from " + sr.thisUpdate + until);
                debug.println("Checking validity of OCSP response on: " + new Date(now));
            }
            if (!nowPlusSkew.before(sr.thisUpdate) && !nowMinusSkew.after(sr.nextUpdate != null ? sr.nextUpdate : sr.thisUpdate)) continue;
            throw new CertPathValidatorException("Response is unreliable: its validity interval is out-of-date");
        }
    }

    ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifySignature(X509Certificate cert) throws CertPathValidatorException {
        try {
            Signature respSignature = Signature.getInstance(this.sigAlgId.getName());
            respSignature.initVerify(cert.getPublicKey());
            respSignature.update(this.tbsResponseData);
            if (respSignature.verify(this.signature)) {
                if (debug != null) {
                    debug.println("Verified signature of OCSP Response");
                }
                return true;
            }
            if (debug != null) {
                debug.println("Error verifying signature of OCSP Response");
            }
            return false;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new CertPathValidatorException(e);
        }
    }

    SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    X509Certificate getSignerCertificate() {
        return this.signerCert;
    }

    static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private final CRLReason revocationReason;
        private final Map<String, java.security.cert.Extension> singleExtensions;

        private SingleResponse(DerValue der) throws IOException {
            if (der.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream tmp = der.data;
            this.certId = new CertId(tmp.getDerValue().data);
            DerValue derVal = tmp.getDerValue();
            short tag = (byte)(derVal.tag & 0x1F);
            if (tag == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derVal.data.getGeneralizedTime();
                if (derVal.data.available() != 0) {
                    int reason;
                    DerValue dv = derVal.data.getDerValue();
                    tag = (byte)(dv.tag & 0x1F);
                    this.revocationReason = tag == 0 ? ((reason = dv.data.getEnumerated()) >= 0 && reason < values.length ? values[reason] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (debug != null) {
                    debug.println("Revocation time: " + this.revocationTime);
                    debug.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = CRLReason.UNSPECIFIED;
                if (tag == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (tag == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = tmp.getGeneralizedTime();
            if (tmp.available() == 0) {
                this.nextUpdate = null;
            } else {
                derVal = tmp.getDerValue();
                tag = (byte)(derVal.tag & 0x1F);
                if (tag == 0) {
                    this.nextUpdate = derVal.data.getGeneralizedTime();
                    if (tmp.available() != 0) {
                        derVal = tmp.getDerValue();
                        tag = (byte)(derVal.tag & 0x1F);
                    }
                } else {
                    this.nextUpdate = null;
                }
            }
            if (tmp.available() > 0) {
                derVal = tmp.getDerValue();
                if (derVal.isContextSpecific((byte)1)) {
                    DerValue[] singleExtDer = derVal.data.getSequence(3);
                    this.singleExtensions = new HashMap<String, java.security.cert.Extension>(singleExtDer.length);
                    for (int i = 0; i < singleExtDer.length; ++i) {
                        Extension ext = new Extension(singleExtDer[i]);
                        if (debug != null) {
                            debug.println("OCSP single extension: " + ext);
                        }
                        if (ext.isCritical()) {
                            throw new IOException("Unsupported OCSP critical extension: " + ext.getExtensionId());
                        }
                        this.singleExtensions.put(ext.getId(), ext);
                    }
                } else {
                    this.singleExtensions = Collections.emptyMap();
                }
            } else {
                this.singleExtensions = Collections.emptyMap();
            }
        }

        @Override
        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        @Override
        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        @Override
        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public Map<String, java.security.cert.Extension> getSingleExtensions() {
            return Collections.unmodifiableMap(this.singleExtensions);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SingleResponse:  \n");
            sb.append(this.certId);
            sb.append("\nCertStatus: " + (Object)((Object)this.certStatus) + "\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                sb.append("revocationTime is " + this.revocationTime + "\n");
                sb.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            sb.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                sb.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return sb.toString();
        }
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

