/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;

public final class AnnotatedTypeFactory {
    static final AnnotatedType EMPTY_ANNOTATED_TYPE = new AnnotatedTypeBaseImpl(null, TypeAnnotation.LocationInfo.BASE_LOCATION, new TypeAnnotation[0], new TypeAnnotation[0], null);
    static final AnnotatedType[] EMPTY_ANNOTATED_TYPE_ARRAY = new AnnotatedType[0];

    public static AnnotatedType buildAnnotatedType(Type type, TypeAnnotation.LocationInfo currentLoc, TypeAnnotation[] actualTypeAnnos, TypeAnnotation[] allOnSameTarget, AnnotatedElement decl) {
        if (type == null) {
            return EMPTY_ANNOTATED_TYPE;
        }
        if (AnnotatedTypeFactory.isArray(type)) {
            return new AnnotatedArrayTypeImpl(type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof Class) {
            return new AnnotatedTypeBaseImpl(type, AnnotatedTypeFactory.addNesting(type, currentLoc), actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof TypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof ParameterizedType) {
            return new AnnotatedParameterizedTypeImpl((ParameterizedType)type, AnnotatedTypeFactory.addNesting(type, currentLoc), actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof WildcardType) {
            return new AnnotatedWildcardTypeImpl((WildcardType)type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        throw new AssertionError((Object)("Unknown instance of Type: " + type + "\nThis should not happen."));
    }

    private static TypeAnnotation.LocationInfo addNesting(Type type, TypeAnnotation.LocationInfo addTo) {
        if (AnnotatedTypeFactory.isArray(type)) {
            return addTo;
        }
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (clz.getEnclosingClass() == null) {
                return addTo;
            }
            if (Modifier.isStatic(clz.getModifiers())) {
                return AnnotatedTypeFactory.addNesting(clz.getEnclosingClass(), addTo);
            }
            return AnnotatedTypeFactory.addNesting(clz.getEnclosingClass(), addTo.pushInner());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            if (t.getOwnerType() == null) {
                return addTo;
            }
            return AnnotatedTypeFactory.addNesting(t.getOwnerType(), addTo.pushInner());
        }
        return addTo;
    }

    private static boolean isArray(Type t) {
        Class c;
        return t instanceof Class ? (c = (Class)t).isArray() : t instanceof GenericArrayType;
    }

    private static final class AnnotatedWildcardTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedWildcardType {
        private final boolean hasUpperBounds;

        AnnotatedWildcardTypeImpl(WildcardType type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
            this.hasUpperBounds = type.getLowerBounds().length == 0;
        }

        @Override
        public AnnotatedType[] getAnnotatedUpperBounds() {
            if (!this.hasUpperBounds()) {
                return new AnnotatedType[0];
            }
            return this.getAnnotatedBounds(this.getWildcardType().getUpperBounds());
        }

        @Override
        public AnnotatedType[] getAnnotatedLowerBounds() {
            if (this.hasUpperBounds) {
                return new AnnotatedType[0];
            }
            return this.getAnnotatedBounds(this.getWildcardType().getLowerBounds());
        }

        private AnnotatedType[] getAnnotatedBounds(Type[] bounds) {
            Object[] res = new AnnotatedType[bounds.length];
            Arrays.fill(res, EMPTY_ANNOTATED_TYPE);
            TypeAnnotation.LocationInfo newLoc = this.getLocation().pushWildcard();
            int initialCapacity = this.getTypeAnnotations().length;
            for (int i = 0; i < res.length; ++i) {
                ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(initialCapacity);
                for (TypeAnnotation t : this.getTypeAnnotations()) {
                    if (!t.getLocationInfo().isSameLocationInfo(newLoc)) continue;
                    l.add(t);
                }
                res[i] = AnnotatedTypeFactory.buildAnnotatedType(bounds[i], newLoc, l.toArray(new TypeAnnotation[0]), this.getTypeAnnotations(), this.getDecl());
            }
            return res;
        }

        private WildcardType getWildcardType() {
            return (WildcardType)this.getType();
        }

        private boolean hasUpperBounds() {
            return this.hasUpperBounds;
        }
    }

    private static final class AnnotatedParameterizedTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedParameterizedType {
        AnnotatedParameterizedTypeImpl(ParameterizedType type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
        }

        @Override
        public AnnotatedType[] getAnnotatedActualTypeArguments() {
            Type[] arguments = this.getParameterizedType().getActualTypeArguments();
            Object[] res = new AnnotatedType[arguments.length];
            Arrays.fill(res, EMPTY_ANNOTATED_TYPE);
            int initialCapacity = this.getTypeAnnotations().length;
            for (int i = 0; i < res.length; ++i) {
                ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(initialCapacity);
                TypeAnnotation.LocationInfo newLoc = this.getLocation().pushTypeArg((byte)i);
                for (TypeAnnotation t : this.getTypeAnnotations()) {
                    if (!t.getLocationInfo().isSameLocationInfo(newLoc)) continue;
                    l.add(t);
                }
                res[i] = AnnotatedTypeFactory.buildAnnotatedType(arguments[i], newLoc, l.toArray(new TypeAnnotation[0]), this.getTypeAnnotations(), this.getDecl());
            }
            return res;
        }

        private ParameterizedType getParameterizedType() {
            return (ParameterizedType)this.getType();
        }
    }

    private static final class AnnotatedTypeVariableImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedTypeVariable {
        AnnotatedTypeVariableImpl(TypeVariable<?> type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            return this.getTypeVariable().getAnnotatedBounds();
        }

        private TypeVariable<?> getTypeVariable() {
            return (TypeVariable)this.getType();
        }
    }

    private static final class AnnotatedArrayTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedArrayType {
        AnnotatedArrayTypeImpl(Type type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
        }

        @Override
        public AnnotatedType getAnnotatedGenericComponentType() {
            return AnnotatedTypeFactory.buildAnnotatedType(this.getComponentType(), this.getLocation().pushArray(), this.getTypeAnnotations(), this.getTypeAnnotations(), this.getDecl());
        }

        private Type getComponentType() {
            Type t = this.getType();
            if (t instanceof Class) {
                Class c = (Class)t;
                return c.getComponentType();
            }
            return ((GenericArrayType)t).getGenericComponentType();
        }
    }

    private static class AnnotatedTypeBaseImpl
    implements AnnotatedType {
        private final Type type;
        private final AnnotatedElement decl;
        private final TypeAnnotation.LocationInfo location;
        private final TypeAnnotation[] allOnSameTargetTypeAnnotations;
        private final Map<Class<? extends Annotation>, Annotation> annotations;

        AnnotatedTypeBaseImpl(Type type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            this.type = type;
            this.decl = decl;
            this.location = location;
            this.allOnSameTargetTypeAnnotations = allOnSameTargetTypeAnnotations;
            this.annotations = TypeAnnotationParser.mapTypeAnnotations(location.filter(actualTypeAnnotations));
        }

        @Override
        public final Annotation[] getAnnotations() {
            return this.getDeclaredAnnotations();
        }

        @Override
        public final <T extends Annotation> T getAnnotation(Class<T> annotation) {
            return this.getDeclaredAnnotation(annotation);
        }

        @Override
        public final <T extends Annotation> T[] getAnnotationsByType(Class<T> annotation) {
            return this.getDeclaredAnnotationsByType(annotation);
        }

        @Override
        public final Annotation[] getDeclaredAnnotations() {
            return this.annotations.values().toArray(new Annotation[0]);
        }

        @Override
        public final <T extends Annotation> T getDeclaredAnnotation(Class<T> annotation) {
            return (T)this.annotations.get(annotation);
        }

        @Override
        public final <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotation) {
            return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.annotations, annotation);
        }

        @Override
        public final Type getType() {
            return this.type;
        }

        final TypeAnnotation.LocationInfo getLocation() {
            return this.location;
        }

        final TypeAnnotation[] getTypeAnnotations() {
            return this.allOnSameTargetTypeAnnotations;
        }

        final AnnotatedElement getDecl() {
            return this.decl;
        }
    }
}

