/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ObjectInputStream;
import java.io.SerializablePermission;
import java.security.AccessController;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

@FunctionalInterface
public interface ObjectInputFilter {
    public Status checkInput(FilterInfo var1);

    public static final class Config {
        private static final Object serialFilterLock = new Object();
        private static final PlatformLogger configLog;
        private static final String SERIAL_FILTER_PROPNAME = "jdk.serialFilter";
        private static final ObjectInputFilter configuredFilter;
        private static ObjectInputFilter serialFilter;

        private Config() {
        }

        static void filterLog(PlatformLogger.Level level, String msg, Object ... args) {
            if (configLog != null) {
                if (PlatformLogger.Level.INFO.equals((Object)level)) {
                    configLog.info(msg, args);
                } else if (PlatformLogger.Level.WARNING.equals((Object)level)) {
                    configLog.warning(msg, args);
                } else {
                    configLog.severe(msg, args);
                }
            }
        }

        public static ObjectInputFilter getObjectInputFilter(ObjectInputStream inputStream) {
            Objects.requireNonNull(inputStream, "inputStream");
            return SharedSecrets.getJavaOISAccess().getObjectInputFilter(inputStream);
        }

        public static void setObjectInputFilter(ObjectInputStream inputStream, ObjectInputFilter filter) {
            Objects.requireNonNull(inputStream, "inputStream");
            SharedSecrets.getJavaOISAccess().setObjectInputFilter(inputStream, filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectInputFilter getSerialFilter() {
            Object object = serialFilterLock;
            synchronized (object) {
                return serialFilter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setSerialFilter(ObjectInputFilter filter) {
            Objects.requireNonNull(filter, "filter");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new SerializablePermission("serialFilter"));
            }
            Object object = serialFilterLock;
            synchronized (object) {
                if (serialFilter != null) {
                    throw new IllegalStateException("Serial filter can only be set once");
                }
                serialFilter = filter;
            }
        }

        public static ObjectInputFilter createFilter(String pattern) {
            Objects.requireNonNull(pattern, "pattern");
            return Global.createFilter(pattern);
        }

        static {
            configuredFilter = AccessController.doPrivileged(() -> {
                String props = System.getProperty(SERIAL_FILTER_PROPNAME);
                if (props == null) {
                    props = Security.getProperty(SERIAL_FILTER_PROPNAME);
                }
                if (props != null) {
                    PlatformLogger log = PlatformLogger.getLogger("java.io.serialization");
                    log.info("Creating serialization filter from {0}", props);
                    try {
                        return Config.createFilter(props);
                    }
                    catch (RuntimeException re) {
                        log.warning("Error configuring filter: {0}", re);
                    }
                }
                return null;
            });
            configLog = configuredFilter != null ? PlatformLogger.getLogger("java.io.serialization") : null;
            serialFilter = configuredFilter;
        }

        static final class Global
        implements ObjectInputFilter {
            private final String pattern;
            private final List<Function<Class<?>, Status>> filters;
            private long maxStreamBytes;
            private long maxDepth;
            private long maxReferences;
            private long maxArrayLength;

            static ObjectInputFilter createFilter(String pattern) {
                Global filter = new Global(pattern);
                return filter.isEmpty() ? null : filter;
            }

            private Global(String pattern) {
                this.pattern = pattern;
                this.maxArrayLength = Long.MAX_VALUE;
                this.maxDepth = Long.MAX_VALUE;
                this.maxReferences = Long.MAX_VALUE;
                this.maxStreamBytes = Long.MAX_VALUE;
                String[] patterns = pattern.split(";");
                this.filters = new ArrayList(patterns.length);
                for (int i = 0; i < patterns.length; ++i) {
                    boolean negate;
                    String p = patterns[i];
                    int nameLen = p.length();
                    if (nameLen == 0 || this.parseLimit(p)) continue;
                    boolean bl = negate = p.charAt(0) == '!';
                    if (p.indexOf(47) >= 0) {
                        throw new IllegalArgumentException("invalid character \"/\" in: \"" + pattern + "\"");
                    }
                    if (p.endsWith("*")) {
                        if (p.endsWith(".*")) {
                            String pkg = p.substring(negate ? 1 : 0, nameLen - 1);
                            if (pkg.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + pattern + "\"");
                            }
                            if (negate) {
                                this.filters.add(c -> Global.matchesPackage(c, pkg) ? Status.REJECTED : Status.UNDECIDED);
                                continue;
                            }
                            this.filters.add(c -> Global.matchesPackage(c, pkg) ? Status.ALLOWED : Status.UNDECIDED);
                            continue;
                        }
                        if (p.endsWith(".**")) {
                            String pkgs = p.substring(negate ? 1 : 0, nameLen - 2);
                            if (pkgs.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + pattern + "\"");
                            }
                            if (negate) {
                                this.filters.add(c -> c.getName().startsWith(pkgs) ? Status.REJECTED : Status.UNDECIDED);
                                continue;
                            }
                            this.filters.add(c -> c.getName().startsWith(pkgs) ? Status.ALLOWED : Status.UNDECIDED);
                            continue;
                        }
                        String className = p.substring(negate ? 1 : 0, nameLen - 1);
                        if (negate) {
                            this.filters.add(c -> c.getName().startsWith(className) ? Status.REJECTED : Status.UNDECIDED);
                            continue;
                        }
                        this.filters.add(c -> c.getName().startsWith(className) ? Status.ALLOWED : Status.UNDECIDED);
                        continue;
                    }
                    String name = p.substring(negate ? 1 : 0);
                    if (name.isEmpty()) {
                        throw new IllegalArgumentException("class or package missing in: \"" + pattern + "\"");
                    }
                    if (negate) {
                        this.filters.add(c -> c.getName().equals(name) ? Status.REJECTED : Status.UNDECIDED);
                        continue;
                    }
                    this.filters.add(c -> c.getName().equals(name) ? Status.ALLOWED : Status.UNDECIDED);
                }
            }

            private boolean isEmpty() {
                return this.filters.isEmpty() && this.maxArrayLength == Long.MAX_VALUE && this.maxDepth == Long.MAX_VALUE && this.maxReferences == Long.MAX_VALUE && this.maxStreamBytes == Long.MAX_VALUE;
            }

            private boolean parseLimit(String pattern) {
                int eqNdx = pattern.indexOf(61);
                if (eqNdx < 0) {
                    return false;
                }
                String valueString = pattern.substring(eqNdx + 1);
                if (pattern.startsWith("maxdepth=")) {
                    this.maxDepth = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxarray=")) {
                    this.maxArrayLength = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxrefs=")) {
                    this.maxReferences = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxbytes=")) {
                    this.maxStreamBytes = Global.parseValue(valueString);
                } else {
                    throw new IllegalArgumentException("unknown limit: " + pattern.substring(0, eqNdx));
                }
                return true;
            }

            private static long parseValue(String string) throws IllegalArgumentException {
                long value = Long.parseLong(string);
                if (value < 0L) {
                    throw new IllegalArgumentException("negative limit: " + string);
                }
                return value;
            }

            @Override
            public Status checkInput(FilterInfo filterInfo) {
                if (filterInfo.references() < 0L || filterInfo.depth() < 0L || filterInfo.streamBytes() < 0L || filterInfo.references() > this.maxReferences || filterInfo.depth() > this.maxDepth || filterInfo.streamBytes() > this.maxStreamBytes) {
                    return Status.REJECTED;
                }
                Class<?> clazz = filterInfo.serialClass();
                if (clazz != null) {
                    if (clazz.isArray()) {
                        if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > this.maxArrayLength) {
                            return Status.REJECTED;
                        }
                        while ((clazz = clazz.getComponentType()).isArray()) {
                        }
                    }
                    if (clazz.isPrimitive()) {
                        return Status.UNDECIDED;
                    }
                    Class<?> cl = clazz;
                    Optional<Status> status = this.filters.stream().map(f -> (Status)((Object)((Object)f.apply(cl)))).filter(p -> p != Status.UNDECIDED).findFirst();
                    return status.orElse(Status.UNDECIDED);
                }
                return Status.UNDECIDED;
            }

            private static boolean matchesPackage(Class<?> c, String pkg) {
                String n = c.getName();
                return n.startsWith(pkg) && n.lastIndexOf(46) == pkg.length() - 1;
            }

            public String toString() {
                return this.pattern;
            }
        }
    }

    public static enum Status {
        UNDECIDED,
        ALLOWED,
        REJECTED;

    }

    public static interface FilterInfo {
        public Class<?> serialClass();

        public long arrayLength();

        public long depth();

        public long references();

        public long streamBytes();
    }
}

