/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderColumnInfo;
import sun.awt.shell.Win32ShellFolderManager2;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

final class Win32ShellFolder2
extends ShellFolder {
    public static final int DESKTOP = 0;
    public static final int INTERNET = 1;
    public static final int PROGRAMS = 2;
    public static final int CONTROLS = 3;
    public static final int PRINTERS = 4;
    public static final int PERSONAL = 5;
    public static final int FAVORITES = 6;
    public static final int STARTUP = 7;
    public static final int RECENT = 8;
    public static final int SENDTO = 9;
    public static final int BITBUCKET = 10;
    public static final int STARTMENU = 11;
    public static final int DESKTOPDIRECTORY = 16;
    public static final int DRIVES = 17;
    public static final int NETWORK = 18;
    public static final int NETHOOD = 19;
    public static final int FONTS = 20;
    public static final int TEMPLATES = 21;
    public static final int COMMON_STARTMENU = 22;
    public static final int COMMON_PROGRAMS = 23;
    public static final int COMMON_STARTUP = 24;
    public static final int COMMON_DESKTOPDIRECTORY = 25;
    public static final int APPDATA = 26;
    public static final int PRINTHOOD = 27;
    public static final int ALTSTARTUP = 29;
    public static final int COMMON_ALTSTARTUP = 30;
    public static final int COMMON_FAVORITES = 31;
    public static final int INTERNET_CACHE = 32;
    public static final int COOKIES = 33;
    public static final int HISTORY = 34;
    public static final int ATTRIB_CANCOPY = 1;
    public static final int ATTRIB_CANMOVE = 2;
    public static final int ATTRIB_CANLINK = 4;
    public static final int ATTRIB_CANRENAME = 16;
    public static final int ATTRIB_CANDELETE = 32;
    public static final int ATTRIB_HASPROPSHEET = 64;
    public static final int ATTRIB_DROPTARGET = 256;
    public static final int ATTRIB_LINK = 65536;
    public static final int ATTRIB_SHARE = 131072;
    public static final int ATTRIB_READONLY = 262144;
    public static final int ATTRIB_GHOSTED = 524288;
    public static final int ATTRIB_HIDDEN = 524288;
    public static final int ATTRIB_FILESYSANCESTOR = 0x10000000;
    public static final int ATTRIB_FOLDER = 0x20000000;
    public static final int ATTRIB_FILESYSTEM = 0x40000000;
    public static final int ATTRIB_HASSUBFOLDER = Integer.MIN_VALUE;
    public static final int ATTRIB_VALIDATE = 0x1000000;
    public static final int ATTRIB_REMOVABLE = 0x2000000;
    public static final int ATTRIB_COMPRESSED = 0x4000000;
    public static final int ATTRIB_BROWSABLE = 0x8000000;
    public static final int ATTRIB_NONENUMERATED = 0x100000;
    public static final int ATTRIB_NEWCONTENT = 0x200000;
    public static final int SHGDN_NORMAL = 0;
    public static final int SHGDN_INFOLDER = 1;
    public static final int SHGDN_INCLUDE_NONFILESYS = 8192;
    public static final int SHGDN_FORADDRESSBAR = 16384;
    public static final int SHGDN_FORPARSING = 32768;
    FolderDisposer disposer = new FolderDisposer();
    private long pIShellIcon = -1L;
    private String folderType = null;
    private String displayName = null;
    private Image smallIcon = null;
    private Image largeIcon = null;
    private Boolean isDir = null;
    private boolean isPersonal;
    private volatile Boolean cachedIsFileSystem;
    private volatile Boolean cachedIsLink;
    private static Map smallSystemImages;
    private static Map largeSystemImages;
    private static Map smallLinkedSystemImages;
    private static Map largeLinkedSystemImages;
    private static final int LVCFMT_LEFT = 0;
    private static final int LVCFMT_RIGHT = 1;
    private static final int LVCFMT_CENTER = 2;

    private static native void initIDs();

    private void setIShellFolder(long pIShellFolder) {
        this.disposer.pIShellFolder = pIShellFolder;
    }

    private void setRelativePIDL(long relativePIDL) {
        this.disposer.relativePIDL = relativePIDL;
    }

    private static String composePathForCsidl(int csidl) throws IOException, InterruptedException {
        String path = Win32ShellFolder2.getFileSystemPath(csidl);
        return path == null ? "ShellFolder: 0x" + Integer.toHexString(csidl) : path;
    }

    Win32ShellFolder2(final int csidl) throws IOException, InterruptedException {
        super((ShellFolder)null, Win32ShellFolder2.composePathForCsidl(csidl));
        Win32ShellFolder2.invoke(new Callable<Void>(){

            @Override
            public Void call() throws InterruptedException {
                if (csidl == 0) {
                    Win32ShellFolder2.this.initDesktop();
                } else {
                    long childPIDL;
                    Win32ShellFolder2.this.initSpecial(Win32ShellFolder2.this.getDesktop().getIShellFolder(), csidl);
                    long pIDL = Win32ShellFolder2.this.disposer.relativePIDL;
                    Win32ShellFolder2.this.parent = Win32ShellFolder2.this.getDesktop();
                    while (pIDL != 0L && (childPIDL = Win32ShellFolder2.copyFirstPIDLEntry(pIDL)) != 0L) {
                        if ((pIDL = Win32ShellFolder2.getNextPIDLEntry(pIDL)) != 0L) {
                            Win32ShellFolder2.this.parent = new Win32ShellFolder2((Win32ShellFolder2)Win32ShellFolder2.this.parent, childPIDL);
                            continue;
                        }
                        Win32ShellFolder2.this.disposer.relativePIDL = childPIDL;
                    }
                }
                return null;
            }
        }, InterruptedException.class);
        Disposer.addRecord(this, this.disposer);
    }

    Win32ShellFolder2(Win32ShellFolder2 parent, long pIShellFolder, long relativePIDL, String path) {
        super(parent, path != null ? path : "ShellFolder: ");
        this.disposer.pIShellFolder = pIShellFolder;
        this.disposer.relativePIDL = relativePIDL;
        Disposer.addRecord(this, this.disposer);
    }

    Win32ShellFolder2(Win32ShellFolder2 parent, final long relativePIDL) throws InterruptedException {
        super(parent, Win32ShellFolder2.invoke(new Callable<String>(){

            @Override
            public String call() {
                return Win32ShellFolder2.getFileSystemPath(Win32ShellFolder2.this.getIShellFolder(), relativePIDL);
            }
        }, RuntimeException.class));
        this.disposer.relativePIDL = relativePIDL;
        Disposer.addRecord(this, this.disposer);
    }

    private native void initDesktop();

    private native void initSpecial(long var1, int var3);

    public void setIsPersonal() {
        this.isPersonal = true;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return Win32ShellFolder2.invoke(new Callable<File>(){

            @Override
            public File call() {
                File[] driveRoots;
                if (Win32ShellFolder2.this.isFileSystem()) {
                    return new File(Win32ShellFolder2.this.getPath());
                }
                Win32ShellFolder2 drives = Win32ShellFolderManager2.getDrives();
                if (drives != null && (driveRoots = drives.listFiles()) != null) {
                    for (int i = 0; i < driveRoots.length; ++i) {
                        Win32ShellFolder2 sf;
                        if (!(driveRoots[i] instanceof Win32ShellFolder2) || !(sf = (Win32ShellFolder2)driveRoots[i]).isFileSystem() || sf.hasAttribute(0x2000000)) continue;
                        return new File(sf.getPath());
                    }
                }
                return new File("C:\\");
            }
        });
    }

    protected void dispose() {
        this.disposer.dispose();
    }

    static native long getNextPIDLEntry(long var0);

    static native long copyFirstPIDLEntry(long var0);

    private static native long combinePIDLs(long var0, long var2);

    static native void releasePIDL(long var0);

    private static native void releaseIShellFolder(long var0);

    private long getIShellFolder() {
        if (this.disposer.pIShellFolder == 0L) {
            try {
                this.disposer.pIShellFolder = Win32ShellFolder2.invoke(new Callable<Long>(){

                    @Override
                    public Long call() {
                        assert (Win32ShellFolder2.this.isDirectory());
                        assert (Win32ShellFolder2.this.parent != null);
                        long parentIShellFolder = Win32ShellFolder2.this.getParentIShellFolder();
                        if (parentIShellFolder == 0L) {
                            throw new InternalError("Parent IShellFolder was null for " + Win32ShellFolder2.this.getAbsolutePath());
                        }
                        long pIShellFolder = Win32ShellFolder2.bindToObject(parentIShellFolder, Win32ShellFolder2.this.disposer.relativePIDL);
                        if (pIShellFolder == 0L) {
                            throw new InternalError("Unable to bind " + Win32ShellFolder2.this.getAbsolutePath() + " to parent");
                        }
                        return pIShellFolder;
                    }
                }, RuntimeException.class);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.disposer.pIShellFolder;
    }

    public long getParentIShellFolder() {
        Win32ShellFolder2 parent = (Win32ShellFolder2)this.getParentFile();
        if (parent == null) {
            return this.getIShellFolder();
        }
        return parent.getIShellFolder();
    }

    public long getRelativePIDL() {
        if (this.disposer.relativePIDL == 0L) {
            throw new InternalError("Should always have a relative PIDL");
        }
        return this.disposer.relativePIDL;
    }

    private long getAbsolutePIDL() {
        if (this.parent == null) {
            return this.getRelativePIDL();
        }
        if (this.disposer.absolutePIDL == 0L) {
            this.disposer.absolutePIDL = Win32ShellFolder2.combinePIDLs(((Win32ShellFolder2)this.parent).getAbsolutePIDL(), this.getRelativePIDL());
        }
        return this.disposer.absolutePIDL;
    }

    public Win32ShellFolder2 getDesktop() {
        return Win32ShellFolderManager2.getDesktop();
    }

    public long getDesktopIShellFolder() {
        return this.getDesktop().getIShellFolder();
    }

    private static boolean pathsEqual(String path1, String path2) {
        return path1.equalsIgnoreCase(path2);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Win32ShellFolder2)) {
            if (!(o instanceof File)) {
                return super.equals(o);
            }
            return Win32ShellFolder2.pathsEqual(this.getPath(), ((File)o).getPath());
        }
        Win32ShellFolder2 rhs = (Win32ShellFolder2)o;
        if (this.parent == null && rhs.parent != null || this.parent != null && rhs.parent == null) {
            return false;
        }
        if (this.isFileSystem() && rhs.isFileSystem()) {
            return Win32ShellFolder2.pathsEqual(this.getPath(), rhs.getPath()) && (this.parent == rhs.parent || this.parent.equals(rhs.parent));
        }
        if (this.parent == rhs.parent || this.parent.equals(rhs.parent)) {
            try {
                return Win32ShellFolder2.pidlsEqual(this.getParentIShellFolder(), this.disposer.relativePIDL, rhs.disposer.relativePIDL);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return false;
    }

    private static boolean pidlsEqual(final long pIShellFolder, final long pidl1, final long pidl2) throws InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Win32ShellFolder2.compareIDs(pIShellFolder, pidl1, pidl2) == 0;
            }
        }, RuntimeException.class);
    }

    private static native int compareIDs(long var0, long var2, long var4);

    @Override
    public boolean isFileSystem() {
        if (this.cachedIsFileSystem == null) {
            this.cachedIsFileSystem = this.hasAttribute(0x40000000);
        }
        return this.cachedIsFileSystem;
    }

    public boolean hasAttribute(final int attribute) {
        Boolean result = Win32ShellFolder2.invoke(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return (Win32ShellFolder2.getAttributes0(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), attribute) & attribute) != 0;
            }
        });
        return result != null && result != false;
    }

    private static native int getAttributes0(long var0, long var2, int var4);

    private static String getFileSystemPath(long parentIShellFolder, long relativePIDL) {
        String s;
        int linkedFolder = 0x20010000;
        if (parentIShellFolder == Win32ShellFolderManager2.getNetwork().getIShellFolder() && Win32ShellFolder2.getAttributes0(parentIShellFolder, relativePIDL, linkedFolder) == linkedFolder && (s = Win32ShellFolder2.getFileSystemPath(Win32ShellFolderManager2.getDesktop().getIShellFolder(), Win32ShellFolder2.getLinkLocation(parentIShellFolder, relativePIDL, false))) != null && s.startsWith("\\\\")) {
            return s;
        }
        return Win32ShellFolder2.getDisplayNameOf(parentIShellFolder, relativePIDL, 32768);
    }

    static String getFileSystemPath(final int csidl) throws IOException, InterruptedException {
        SecurityManager security;
        String path = Win32ShellFolder2.invoke(new Callable<String>(){

            @Override
            public String call() throws IOException {
                return Win32ShellFolder2.getFileSystemPath0(csidl);
            }
        }, IOException.class);
        if (path != null && (security = System.getSecurityManager()) != null) {
            security.checkRead(path);
        }
        return path;
    }

    private static native String getFileSystemPath0(int var0) throws IOException;

    private static boolean isNetworkRoot(String path) {
        return path.equals("\\\\") || path.equals("\\") || path.equals("//") || path.equals("/");
    }

    @Override
    public File getParentFile() {
        return this.parent;
    }

    @Override
    public boolean isDirectory() {
        if (this.isDir == null) {
            ShellFolder linkLocation;
            this.isDir = this.hasAttribute(0x20000000) && !this.hasAttribute(0x8000000) ? Boolean.TRUE : (this.isLink() ? Boolean.valueOf((linkLocation = this.getLinkLocation(false)) != null && linkLocation.isDirectory()) : Boolean.FALSE);
        }
        return this.isDir;
    }

    private long getEnumObjects(final boolean includeHiddenFiles) throws InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Long>(){

            @Override
            public Long call() {
                boolean isDesktop = Win32ShellFolder2.this.disposer.pIShellFolder == Win32ShellFolder2.this.getDesktopIShellFolder();
                return Win32ShellFolder2.this.getEnumObjects(Win32ShellFolder2.this.disposer.pIShellFolder, isDesktop, includeHiddenFiles);
            }
        }, RuntimeException.class);
    }

    private native long getEnumObjects(long var1, boolean var3, boolean var4);

    private native long getNextChild(long var1);

    private native void releaseEnumObjects(long var1);

    private static native long bindToObject(long var0, long var2);

    @Override
    public File[] listFiles(final boolean includeHiddenFiles) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.getPath());
        }
        try {
            return Win32ShellFolder2.invoke(new Callable<File[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public File[] call() throws InterruptedException {
                    if (!Win32ShellFolder2.this.isDirectory()) {
                        return null;
                    }
                    if (Win32ShellFolder2.this.isLink() && !Win32ShellFolder2.this.hasAttribute(0x20000000)) {
                        return new File[0];
                    }
                    Win32ShellFolder2 desktop = Win32ShellFolderManager2.getDesktop();
                    Win32ShellFolder2 personal = Win32ShellFolderManager2.getPersonal();
                    long pIShellFolder = Win32ShellFolder2.this.getIShellFolder();
                    ArrayList<Win32ShellFolder2> list = new ArrayList<Win32ShellFolder2>();
                    long pEnumObjects = Win32ShellFolder2.this.getEnumObjects(includeHiddenFiles);
                    if (pEnumObjects != 0L) {
                        try {
                            long childPIDL;
                            int testedAttrs = 0x50000000;
                            do {
                                childPIDL = Win32ShellFolder2.this.getNextChild(pEnumObjects);
                                boolean releasePIDL = true;
                                if (childPIDL != 0L && (Win32ShellFolder2.getAttributes0(pIShellFolder, childPIDL, testedAttrs) & testedAttrs) != 0) {
                                    Win32ShellFolder2 childFolder;
                                    if (Win32ShellFolder2.this.equals(desktop) && personal != null && Win32ShellFolder2.pidlsEqual(pIShellFolder, childPIDL, personal.disposer.relativePIDL)) {
                                        childFolder = personal;
                                    } else {
                                        childFolder = new Win32ShellFolder2(Win32ShellFolder2.this, childPIDL);
                                        releasePIDL = false;
                                    }
                                    list.add(childFolder);
                                }
                                if (!releasePIDL) continue;
                                Win32ShellFolder2.releasePIDL(childPIDL);
                            } while (childPIDL != 0L && !Thread.currentThread().isInterrupted());
                        }
                        finally {
                            Win32ShellFolder2.this.releaseEnumObjects(pEnumObjects);
                        }
                    }
                    return Thread.currentThread().isInterrupted() ? new File[]{} : (File[])list.toArray(new ShellFolder[list.size()]);
                }
            }, InterruptedException.class);
        }
        catch (InterruptedException e) {
            return new File[0];
        }
    }

    Win32ShellFolder2 getChildByPath(final String filePath) throws InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Win32ShellFolder2>(){

            @Override
            public Win32ShellFolder2 call() throws InterruptedException {
                long childPIDL;
                long pIShellFolder = Win32ShellFolder2.this.getIShellFolder();
                long pEnumObjects = Win32ShellFolder2.this.getEnumObjects(true);
                Win32ShellFolder2 child = null;
                while ((childPIDL = Win32ShellFolder2.this.getNextChild(pEnumObjects)) != 0L) {
                    String path;
                    if (Win32ShellFolder2.getAttributes0(pIShellFolder, childPIDL, 0x40000000) != 0 && (path = Win32ShellFolder2.getFileSystemPath(pIShellFolder, childPIDL)) != null && path.equalsIgnoreCase(filePath)) {
                        long childIShellFolder = Win32ShellFolder2.bindToObject(pIShellFolder, childPIDL);
                        child = new Win32ShellFolder2(Win32ShellFolder2.this, childIShellFolder, childPIDL, path);
                        break;
                    }
                    Win32ShellFolder2.releasePIDL(childPIDL);
                }
                Win32ShellFolder2.this.releaseEnumObjects(pEnumObjects);
                return child;
            }
        }, InterruptedException.class);
    }

    @Override
    public boolean isLink() {
        if (this.cachedIsLink == null) {
            this.cachedIsLink = this.hasAttribute(65536);
        }
        return this.cachedIsLink;
    }

    @Override
    public boolean isHidden() {
        return this.hasAttribute(524288);
    }

    private static native long getLinkLocation(long var0, long var2, boolean var4);

    @Override
    public ShellFolder getLinkLocation() {
        return this.getLinkLocation(true);
    }

    private ShellFolder getLinkLocation(final boolean resolve) {
        return Win32ShellFolder2.invoke(new Callable<ShellFolder>(){

            @Override
            public ShellFolder call() {
                if (!Win32ShellFolder2.this.isLink()) {
                    return null;
                }
                Win32ShellFolder2 location = null;
                long linkLocationPIDL = Win32ShellFolder2.getLinkLocation(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), resolve);
                if (linkLocationPIDL != 0L) {
                    try {
                        location = Win32ShellFolderManager2.createShellFolderFromRelativePIDL(Win32ShellFolder2.this.getDesktop(), linkLocationPIDL);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InternalError internalError) {
                        // empty catch block
                    }
                }
                return location;
            }
        });
    }

    long parseDisplayName(final String name) throws IOException, InterruptedException {
        return Win32ShellFolder2.invoke(new Callable<Long>(){

            @Override
            public Long call() throws IOException {
                return Win32ShellFolder2.parseDisplayName0(Win32ShellFolder2.this.getIShellFolder(), name);
            }
        }, IOException.class);
    }

    private static native long parseDisplayName0(long var0, String var2) throws IOException;

    private static native String getDisplayNameOf(long var0, long var2, int var4);

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Win32ShellFolder2.invoke(new Callable<String>(){

                @Override
                public String call() {
                    return Win32ShellFolder2.getDisplayNameOf(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), 0);
                }
            });
        }
        return this.displayName;
    }

    private static native String getFolderType(long var0);

    @Override
    public String getFolderType() {
        if (this.folderType == null) {
            final long absolutePIDL = this.getAbsolutePIDL();
            this.folderType = Win32ShellFolder2.invoke(new Callable<String>(){

                @Override
                public String call() {
                    return Win32ShellFolder2.getFolderType(absolutePIDL);
                }
            });
        }
        return this.folderType;
    }

    private native String getExecutableType(String var1);

    @Override
    public String getExecutableType() {
        if (!this.isFileSystem()) {
            return null;
        }
        return this.getExecutableType(this.getAbsolutePath());
    }

    private static native long getIShellIcon(long var0);

    private static native int getIconIndex(long var0, long var2);

    private static native long getIcon(String var0, boolean var1);

    private static native long extractIcon(long var0, long var2, boolean var4);

    private static native long getSystemIcon(int var0);

    private static native long getIconResource(String var0, int var1, int var2, int var3, boolean var4);

    private static native int[] getIconBits(long var0, int var2);

    private static native void disposeIcon(long var0);

    static native int[] getStandardViewButton0(int var0);

    private long getIShellIcon() {
        if (this.pIShellIcon == -1L) {
            this.pIShellIcon = Win32ShellFolder2.getIShellIcon(this.getIShellFolder());
        }
        return this.pIShellIcon;
    }

    private static Image makeIcon(long hIcon, boolean getLargeIcon) {
        int size;
        int[] iconBits;
        if (hIcon != 0L && hIcon != -1L && (iconBits = Win32ShellFolder2.getIconBits(hIcon, size = getLargeIcon ? 32 : 16)) != null) {
            BufferedImage img = new BufferedImage(size, size, 2);
            img.setRGB(0, 0, size, size, iconBits, 0, size);
            return img;
        }
        return null;
    }

    @Override
    public Image getIcon(final boolean getLargeIcon) {
        Image icon;
        Image image = icon = getLargeIcon ? this.largeIcon : this.smallIcon;
        if (icon == null) {
            icon = Win32ShellFolder2.invoke(new Callable<Image>(){

                @Override
                public Image call() {
                    Map imageCache;
                    long relativePIDL;
                    long parentIShellIcon;
                    int index;
                    Image newIcon = null;
                    if (Win32ShellFolder2.this.isFileSystem() && (index = Win32ShellFolder2.getIconIndex(parentIShellIcon = Win32ShellFolder2.this.parent != null ? ((Win32ShellFolder2)Win32ShellFolder2.this.parent).getIShellIcon() : 0L, relativePIDL = Win32ShellFolder2.this.getRelativePIDL())) > 0 && (newIcon = (Image)(imageCache = Win32ShellFolder2.this.isLink() ? (getLargeIcon ? largeLinkedSystemImages : smallLinkedSystemImages) : (getLargeIcon ? largeSystemImages : smallSystemImages)).get(index)) == null) {
                        long hIcon = Win32ShellFolder2.getIcon(Win32ShellFolder2.this.getAbsolutePath(), getLargeIcon);
                        newIcon = Win32ShellFolder2.makeIcon(hIcon, getLargeIcon);
                        Win32ShellFolder2.disposeIcon(hIcon);
                        if (newIcon != null) {
                            imageCache.put(index, newIcon);
                        }
                    }
                    if (newIcon == null) {
                        long hIcon = Win32ShellFolder2.extractIcon(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), getLargeIcon);
                        newIcon = Win32ShellFolder2.makeIcon(hIcon, getLargeIcon);
                        Win32ShellFolder2.disposeIcon(hIcon);
                    }
                    if (newIcon == null) {
                        newIcon = Win32ShellFolder2.super.getIcon(getLargeIcon);
                    }
                    return newIcon;
                }
            });
            if (getLargeIcon) {
                this.largeIcon = icon;
            } else {
                this.smallIcon = icon;
            }
        }
        return icon;
    }

    static Image getSystemIcon(SystemIcon iconType) {
        long hIcon = Win32ShellFolder2.getSystemIcon(iconType.getIconID());
        Image icon = Win32ShellFolder2.makeIcon(hIcon, true);
        Win32ShellFolder2.disposeIcon(hIcon);
        return icon;
    }

    static Image getShell32Icon(int iconID, boolean getLargeIcon) {
        long hIcon;
        boolean useVGAColors = true;
        int size = getLargeIcon ? 32 : 16;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String shellIconBPP = (String)toolkit.getDesktopProperty("win.icon.shellIconBPP");
        if (shellIconBPP != null) {
            useVGAColors = shellIconBPP.equals("4");
        }
        if ((hIcon = Win32ShellFolder2.getIconResource("shell32.dll", iconID, size, size, useVGAColors)) != 0L) {
            Image icon = Win32ShellFolder2.makeIcon(hIcon, getLargeIcon);
            Win32ShellFolder2.disposeIcon(hIcon);
            return icon;
        }
        return null;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    public boolean isSpecial() {
        return this.isPersonal || !this.isFileSystem() || this == this.getDesktop();
    }

    @Override
    public int compareTo(File file2) {
        if (!(file2 instanceof Win32ShellFolder2)) {
            if (this.isFileSystem() && !this.isSpecial()) {
                return super.compareTo(file2);
            }
            return -1;
        }
        return Win32ShellFolderManager2.compareShellFolders(this, (Win32ShellFolder2)file2);
    }

    @Override
    public ShellFolderColumnInfo[] getFolderColumns() {
        return Win32ShellFolder2.invoke(new Callable<ShellFolderColumnInfo[]>(){

            @Override
            public ShellFolderColumnInfo[] call() {
                ShellFolderColumnInfo[] columns = Win32ShellFolder2.this.doGetColumnInfo(Win32ShellFolder2.this.getIShellFolder());
                if (columns != null) {
                    ArrayList<ShellFolderColumnInfo> notNullColumns = new ArrayList<ShellFolderColumnInfo>();
                    for (int i = 0; i < columns.length; ++i) {
                        ShellFolderColumnInfo column = columns[i];
                        if (column == null) continue;
                        column.setAlignment(column.getAlignment() == 1 ? 4 : (column.getAlignment() == 2 ? 0 : 10));
                        column.setComparator(new ColumnComparator(Win32ShellFolder2.this, i));
                        notNullColumns.add(column);
                    }
                    columns = new ShellFolderColumnInfo[notNullColumns.size()];
                    notNullColumns.toArray(columns);
                }
                return columns;
            }
        });
    }

    @Override
    public Object getFolderColumnValue(final int column) {
        return Win32ShellFolder2.invoke(new Callable<Object>(){

            @Override
            public Object call() {
                return Win32ShellFolder2.this.doGetColumnValue(Win32ShellFolder2.this.getParentIShellFolder(), Win32ShellFolder2.this.getRelativePIDL(), column);
            }
        });
    }

    private native ShellFolderColumnInfo[] doGetColumnInfo(long var1);

    private native Object doGetColumnValue(long var1, long var3, int var5);

    private static native int compareIDsByColumn(long var0, long var2, long var4, int var6);

    @Override
    public void sortChildren(final List<? extends File> files) {
        Win32ShellFolder2.invoke(new Callable<Void>(){

            @Override
            public Void call() {
                Collections.sort(files, new ColumnComparator(Win32ShellFolder2.this, 0));
                return null;
            }
        });
    }

    static {
        Win32ShellFolder2.initIDs();
        smallSystemImages = new HashMap();
        largeSystemImages = new HashMap();
        smallLinkedSystemImages = new HashMap();
        largeLinkedSystemImages = new HashMap();
    }

    private static class ColumnComparator
    implements Comparator<File> {
        private final Win32ShellFolder2 shellFolder;
        private final int columnIdx;

        public ColumnComparator(Win32ShellFolder2 shellFolder, int columnIdx) {
            this.shellFolder = shellFolder;
            this.columnIdx = columnIdx;
        }

        @Override
        public int compare(final File o, final File o1) {
            Integer result = ShellFolder.invoke(new Callable<Integer>(){

                @Override
                public Integer call() {
                    if (o instanceof Win32ShellFolder2 && o1 instanceof Win32ShellFolder2) {
                        return Win32ShellFolder2.compareIDsByColumn(shellFolder.getIShellFolder(), ((Win32ShellFolder2)o).getRelativePIDL(), ((Win32ShellFolder2)o1).getRelativePIDL(), columnIdx);
                    }
                    return 0;
                }
            });
            return result == null ? 0 : result;
        }
    }

    static class FolderDisposer
    implements DisposerRecord {
        long absolutePIDL;
        long pIShellFolder;
        long relativePIDL;
        boolean disposed;

        FolderDisposer() {
        }

        @Override
        public void dispose() {
            if (this.disposed) {
                return;
            }
            ShellFolder.invoke(new Callable<Void>(){

                @Override
                public Void call() {
                    if (relativePIDL != 0L) {
                        Win32ShellFolder2.releasePIDL(relativePIDL);
                    }
                    if (absolutePIDL != 0L) {
                        Win32ShellFolder2.releasePIDL(absolutePIDL);
                    }
                    if (pIShellFolder != 0L) {
                        Win32ShellFolder2.releaseIShellFolder(pIShellFolder);
                    }
                    return null;
                }
            });
            this.disposed = true;
        }
    }

    public static enum SystemIcon {
        IDI_APPLICATION(32512),
        IDI_HAND(32513),
        IDI_ERROR(32513),
        IDI_QUESTION(32514),
        IDI_EXCLAMATION(32515),
        IDI_WARNING(32515),
        IDI_ASTERISK(32516),
        IDI_INFORMATION(32516),
        IDI_WINLOGO(32517);

        private final int iconID;

        private SystemIcon(int iconID) {
            this.iconID = iconID;
        }

        public int getIconID() {
            return this.iconID;
        }
    }
}

