/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;
import sun.misc.JavaLangRefAccess;
import sun.misc.SharedSecrets;

public abstract class Reference<T> {
    private T referent;
    volatile ReferenceQueue<? super T> queue;
    Reference next;
    private transient Reference<T> discovered;
    private static Lock lock;
    private static Reference<Object> pending;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean tryHandlePending(boolean waitForNotify) {
        Cleaner c;
        Reference<Object> r;
        try {
            Lock lock = Reference.lock;
            synchronized (lock) {
                if (pending == null) {
                    if (waitForNotify) {
                        Reference.lock.wait();
                    }
                    return waitForNotify;
                }
                r = pending;
                c = r instanceof Cleaner ? (Cleaner)r : null;
                pending = r.discovered;
                r.discovered = null;
            }
        }
        catch (OutOfMemoryError x) {
            Thread.yield();
            return true;
        }
        catch (InterruptedException x) {
            return true;
        }
        if (c != null) {
            c.clean();
            return true;
        }
        ReferenceQueue<Object> q = r.queue;
        if (q != ReferenceQueue.NULL) {
            q.enqueue(r);
        }
        return true;
    }

    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    public boolean isEnqueued() {
        return this.queue == ReferenceQueue.ENQUEUED;
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(T referent) {
        this(referent, null);
    }

    Reference(T referent, ReferenceQueue<? super T> queue) {
        this.referent = referent;
        this.queue = queue == null ? ReferenceQueue.NULL : queue;
    }

    static {
        ThreadGroup tg;
        lock = new Lock();
        pending = null;
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        ReferenceHandler handler = new ReferenceHandler(tg, "Reference Handler");
        handler.setPriority(10);
        handler.setDaemon(true);
        handler.start();
        SharedSecrets.setJavaLangRefAccess(new JavaLangRefAccess(){

            @Override
            public boolean tryHandlePendingReference() {
                return Reference.tryHandlePending(false);
            }
        });
    }

    private static class ReferenceHandler
    extends Thread {
        private static void ensureClassInitialized(Class<?> clazz) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw (Error)new NoClassDefFoundError(e.getMessage()).initCause(e);
            }
        }

        ReferenceHandler(ThreadGroup g, String name) {
            super(g, name);
        }

        @Override
        public void run() {
            while (true) {
                Reference.tryHandlePending(true);
            }
        }

        static {
            ReferenceHandler.ensureClassInitialized(InterruptedException.class);
            ReferenceHandler.ensureClassInitialized(Cleaner.class);
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

