/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.zip.InflaterInputStream;

class CharacterName {
    private static SoftReference<byte[]> refStrPool;
    private static int[][] lookup;

    CharacterName() {
    }

    private static synchronized byte[] initNamePool() {
        byte[] strPool = null;
        if (refStrPool != null && (strPool = refStrPool.get()) != null) {
            return strPool;
        }
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new InflaterInputStream(AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return this.getClass().getResourceAsStream("uniName.dat");
                }
            })));
            lookup = new int[4352][];
            int total = ((DataInputStream)dis).readInt();
            int cpEnd = ((DataInputStream)dis).readInt();
            byte[] ba = new byte[cpEnd];
            ((DataInputStream)dis).readFully(ba);
            int nameOff = 0;
            int cpOff = 0;
            int cp = 0;
            do {
                int len;
                if ((len = ba[cpOff++] & 0xFF) == 0) {
                    len = ba[cpOff++] & 0xFF;
                    cp = (ba[cpOff++] & 0xFF) << 16 | (ba[cpOff++] & 0xFF) << 8 | ba[cpOff++] & 0xFF;
                } else {
                    ++cp;
                }
                int hi = cp >> 8;
                if (lookup[hi] == null) {
                    CharacterName.lookup[hi] = new int[256];
                }
                CharacterName.lookup[hi][cp & 0xFF] = nameOff << 8 | len;
                nameOff += len;
            } while (cpOff < cpEnd);
            strPool = new byte[total - cpEnd];
            ((DataInputStream)dis).readFully(strPool);
            refStrPool = new SoftReference<byte[]>(strPool);
        }
        catch (Exception x) {
            throw new InternalError(x.getMessage(), x);
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (Exception exception) {}
        }
        return strPool;
    }

    public static String get(int cp) {
        byte[] strPool = null;
        if (refStrPool == null || (strPool = refStrPool.get()) == null) {
            strPool = CharacterName.initNamePool();
        }
        int off = 0;
        if (lookup[cp >> 8] == null || (off = lookup[cp >> 8][cp & 0xFF]) == 0) {
            return null;
        }
        String result = new String(strPool, 0, off >>> 8, off & 0xFF);
        return result;
    }
}

